/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.eventflow;

import io.streamzi.eventflow.FlowController;
import io.streamzi.eventflow.FlowWatcher;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Executor {
    private static Logger logger;

    public static void main(String[] args) {
        logger.info("\ud83c\udf0a Starting Flow Controller \ud83c\udf0a");
        FlowWatcher fw = new FlowWatcher(new FlowController());
        ExecutorService executor = Executors.newFixedThreadPool(1);
        executor.submit(fw);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            logger.info("Shutting down");
            executor.shutdown();
            try {
                executor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                logger.severe("Error on close: " + ie.getMessage());
            }
        }));
    }

    static {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("logging.properties");
        try {
            LogManager.getLogManager().readConfiguration(stream);
            logger = Logger.getLogger(Executor.class.getName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

