/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.eventflow.serialization;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.streamzi.eventflow.model.ProcessorLink;

public class SerializedLink {
    @JsonIgnore
    private ProcessorLink link;
    private String sourceUuid;
    private String targetUuid;
    private String sourcePortName;
    private String targetPortName;

    public SerializedLink() {
    }

    public SerializedLink(ProcessorLink link) {
        this.setLink(link);
    }

    public void setLink(ProcessorLink link) {
        this.link = link;
        this.sourcePortName = link.getSource().getName();
        this.sourceUuid = link.getSource().getParent().getUuid();
        this.targetPortName = link.getTarget().getName();
        this.targetUuid = link.getTarget().getParent().getUuid();
    }

    public String getSourcePortName() {
        return this.sourcePortName;
    }

    public void setSourcePortName(String sourcePortName) {
        this.sourcePortName = sourcePortName;
    }

    public String getTargetPortName() {
        return this.targetPortName;
    }

    public void setTargetPortName(String targetPortName) {
        this.targetPortName = targetPortName;
    }

    public String getSourceUuid() {
        return this.sourceUuid;
    }

    public void setSourceUuid(String sourceUuid) {
        this.sourceUuid = sourceUuid;
    }

    public String getTargetUuid() {
        return this.targetUuid;
    }

    public void setTargetUuid(String targetUuid) {
        this.targetUuid = targetUuid;
    }

    public String toString() {
        return "SerializedLink{link=" + this.link + ", sourceUuid='" + this.sourceUuid + '\'' + ", targetUuid='" + this.targetUuid + '\'' + ", sourcePortName='" + this.sourcePortName + '\'' + ", targetPortName='" + this.targetPortName + '\'' + '}';
    }
}

