/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka;

import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.CustomResourceDoneable;
import io.fabric8.kubernetes.client.CustomResourceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import io.strimzi.api.kafka.KafkaAssemblyList;
import io.strimzi.api.kafka.KafkaConnectAssemblyList;
import io.strimzi.api.kafka.KafkaConnectS2IAssemblyList;
import io.strimzi.api.kafka.KafkaTopicList;
import io.strimzi.api.kafka.KafkaUserList;
import io.strimzi.api.kafka.model.DoneableKafka;
import io.strimzi.api.kafka.model.DoneableKafkaConnect;
import io.strimzi.api.kafka.model.DoneableKafkaConnectS2I;
import io.strimzi.api.kafka.model.DoneableKafkaTopic;
import io.strimzi.api.kafka.model.DoneableKafkaUser;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.api.kafka.model.KafkaConnect;
import io.strimzi.api.kafka.model.KafkaConnectS2I;
import io.strimzi.api.kafka.model.KafkaTopic;
import io.strimzi.api.kafka.model.KafkaUser;
import java.util.Collections;
import java.util.List;

public class Crds {
    public static final String CRD_KIND = "CustomResourceDefinition";
    private static final Class<? extends CustomResource>[] CRDS = new Class[]{Kafka.class, KafkaConnect.class, KafkaConnectS2I.class, KafkaTopic.class, KafkaUser.class};

    private Crds() {
    }

    public static void registerCustomKinds() {
        for (Class<? extends CustomResource> c : CRDS) {
            KubernetesDeserializer.registerCustomKind(Crds.kind(c), c);
        }
    }

    private static CustomResourceDefinition crd(Class<? extends CustomResource> cls) {
        String version;
        String group;
        String listKind;
        String singular;
        String plural;
        String crdApiVersion;
        String kind;
        List<String> shortNames = Collections.emptyList();
        if (cls.equals(Kafka.class)) {
            kind = "Kafka";
            crdApiVersion = "apiextensions.k8s.io/v1beta1";
            plural = "kafkas";
            singular = "kafka";
            listKind = "KafkaList";
            group = "kafka.strimzi.io";
            version = "v1alpha1";
        } else if (cls.equals(KafkaConnect.class)) {
            kind = "KafkaConnect";
            crdApiVersion = "apiextensions.k8s.io/v1beta1";
            plural = "kafkaconnects";
            singular = "kafkaconnect";
            listKind = "KafkaConnectList";
            group = "kafka.strimzi.io";
            version = "v1alpha1";
        } else if (cls.equals(KafkaConnectS2I.class)) {
            kind = "KafkaConnectS2I";
            crdApiVersion = "apiextensions.k8s.io/v1beta1";
            plural = "kafkaconnects2is";
            singular = "kafkaconnects2i";
            listKind = "KafkaConnectS2IList";
            group = "kafka.strimzi.io";
            version = "v1alpha1";
        } else if (cls.equals(KafkaTopic.class)) {
            kind = "KafkaTopic";
            crdApiVersion = "apiextensions.k8s.io/v1beta1";
            plural = "kafkatopics";
            singular = "kafkatopic";
            listKind = "KafkaTopicList";
            group = "kafka.strimzi.io";
            version = "v1alpha1";
            shortNames = KafkaTopic.RESOURCE_SHORTNAMES;
        } else if (cls.equals(KafkaUser.class)) {
            kind = "KafkaUser";
            crdApiVersion = "apiextensions.k8s.io/v1beta1";
            plural = "kafkausers";
            singular = "kafkauser";
            listKind = "KafkaUserList";
            group = "kafka.strimzi.io";
            version = "v1alpha1";
            shortNames = KafkaUser.RESOURCE_SHORTNAMES;
        } else {
            throw new RuntimeException();
        }
        return ((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionSpecFluent.NamesNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.MetadataNested)((CustomResourceDefinitionBuilder)((CustomResourceDefinitionBuilder)new CustomResourceDefinitionBuilder().withApiVersion(crdApiVersion)).withKind(CRD_KIND)).withNewMetadata().withName(plural + "." + group)).endMetadata()).withNewSpec().withGroup(group)).withVersion(version)).withNewNames().withKind(kind)).withListKind(listKind)).withPlural(plural)).withSingular(singular)).withShortNames(shortNames)).endNames()).endSpec()).build();
    }

    public static CustomResourceDefinition kafka() {
        return Crds.crd(Kafka.class);
    }

    public static MixedOperation<Kafka, KafkaAssemblyList, DoneableKafka, Resource<Kafka, DoneableKafka>> kafkaOperation(KubernetesClient client) {
        return client.customResources(Crds.kafka(), Kafka.class, KafkaAssemblyList.class, DoneableKafka.class);
    }

    public static CustomResourceDefinition kafkaConnect() {
        return Crds.crd(KafkaConnect.class);
    }

    public static MixedOperation<KafkaConnect, KafkaConnectAssemblyList, DoneableKafkaConnect, Resource<KafkaConnect, DoneableKafkaConnect>> kafkaConnectOperation(KubernetesClient client) {
        return client.customResources(Crds.kafkaConnect(), KafkaConnect.class, KafkaConnectAssemblyList.class, DoneableKafkaConnect.class);
    }

    public static CustomResourceDefinition kafkaConnectS2I() {
        return Crds.crd(KafkaConnectS2I.class);
    }

    public static <D extends CustomResourceDoneable<T>, T extends CustomResource> MixedOperation<KafkaConnectS2I, KafkaConnectS2IAssemblyList, DoneableKafkaConnectS2I, Resource<KafkaConnectS2I, DoneableKafkaConnectS2I>> kafkaConnectS2iOperation(KubernetesClient client) {
        return client.customResources(Crds.kafkaConnectS2I(), KafkaConnectS2I.class, KafkaConnectS2IAssemblyList.class, DoneableKafkaConnectS2I.class);
    }

    public static CustomResourceDefinition topic() {
        return Crds.crd(KafkaTopic.class);
    }

    public static MixedOperation<KafkaTopic, KafkaTopicList, DoneableKafkaTopic, Resource<KafkaTopic, DoneableKafkaTopic>> topicOperation(KubernetesClient client) {
        return client.customResources(Crds.topic(), KafkaTopic.class, KafkaTopicList.class, DoneableKafkaTopic.class);
    }

    public static CustomResourceDefinition kafkaUser() {
        return Crds.crd(KafkaUser.class);
    }

    public static MixedOperation<KafkaUser, KafkaUserList, DoneableKafkaUser, Resource<KafkaUser, DoneableKafkaUser>> kafkaUserOperation(KubernetesClient client) {
        return client.customResources(Crds.kafkaUser(), KafkaUser.class, KafkaUserList.class, DoneableKafkaUser.class);
    }

    public static <T extends CustomResource, L extends CustomResourceList<T>, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> operation(KubernetesClient client, Class<T> cls, Class<L> listCls, Class<D> doneableCls) {
        return client.customResources(Crds.crd(cls), cls, listCls, doneableCls);
    }

    public static <T extends CustomResource> String kind(Class<T> cls) {
        try {
            return ((CustomResource)cls.newInstance()).getKind();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

