/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.Toleration;
import io.strimzi.api.kafka.model.ExternalLogging;
import io.strimzi.api.kafka.model.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.ExternalLoggingFluentImpl;
import io.strimzi.api.kafka.model.InlineLogging;
import io.strimzi.api.kafka.model.InlineLoggingBuilder;
import io.strimzi.api.kafka.model.InlineLoggingFluentImpl;
import io.strimzi.api.kafka.model.JvmOptions;
import io.strimzi.api.kafka.model.JvmOptionsBuilder;
import io.strimzi.api.kafka.model.JvmOptionsFluentImpl;
import io.strimzi.api.kafka.model.KafkaConnectAuthentication;
import io.strimzi.api.kafka.model.KafkaConnectAuthenticationScramSha512;
import io.strimzi.api.kafka.model.KafkaConnectAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.KafkaConnectAuthenticationScramSha512FluentImpl;
import io.strimzi.api.kafka.model.KafkaConnectAuthenticationTls;
import io.strimzi.api.kafka.model.KafkaConnectAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.KafkaConnectAuthenticationTlsFluentImpl;
import io.strimzi.api.kafka.model.KafkaConnectSpec;
import io.strimzi.api.kafka.model.KafkaConnectSpecFluent;
import io.strimzi.api.kafka.model.KafkaConnectTls;
import io.strimzi.api.kafka.model.KafkaConnectTlsBuilder;
import io.strimzi.api.kafka.model.KafkaConnectTlsFluentImpl;
import io.strimzi.api.kafka.model.Logging;
import io.strimzi.api.kafka.model.Probe;
import io.strimzi.api.kafka.model.ProbeBuilder;
import io.strimzi.api.kafka.model.ProbeFluentImpl;
import io.strimzi.api.kafka.model.Resources;
import io.strimzi.api.kafka.model.ResourcesBuilder;
import io.strimzi.api.kafka.model.ResourcesFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class KafkaConnectSpecFluentImpl<A extends KafkaConnectSpecFluent<A>>
extends BaseFluent<A>
implements KafkaConnectSpecFluent<A> {
    private Map<String, Object> config;
    private VisitableBuilder<? extends Logging, ?> logging;
    private int replicas;
    private String image;
    private ResourcesBuilder resources;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private JvmOptionsBuilder jvmOptions;
    private Map<String, Object> metrics;
    private Affinity affinity;
    private List<Toleration> tolerations;
    private String bootstrapServers;
    private KafkaConnectTlsBuilder tls;
    private VisitableBuilder<? extends KafkaConnectAuthentication, ?> authentication;

    public KafkaConnectSpecFluentImpl() {
    }

    public KafkaConnectSpecFluentImpl(KafkaConnectSpec instance) {
        this.withConfig(instance.getConfig());
        this.withLogging(instance.getLogging());
        this.withReplicas(instance.getReplicas());
        this.withImage(instance.getImage());
        this.withResources(instance.getResources());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withJvmOptions(instance.getJvmOptions());
        this.withMetrics(instance.getMetrics());
        this.withAffinity(instance.getAffinity());
        this.withTolerations(instance.getTolerations());
        this.withBootstrapServers(instance.getBootstrapServers());
        this.withTls(instance.getTls());
        this.withAuthentication(instance.getAuthentication());
    }

    @Override
    public A addToConfig(String key, Object value) {
        if (key != null && value != null) {
            this.config.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToConfig(Map<String, Object> map) {
        if (map != null) {
            this.config.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(String key) {
        if (key != null && this.config != null) {
            this.config.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.config == null) continue;
                this.config.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Override
    public A withConfig(Map<String, Object> config) {
        if (this.config == null) {
            this.config = new LinkedHashMap<String, Object>();
        } else {
            this.config.clear();
        }
        if (config != null) {
            this.config.putAll(config);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfig() {
        return this.config != null;
    }

    @Override
    @Deprecated
    public Logging getLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    @Override
    public Logging buildLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    @Override
    public A withLogging(Logging logging) {
        if (logging instanceof ExternalLogging) {
            this.logging = new ExternalLoggingBuilder((ExternalLogging)logging);
            this._visitables.add(this.logging);
        }
        if (logging instanceof InlineLogging) {
            this.logging = new InlineLoggingBuilder((InlineLogging)logging);
            this._visitables.add(this.logging);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLogging() {
        return this.logging != null;
    }

    @Override
    public A withExternalLoggingLogging(ExternalLogging externalLoggingLogging) {
        this._visitables.remove(this.logging);
        if (externalLoggingLogging != null) {
            this.logging = new ExternalLoggingBuilder(externalLoggingLogging);
            this._visitables.add(this.logging);
        }
        return (A)this;
    }

    @Override
    public KafkaConnectSpecFluent.ExternalLoggingLoggingNested<A> withNewExternalLoggingLogging() {
        return new ExternalLoggingLoggingNestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.ExternalLoggingLoggingNested<A> withNewExternalLoggingLoggingLike(ExternalLogging item) {
        return new ExternalLoggingLoggingNestedImpl(item);
    }

    @Override
    public A withInlineLoggingLogging(InlineLogging inlineLoggingLogging) {
        this._visitables.remove(this.logging);
        if (inlineLoggingLogging != null) {
            this.logging = new InlineLoggingBuilder(inlineLoggingLogging);
            this._visitables.add(this.logging);
        }
        return (A)this;
    }

    @Override
    public KafkaConnectSpecFluent.InlineLoggingLoggingNested<A> withNewInlineLoggingLogging() {
        return new InlineLoggingLoggingNestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.InlineLoggingLoggingNested<A> withNewInlineLoggingLoggingLike(InlineLogging item) {
        return new InlineLoggingLoggingNestedImpl(item);
    }

    @Override
    public int getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(int replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return true;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    @Deprecated
    public Resources getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public Resources buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(Resources resources) {
        this._visitables.remove(this.resources);
        if (resources != null) {
            this.resources = new ResourcesBuilder(resources);
            this._visitables.add(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public KafkaConnectSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.ResourcesNested<A> withNewResourcesLike(Resources item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public KafkaConnectSpecFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public KafkaConnectSpecFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new ResourcesBuilder().build());
    }

    @Override
    public KafkaConnectSpecFluent.ResourcesNested<A> editOrNewResourcesLike(Resources item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    @Deprecated
    public Probe getLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.remove(this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.add(this.livenessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    @Override
    public A withNewLivenessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    @Override
    public KafkaConnectSpecFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNestedImpl(item);
    }

    @Override
    public KafkaConnectSpecFluent.LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe());
    }

    @Override
    public KafkaConnectSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : new ProbeBuilder().build());
    }

    @Override
    public KafkaConnectSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : item);
    }

    @Override
    @Deprecated
    public Probe getReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.remove(this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.add(this.readinessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    @Override
    public A withNewReadinessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    @Override
    public KafkaConnectSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNestedImpl(item);
    }

    @Override
    public KafkaConnectSpecFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe());
    }

    @Override
    public KafkaConnectSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : new ProbeBuilder().build());
    }

    @Override
    public KafkaConnectSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : item);
    }

    @Override
    @Deprecated
    public JvmOptions getJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    @Override
    public JvmOptions buildJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    @Override
    public A withJvmOptions(JvmOptions jvmOptions) {
        this._visitables.remove(this.jvmOptions);
        if (jvmOptions != null) {
            this.jvmOptions = new JvmOptionsBuilder(jvmOptions);
            this._visitables.add(this.jvmOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    @Override
    public KafkaConnectSpecFluent.JvmOptionsNested<A> withNewJvmOptions() {
        return new JvmOptionsNestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
        return new JvmOptionsNestedImpl(item);
    }

    @Override
    public KafkaConnectSpecFluent.JvmOptionsNested<A> editJvmOptions() {
        return this.withNewJvmOptionsLike(this.getJvmOptions());
    }

    @Override
    public KafkaConnectSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions() {
        return this.withNewJvmOptionsLike(this.getJvmOptions() != null ? this.getJvmOptions() : new JvmOptionsBuilder().build());
    }

    @Override
    public KafkaConnectSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
        return this.withNewJvmOptionsLike(this.getJvmOptions() != null ? this.getJvmOptions() : item);
    }

    @Override
    public A addToMetrics(String key, Object value) {
        if (key != null && value != null) {
            this.metrics.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToMetrics(Map<String, Object> map) {
        if (map != null) {
            this.metrics.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetrics(String key) {
        if (key != null && this.metrics != null) {
            this.metrics.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetrics(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.metrics == null) continue;
                this.metrics.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getMetrics() {
        return this.metrics;
    }

    @Override
    public A withMetrics(Map<String, Object> metrics) {
        if (this.metrics == null) {
            this.metrics = new LinkedHashMap<String, Object>();
        } else {
            this.metrics.clear();
        }
        if (metrics != null) {
            this.metrics.putAll(metrics);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetrics() {
        return this.metrics != null;
    }

    @Override
    public Affinity getAffinity() {
        return this.affinity;
    }

    @Override
    public A withAffinity(Affinity affinity) {
        this.affinity = affinity;
        return (A)this;
    }

    @Override
    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    @Override
    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTolerations(int index, Toleration item) {
        this.tolerations.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTolerations(Toleration ... items) {
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTolerations(Toleration ... items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    @Override
    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    @Override
    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    @Override
    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    @Override
    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withTolerations(List<Toleration> tolerations) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        } else {
            this._visitables.removeAll(this.tolerations);
            this.tolerations.clear();
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withTolerations(Toleration ... tolerations) {
        this.tolerations.clear();
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    @Override
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @Override
    public A withBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        return (A)this;
    }

    @Override
    public Boolean hasBootstrapServers() {
        return this.bootstrapServers != null;
    }

    @Override
    @Deprecated
    public KafkaConnectTls getTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    @Override
    public KafkaConnectTls buildTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    @Override
    public A withTls(KafkaConnectTls tls) {
        this._visitables.remove(this.tls);
        if (tls != null) {
            this.tls = new KafkaConnectTlsBuilder(tls);
            this._visitables.add(this.tls);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTls() {
        return this.tls != null;
    }

    @Override
    public KafkaConnectSpecFluent.TlsNested<A> withNewTls() {
        return new TlsNestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.TlsNested<A> withNewTlsLike(KafkaConnectTls item) {
        return new TlsNestedImpl(item);
    }

    @Override
    public KafkaConnectSpecFluent.TlsNested<A> editTls() {
        return this.withNewTlsLike(this.getTls());
    }

    @Override
    public KafkaConnectSpecFluent.TlsNested<A> editOrNewTls() {
        return this.withNewTlsLike(this.getTls() != null ? this.getTls() : new KafkaConnectTlsBuilder().build());
    }

    @Override
    public KafkaConnectSpecFluent.TlsNested<A> editOrNewTlsLike(KafkaConnectTls item) {
        return this.withNewTlsLike(this.getTls() != null ? this.getTls() : item);
    }

    @Override
    @Deprecated
    public KafkaConnectAuthentication getAuthentication() {
        return this.authentication != null ? (KafkaConnectAuthentication)this.authentication.build() : null;
    }

    @Override
    public KafkaConnectAuthentication buildAuthentication() {
        return this.authentication != null ? (KafkaConnectAuthentication)this.authentication.build() : null;
    }

    @Override
    public A withAuthentication(KafkaConnectAuthentication authentication) {
        if (authentication instanceof KafkaConnectAuthenticationTls) {
            this.authentication = new KafkaConnectAuthenticationTlsBuilder((KafkaConnectAuthenticationTls)authentication);
            this._visitables.add(this.authentication);
        }
        if (authentication instanceof KafkaConnectAuthenticationScramSha512) {
            this.authentication = new KafkaConnectAuthenticationScramSha512Builder((KafkaConnectAuthenticationScramSha512)authentication);
            this._visitables.add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthentication() {
        return this.authentication != null;
    }

    @Override
    public A withKafkaConnectAuthenticationTlsAuthentication(KafkaConnectAuthenticationTls kafkaConnectAuthenticationTlsAuthentication) {
        this._visitables.remove(this.authentication);
        if (kafkaConnectAuthenticationTlsAuthentication != null) {
            this.authentication = new KafkaConnectAuthenticationTlsBuilder(kafkaConnectAuthenticationTlsAuthentication);
            this._visitables.add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public KafkaConnectSpecFluent.KafkaConnectAuthenticationTlsAuthenticationNested<A> withNewKafkaConnectAuthenticationTlsAuthentication() {
        return new KafkaConnectAuthenticationTlsAuthenticationNestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.KafkaConnectAuthenticationTlsAuthenticationNested<A> withNewKafkaConnectAuthenticationTlsAuthenticationLike(KafkaConnectAuthenticationTls item) {
        return new KafkaConnectAuthenticationTlsAuthenticationNestedImpl(item);
    }

    @Override
    public A withKafkaConnectAuthenticationScramSha512Authentication(KafkaConnectAuthenticationScramSha512 kafkaConnectAuthenticationScramSha512Authentication) {
        this._visitables.remove(this.authentication);
        if (kafkaConnectAuthenticationScramSha512Authentication != null) {
            this.authentication = new KafkaConnectAuthenticationScramSha512Builder(kafkaConnectAuthenticationScramSha512Authentication);
            this._visitables.add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public KafkaConnectSpecFluent.KafkaConnectAuthenticationScramSha512AuthenticationNested<A> withNewKafkaConnectAuthenticationScramSha512Authentication() {
        return new KafkaConnectAuthenticationScramSha512AuthenticationNestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.KafkaConnectAuthenticationScramSha512AuthenticationNested<A> withNewKafkaConnectAuthenticationScramSha512AuthenticationLike(KafkaConnectAuthenticationScramSha512 item) {
        return new KafkaConnectAuthenticationScramSha512AuthenticationNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaConnectSpecFluentImpl that = (KafkaConnectSpecFluentImpl)o;
        if (this.config != null ? !this.config.equals(that.config) : that.config != null) {
            return false;
        }
        if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) {
            return false;
        }
        if (this.replicas != that.replicas) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.livenessProbe != null ? !this.livenessProbe.equals(that.livenessProbe) : that.livenessProbe != null) {
            return false;
        }
        if (this.readinessProbe != null ? !this.readinessProbe.equals(that.readinessProbe) : that.readinessProbe != null) {
            return false;
        }
        if (this.jvmOptions != null ? !this.jvmOptions.equals(that.jvmOptions) : that.jvmOptions != null) {
            return false;
        }
        if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) {
            return false;
        }
        if (this.affinity != null ? !this.affinity.equals(that.affinity) : that.affinity != null) {
            return false;
        }
        if (this.tolerations != null ? !this.tolerations.equals(that.tolerations) : that.tolerations != null) {
            return false;
        }
        if (this.bootstrapServers != null ? !this.bootstrapServers.equals(that.bootstrapServers) : that.bootstrapServers != null) {
            return false;
        }
        if (this.tls != null ? !this.tls.equals(that.tls) : that.tls != null) {
            return false;
        }
        return !(this.authentication != null ? !this.authentication.equals(that.authentication) : that.authentication != null);
    }

    public class KafkaConnectAuthenticationScramSha512AuthenticationNestedImpl<N>
    extends KafkaConnectAuthenticationScramSha512FluentImpl<KafkaConnectSpecFluent.KafkaConnectAuthenticationScramSha512AuthenticationNested<N>>
    implements KafkaConnectSpecFluent.KafkaConnectAuthenticationScramSha512AuthenticationNested<N>,
    Nested<N> {
        private final KafkaConnectAuthenticationScramSha512Builder builder;

        KafkaConnectAuthenticationScramSha512AuthenticationNestedImpl(KafkaConnectAuthenticationScramSha512 item) {
            this.builder = new KafkaConnectAuthenticationScramSha512Builder(this, item);
        }

        KafkaConnectAuthenticationScramSha512AuthenticationNestedImpl() {
            this.builder = new KafkaConnectAuthenticationScramSha512Builder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withKafkaConnectAuthenticationScramSha512Authentication(this.builder.build());
        }

        @Override
        public N endKafkaConnectAuthenticationScramSha512Authentication() {
            return this.and();
        }
    }

    public class KafkaConnectAuthenticationTlsAuthenticationNestedImpl<N>
    extends KafkaConnectAuthenticationTlsFluentImpl<KafkaConnectSpecFluent.KafkaConnectAuthenticationTlsAuthenticationNested<N>>
    implements KafkaConnectSpecFluent.KafkaConnectAuthenticationTlsAuthenticationNested<N>,
    Nested<N> {
        private final KafkaConnectAuthenticationTlsBuilder builder;

        KafkaConnectAuthenticationTlsAuthenticationNestedImpl(KafkaConnectAuthenticationTls item) {
            this.builder = new KafkaConnectAuthenticationTlsBuilder(this, item);
        }

        KafkaConnectAuthenticationTlsAuthenticationNestedImpl() {
            this.builder = new KafkaConnectAuthenticationTlsBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withKafkaConnectAuthenticationTlsAuthentication(this.builder.build());
        }

        @Override
        public N endKafkaConnectAuthenticationTlsAuthentication() {
            return this.and();
        }
    }

    public class TlsNestedImpl<N>
    extends KafkaConnectTlsFluentImpl<KafkaConnectSpecFluent.TlsNested<N>>
    implements KafkaConnectSpecFluent.TlsNested<N>,
    Nested<N> {
        private final KafkaConnectTlsBuilder builder;

        TlsNestedImpl(KafkaConnectTls item) {
            this.builder = new KafkaConnectTlsBuilder(this, item);
        }

        TlsNestedImpl() {
            this.builder = new KafkaConnectTlsBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withTls(this.builder.build());
        }

        @Override
        public N endTls() {
            return this.and();
        }
    }

    public class JvmOptionsNestedImpl<N>
    extends JvmOptionsFluentImpl<KafkaConnectSpecFluent.JvmOptionsNested<N>>
    implements KafkaConnectSpecFluent.JvmOptionsNested<N>,
    Nested<N> {
        private final JvmOptionsBuilder builder;

        JvmOptionsNestedImpl(JvmOptions item) {
            this.builder = new JvmOptionsBuilder(this, item);
        }

        JvmOptionsNestedImpl() {
            this.builder = new JvmOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withJvmOptions(this.builder.build());
        }

        @Override
        public N endJvmOptions() {
            return this.and();
        }
    }

    public class ReadinessProbeNestedImpl<N>
    extends ProbeFluentImpl<KafkaConnectSpecFluent.ReadinessProbeNested<N>>
    implements KafkaConnectSpecFluent.ReadinessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        ReadinessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        ReadinessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withReadinessProbe(this.builder.build());
        }

        @Override
        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class LivenessProbeNestedImpl<N>
    extends ProbeFluentImpl<KafkaConnectSpecFluent.LivenessProbeNested<N>>
    implements KafkaConnectSpecFluent.LivenessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        LivenessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        LivenessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withLivenessProbe(this.builder.build());
        }

        @Override
        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class ResourcesNestedImpl<N>
    extends ResourcesFluentImpl<KafkaConnectSpecFluent.ResourcesNested<N>>
    implements KafkaConnectSpecFluent.ResourcesNested<N>,
    Nested<N> {
        private final ResourcesBuilder builder;

        ResourcesNestedImpl(Resources item) {
            this.builder = new ResourcesBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourcesBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    public class InlineLoggingLoggingNestedImpl<N>
    extends InlineLoggingFluentImpl<KafkaConnectSpecFluent.InlineLoggingLoggingNested<N>>
    implements KafkaConnectSpecFluent.InlineLoggingLoggingNested<N>,
    Nested<N> {
        private final InlineLoggingBuilder builder;

        InlineLoggingLoggingNestedImpl(InlineLogging item) {
            this.builder = new InlineLoggingBuilder(this, item);
        }

        InlineLoggingLoggingNestedImpl() {
            this.builder = new InlineLoggingBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withInlineLoggingLogging(this.builder.build());
        }

        @Override
        public N endInlineLoggingLogging() {
            return this.and();
        }
    }

    public class ExternalLoggingLoggingNestedImpl<N>
    extends ExternalLoggingFluentImpl<KafkaConnectSpecFluent.ExternalLoggingLoggingNested<N>>
    implements KafkaConnectSpecFluent.ExternalLoggingLoggingNested<N>,
    Nested<N> {
        private final ExternalLoggingBuilder builder;

        ExternalLoggingLoggingNestedImpl(ExternalLogging item) {
            this.builder = new ExternalLoggingBuilder(this, item);
        }

        ExternalLoggingLoggingNestedImpl() {
            this.builder = new ExternalLoggingBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withExternalLoggingLogging(this.builder.build());
        }

        @Override
        public N endExternalLoggingLogging() {
            return this.and();
        }
    }
}

