/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.KafkaTopicSpec;
import io.strimzi.api.kafka.model.KafkaTopicSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;

public class KafkaTopicSpecFluentImpl<A extends KafkaTopicSpecFluent<A>>
extends BaseFluent<A>
implements KafkaTopicSpecFluent<A> {
    private String topicName;
    private Integer partitions;
    private Integer replicas;
    private Map<String, Object> config;

    public KafkaTopicSpecFluentImpl() {
    }

    public KafkaTopicSpecFluentImpl(KafkaTopicSpec instance) {
        this.withTopicName(instance.getTopicName());
        this.withPartitions(instance.getPartitions());
        this.withReplicas(instance.getReplicas());
        this.withConfig(instance.getConfig());
    }

    @Override
    public String getTopicName() {
        return this.topicName;
    }

    @Override
    public A withTopicName(String topicName) {
        this.topicName = topicName;
        return (A)this;
    }

    @Override
    public Boolean hasTopicName() {
        return this.topicName != null;
    }

    @Override
    public Integer getPartitions() {
        return this.partitions;
    }

    @Override
    public A withPartitions(Integer partitions) {
        this.partitions = partitions;
        return (A)this;
    }

    @Override
    public Boolean hasPartitions() {
        return this.partitions != null;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public A addToConfig(String key, Object value) {
        if (key != null && value != null) {
            this.config.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToConfig(Map<String, Object> map) {
        if (map != null) {
            this.config.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(String key) {
        if (key != null && this.config != null) {
            this.config.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.config == null) continue;
                this.config.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Override
    public A withConfig(Map<String, Object> config) {
        if (this.config == null) {
            this.config = new LinkedHashMap<String, Object>();
        } else {
            this.config.clear();
        }
        if (config != null) {
            this.config.putAll(config);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfig() {
        return this.config != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaTopicSpecFluentImpl that = (KafkaTopicSpecFluentImpl)o;
        if (this.topicName != null ? !this.topicName.equals(that.topicName) : that.topicName != null) {
            return false;
        }
        if (this.partitions != null ? !this.partitions.equals(that.partitions) : that.partitions != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        return !(this.config != null ? !this.config.equals(that.config) : that.config != null);
    }
}

