/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.Sidecar;
import io.strimzi.api.kafka.model.SidecarFluent;
import io.strimzi.api.kafka.model.SidecarFluentImpl;

public class SidecarBuilder
extends SidecarFluentImpl<SidecarBuilder>
implements VisitableBuilder<Sidecar, SidecarBuilder> {
    SidecarFluent<?> fluent;
    Boolean validationEnabled;

    public SidecarBuilder() {
        this(true);
    }

    public SidecarBuilder(Boolean validationEnabled) {
        this(new Sidecar(), validationEnabled);
    }

    public SidecarBuilder(SidecarFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SidecarBuilder(SidecarFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Sidecar(), validationEnabled);
    }

    public SidecarBuilder(SidecarFluent<?> fluent, Sidecar instance) {
        this(fluent, instance, true);
    }

    public SidecarBuilder(SidecarFluent<?> fluent, Sidecar instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withImage(instance.getImage());
        fluent.withResources(instance.getResources());
        this.validationEnabled = validationEnabled;
    }

    public SidecarBuilder(Sidecar instance) {
        this(instance, (Boolean)true);
    }

    public SidecarBuilder(Sidecar instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withImage(instance.getImage());
        this.withResources(instance.getResources());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Sidecar build() {
        Sidecar buildable = new Sidecar();
        buildable.setImage(this.fluent.getImage());
        buildable.setResources(this.fluent.getResources());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SidecarBuilder that = (SidecarBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

