/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.eventflow.runtime;

import eu.infomas.annotation.AnnotationDetector;
import io.streamzi.eventflow.annotations.CloudEventComponent;
import io.streamzi.eventflow.runtime.ProcessorContainer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessorRunner
implements Runnable {
    private static final Logger logger = Logger.getLogger(ProcessorRunner.class.getName());
    private List<ProcessorContainer> containers = new ArrayList<ProcessorContainer>();
    private volatile boolean stopFlag = false;

    public void stop() {
        this.stopFlag = true;
    }

    @Override
    public void run() {
        this.scanForComponents();
        this.startComponents();
        while (!this.stopFlag) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        this.stopComponents();
    }

    private void scanForComponents() {
        try {
            AnnotationDetector.TypeReporter reporter = new AnnotationDetector.TypeReporter(){

                public void reportTypeAnnotation(Class<? extends Annotation> annotation, String className) {
                    logger.info("Found processor class: " + className);
                    try {
                        Class<?> processorClass = Class.forName(className);
                        ProcessorContainer container = new ProcessorContainer(processorClass);
                        ProcessorRunner.this.containers.add(container);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Error creating processor class; " + e.getMessage(), e.getMessage());
                    }
                }

                public Class<? extends Annotation>[] annotations() {
                    return new Class[]{CloudEventComponent.class};
                }
            };
            AnnotationDetector detector = new AnnotationDetector((AnnotationDetector.Reporter)reporter);
            detector.detect();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception", e);
        }
    }

    private void startComponents() {
        for (ProcessorContainer container : this.containers) {
            container.startProcessor();
        }
    }

    private void stopComponents() {
        for (ProcessorContainer container : this.containers) {
            container.stopProcessor();
        }
    }

    public static void main(String[] args) {
        Map<String, String> env = System.getenv();
        for (String key : env.keySet()) {
            logger.info(key + "=" + env.get(key));
        }
        ProcessorRunner runner = new ProcessorRunner();
        new Thread(runner).start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            logger.warning("SHUTDOWN");
            System.exit(0);
        }));
    }
}

