/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.eventflow.runtime;

import io.streamzi.eventflow.annotations.CloudEventComponentTimer;
import java.lang.reflect.Method;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CloudEventTimer {
    private static final Logger logger = Logger.getLogger(CloudEventTimer.class.getName());
    private Object timedObject;
    private Method timerMethod;
    private int interval = 1000;
    private Timer timer;

    public CloudEventTimer() {
    }

    public CloudEventTimer(Object timedObject, Method timerMethod) {
        this.timedObject = timedObject;
        this.timerMethod = timerMethod;
        CloudEventComponentTimer annotation = timerMethod.getAnnotation(CloudEventComponentTimer.class);
        if (annotation != null) {
            this.interval = annotation.interval();
        }
    }

    public void startTimer() {
        if (this.timer == null) {
            this.timer = new Timer(this.timerMethod.getName(), true);
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    try {
                        CloudEventTimer.this.timerMethod.invoke(CloudEventTimer.this.timedObject, new Object[0]);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Error running method: " + e.getMessage(), e);
                    }
                }
            }, 0L, (long)this.interval);
        }
    }

    public void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }
}

