/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.eventflow;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.streamzi.eventflow.ClientContainer;
import io.streamzi.eventflow.crds.Cloud;
import io.streamzi.eventflow.crds.CloudList;
import io.streamzi.eventflow.crds.DoneableCloud;
import io.streamzi.eventflow.crds.DoneableFlow;
import io.streamzi.eventflow.crds.DoneableProcessor;
import io.streamzi.eventflow.crds.Flow;
import io.streamzi.eventflow.crds.FlowList;
import io.streamzi.eventflow.crds.Processor;
import io.streamzi.eventflow.crds.ProcessorList;
import io.streamzi.eventflow.serialization.SerializedFlow;
import io.streamzi.eventflow.utils.EnvironmentResolver;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaTopicList;
import io.strimzi.api.kafka.model.DoneableKafkaTopic;
import io.strimzi.api.kafka.model.KafkaTopic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.enterprise.context.ApplicationScoped;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@ApplicationScoped
@Path(value="/api")
public class API {
    private static final Logger logger = Logger.getLogger(API.class.getName());
    private final ObjectMapper MAPPER = new ObjectMapper();
    @EJB(beanInterface=ClientContainer.class)
    private ClientContainer container;
    private final String bootstrapServersDefault = "my-cluster-kafka-bootstrap:9092";
    private final String brokerUrlDefault = "amqp://dispatch.myproject.svc:5672";

    @GET
    @Path(value="/pods")
    @Produces(value={"application/json"})
    public List<String> listPods() {
        return ((PodList)((NonNamespaceOperation)this.container.getOSClient().pods().inNamespace(this.container.getNamespace())).list()).getItems().stream().map(pod -> pod.getMetadata().getName()).collect(Collectors.toList());
    }

    @GET
    @Path(value="/dataflows/{name}")
    @Produces(value={"application/json"})
    public String getProcessorFlowDeployment(@PathParam(value="name") String name) throws Exception {
        CustomResourceDefinition flowCRD = (CustomResourceDefinition)((Resource)this.container.getOSClient().customResourceDefinitions().withName("flows.streamzi.io")).get();
        if (flowCRD == null) {
            logger.severe("Can't find Flow CRD");
            return "";
        }
        return this.MAPPER.writeValueAsString(((Resource)((NonNamespaceOperation)this.container.getOSClient().customResources(flowCRD, Flow.class, FlowList.class, DoneableFlow.class).inNamespace(this.container.getOSClient().getNamespace())).withName(name)).get());
    }

    @GET
    @Path(value="/dataflows")
    @Produces(value={"application/json"})
    public List<String> listFlows() {
        CustomResourceDefinition flowCRD = (CustomResourceDefinition)((Resource)this.container.getOSClient().customResourceDefinitions().withName("flows.streamzi.io")).get();
        if (flowCRD == null) {
            logger.severe("Can't find Flow CRD");
            return Collections.emptyList();
        }
        return ((FlowList)((NonNamespaceOperation)this.container.getOSClient().customResources(flowCRD, Flow.class, FlowList.class, DoneableFlow.class).inNamespace(this.container.getOSClient().getNamespace())).list()).getItems().stream().map(flow -> flow.getMetadata().getName()).collect(Collectors.toList());
    }

    @GET
    @Path(value="/processors")
    @Produces(value={"application/json"})
    public String listProcessors() throws Exception {
        CustomResourceDefinition procCRD = (CustomResourceDefinition)((Resource)this.container.getOSClient().customResourceDefinitions().withName("processors.streamzi.io")).get();
        if (procCRD == null) {
            logger.severe("Can't find CRD");
            return "[]";
        }
        return this.MAPPER.writeValueAsString((Object)((ProcessorList)((NonNamespaceOperation)this.container.getOSClient().customResources(procCRD, Processor.class, ProcessorList.class, DoneableProcessor.class).inNamespace(this.container.getOSClient().getNamespace())).list()).getItems());
    }

    @POST
    @Path(value="/flows")
    @Consumes(value={"application/json"})
    public void postFlow(String flowJson) {
        logger.info(flowJson);
        try {
            SerializedFlow serializedFlow = (SerializedFlow)this.MAPPER.readValue(flowJson, SerializedFlow.class);
            logger.info("Flow Parsed OK");
            serializedFlow.setName(serializedFlow.getName().toLowerCase().replace("_", "-").replace(" ", "-"));
            Flow customResource = new Flow();
            ObjectMeta metadata = new ObjectMeta();
            metadata.setName(serializedFlow.getName());
            customResource.setMetadata(metadata);
            customResource.setSpec(serializedFlow);
            CustomResourceDefinition flowCRD = (CustomResourceDefinition)((Resource)this.container.getOSClient().customResourceDefinitions().withName("flows.streamzi.io")).get();
            ((NonNamespaceOperation)this.container.getOSClient().customResources(flowCRD, Flow.class, FlowList.class, DoneableFlow.class).inNamespace(this.container.getNamespace())).createOrReplace((Object[])new Flow[]{customResource});
            logger.info("Flow written OK");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error parsing JSON flow data: " + e.getMessage(), e);
        }
    }

    @GET
    @Path(value="/globalproperties")
    @Produces(value={"application/json"})
    public String getGlobalProperties() {
        Properties props = new Properties();
        String bootstrapServers = EnvironmentResolver.get((String)"STREAMZI_KAFKA_BOOTSTRAP_SERVER");
        if (bootstrapServers != null && !bootstrapServers.equals("")) {
            props.put("STREAMZI_KAFKA_BOOTSTRAP_SERVER", bootstrapServers);
        } else {
            props.put("STREAMZI_KAFKA_BOOTSTRAP_SERVER", "my-cluster-kafka-bootstrap:9092");
        }
        String brokerUrl = EnvironmentResolver.get((String)"broker.url");
        if (brokerUrl != null && !brokerUrl.equals("")) {
            props.put("broker.url", brokerUrl);
        } else {
            props.put("broker.url", "amqp://dispatch.myproject.svc:5672");
        }
        try {
            return this.MAPPER.writeValueAsString((Object)props);
        }
        catch (JsonProcessingException e) {
            logger.severe(e.getMessage());
            return "{}";
        }
    }

    @GET
    @Path(value="/topics")
    @Produces(value={"application/json"})
    public List<String> listTopicNames() {
        return ((KafkaTopicList)((NonNamespaceOperation)this.container.getOSClient().customResources(Crds.topic(), KafkaTopic.class, KafkaTopicList.class, DoneableKafkaTopic.class).inNamespace(this.container.getOSClient().getNamespace())).list()).getItems().stream().filter(kafkaTopic -> kafkaTopic.getMetadata().getLabels().get("streamzi.io/source") == null).map(flow -> flow.getMetadata().getName()).collect(Collectors.toList());
    }

    @GET
    @Path(value="/clouds")
    @Produces(value={"application/json"})
    public String getClouds() throws Exception {
        CustomResourceDefinition cloudCRD = (CustomResourceDefinition)((Resource)this.container.getOSClient().customResourceDefinitions().withName("clouds.streamzi.io")).get();
        if (cloudCRD == null) {
            logger.severe("Can't find Cloud CRD");
            return "[]";
        }
        return this.MAPPER.writeValueAsString(new ArrayList(((CloudList)((NonNamespaceOperation)this.container.getOSClient().customResources(cloudCRD, Cloud.class, CloudList.class, DoneableCloud.class).inNamespace(this.container.getOSClient().getNamespace())).list()).getItems()).stream().peek(cloud -> cloud.getSpec().setToken(null)).collect(Collectors.toList()));
    }

    @GET
    @Path(value="/clouds/names")
    @Produces(value={"application/json"})
    public String getCloudNames() throws Exception {
        CustomResourceDefinition cloudCRD = (CustomResourceDefinition)((Resource)this.container.getOSClient().customResourceDefinitions().withName("clouds.streamzi.io")).get();
        if (cloudCRD == null) {
            logger.severe("Can't find Cloud CRD");
            return "[\"local\"]";
        }
        Set cloudNames = ((CloudList)((NonNamespaceOperation)this.container.getOSClient().customResources(cloudCRD, Cloud.class, CloudList.class, DoneableCloud.class).inNamespace(this.container.getOSClient().getNamespace())).list()).getItems().stream().map(cloud -> cloud.getMetadata().getName()).collect(Collectors.toSet());
        cloudNames.add("local");
        return this.MAPPER.writeValueAsString(cloudNames);
    }

    @GET
    @Path(value="/clouds/{name}")
    @Produces(value={"application/json"})
    public String getCloud(@PathParam(value="name") String name) throws Exception {
        CustomResourceDefinition cloudCRD = (CustomResourceDefinition)((Resource)this.container.getOSClient().customResourceDefinitions().withName("clouds.streamzi.io")).get();
        if (cloudCRD == null) {
            logger.severe("Can't find Cloud CRD");
            return "";
        }
        Cloud cloud = (Cloud)((Resource)((NonNamespaceOperation)this.container.getOSClient().customResources(cloudCRD, Cloud.class, CloudList.class, DoneableCloud.class).inNamespace(this.container.getOSClient().getNamespace())).withName(name)).get();
        if (cloud != null) {
            cloud.getSpec().setToken(null);
            return this.MAPPER.writeValueAsString((Object)cloud);
        }
        return "{}";
    }
}

