package strikt.internal.opentest4j

import org.opentest4j.IncompleteExecutionException

/**
 * Thrown to indicate that an assertion chain does not end with an assertion (in other words the
 * state of the assertion group is [strikt.api.Status.Pending]). This usually means that either:
 * 1. a mapping function was called but not ultimate followed by an assertion, or
 * 2. a block is empty.
 */
class IncompleteAssertion : IncompleteExecutionException(
  "Incomplete assertion (empty block or mapping not terminated with an assertion)"
) {
  override fun toString(): String = localizedMessage
}
