/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.JvmOptions;
import io.strimzi.api.kafka.model.JvmOptionsFluent;
import io.strimzi.api.kafka.model.JvmOptionsFluentImpl;

public class JvmOptionsBuilder
extends JvmOptionsFluentImpl<JvmOptionsBuilder>
implements VisitableBuilder<JvmOptions, JvmOptionsBuilder> {
    JvmOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public JvmOptionsBuilder() {
        this(true);
    }

    public JvmOptionsBuilder(Boolean validationEnabled) {
        this(new JvmOptions(), validationEnabled);
    }

    public JvmOptionsBuilder(JvmOptionsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public JvmOptionsBuilder(JvmOptionsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new JvmOptions(), validationEnabled);
    }

    public JvmOptionsBuilder(JvmOptionsFluent<?> fluent, JvmOptions instance) {
        this(fluent, instance, true);
    }

    public JvmOptionsBuilder(JvmOptionsFluent<?> fluent, JvmOptions instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withXmx(instance.getXmx());
        fluent.withXms(instance.getXms());
        fluent.withServer(instance.isServer());
        fluent.withGcLoggingEnabled(instance.isGcLoggingEnabled());
        fluent.withJavaSystemProperties(instance.getJavaSystemProperties());
        fluent.withXx(instance.getXx());
        this.validationEnabled = validationEnabled;
    }

    public JvmOptionsBuilder(JvmOptions instance) {
        this(instance, (Boolean)true);
    }

    public JvmOptionsBuilder(JvmOptions instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withXmx(instance.getXmx());
        this.withXms(instance.getXms());
        this.withServer(instance.isServer());
        this.withGcLoggingEnabled(instance.isGcLoggingEnabled());
        this.withJavaSystemProperties(instance.getJavaSystemProperties());
        this.withXx(instance.getXx());
        this.validationEnabled = validationEnabled;
    }

    public JvmOptions build() {
        JvmOptions buildable = new JvmOptions();
        buildable.setXmx(this.fluent.getXmx());
        buildable.setXms(this.fluent.getXms());
        buildable.setServer(this.fluent.isServer());
        buildable.setGcLoggingEnabled(this.fluent.isGcLoggingEnabled());
        buildable.setJavaSystemProperties(this.fluent.getJavaSystemProperties());
        buildable.setXx(this.fluent.getXx());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JvmOptionsBuilder that = (JvmOptionsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

