/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.strimzi.api.kafka.model.CertSecretSource;
import io.strimzi.api.kafka.model.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.CertSecretSourceFluentImpl;
import io.strimzi.api.kafka.model.KafkaAuthorizationKeycloak;
import io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class KafkaAuthorizationKeycloakFluentImpl<A extends KafkaAuthorizationKeycloakFluent<A>>
extends BaseFluent<A>
implements KafkaAuthorizationKeycloakFluent<A> {
    private String clientId;
    private String tokenEndpointUri;
    private List<CertSecretSourceBuilder> tlsTrustedCertificates;
    private boolean disableTlsHostnameVerification;
    private boolean delegateToKafkaAcls;
    private List<String> superUsers;

    public KafkaAuthorizationKeycloakFluentImpl() {
    }

    public KafkaAuthorizationKeycloakFluentImpl(KafkaAuthorizationKeycloak instance) {
        this.withClientId(instance.getClientId());
        this.withTokenEndpointUri(instance.getTokenEndpointUri());
        this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
        this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
        this.withDelegateToKafkaAcls(instance.isDelegateToKafkaAcls());
        this.withSuperUsers(instance.getSuperUsers());
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public A withClientId(String clientId) {
        this.clientId = clientId;
        return (A)this;
    }

    @Override
    public Boolean hasClientId() {
        return this.clientId != null;
    }

    @Override
    public A withNewClientId(String arg1) {
        return this.withClientId(new String(arg1));
    }

    @Override
    public A withNewClientId(StringBuilder arg1) {
        return this.withClientId(new String(arg1));
    }

    @Override
    public A withNewClientId(StringBuffer arg1) {
        return this.withClientId(new String(arg1));
    }

    @Override
    public String getTokenEndpointUri() {
        return this.tokenEndpointUri;
    }

    @Override
    public A withTokenEndpointUri(String tokenEndpointUri) {
        this.tokenEndpointUri = tokenEndpointUri;
        return (A)this;
    }

    @Override
    public Boolean hasTokenEndpointUri() {
        return this.tokenEndpointUri != null;
    }

    @Override
    public A withNewTokenEndpointUri(String arg1) {
        return this.withTokenEndpointUri(new String(arg1));
    }

    @Override
    public A withNewTokenEndpointUri(StringBuilder arg1) {
        return this.withTokenEndpointUri(new String(arg1));
    }

    @Override
    public A withNewTokenEndpointUri(StringBuffer arg1) {
        return this.withTokenEndpointUri(new String(arg1));
    }

    @Override
    public A addToTlsTrustedCertificates(int index, CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();
        }
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
        this._visitables.get((Object)"tlsTrustedCertificates").add(index >= 0 ? index : this._visitables.get((Object)"tlsTrustedCertificates").size(), builder);
        this.tlsTrustedCertificates.add(index >= 0 ? index : this.tlsTrustedCertificates.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTlsTrustedCertificates(int index, CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();
        }
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"tlsTrustedCertificates").size()) {
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
        } else {
            this._visitables.get((Object)"tlsTrustedCertificates").set(index, builder);
        }
        if (index < 0 || index >= this.tlsTrustedCertificates.size()) {
            this.tlsTrustedCertificates.add(builder);
        } else {
            this.tlsTrustedCertificates.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTlsTrustedCertificates(CertSecretSource ... items) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTlsTrustedCertificates(Collection<CertSecretSource> items) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTlsTrustedCertificates(CertSecretSource ... items) {
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").remove(builder);
            if (this.tlsTrustedCertificates == null) continue;
            this.tlsTrustedCertificates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTlsTrustedCertificates(Collection<CertSecretSource> items) {
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").remove(builder);
            if (this.tlsTrustedCertificates == null) continue;
            this.tlsTrustedCertificates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTlsTrustedCertificates(Predicate<CertSecretSourceBuilder> predicate) {
        if (this.tlsTrustedCertificates == null) {
            return (A)this;
        }
        Iterator<CertSecretSourceBuilder> each = this.tlsTrustedCertificates.iterator();
        List visitables = this._visitables.get((Object)"tlsTrustedCertificates");
        while (each.hasNext()) {
            CertSecretSourceBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<CertSecretSource> getTlsTrustedCertificates() {
        return KafkaAuthorizationKeycloakFluentImpl.build(this.tlsTrustedCertificates);
    }

    @Override
    public List<CertSecretSource> buildTlsTrustedCertificates() {
        return KafkaAuthorizationKeycloakFluentImpl.build(this.tlsTrustedCertificates);
    }

    @Override
    public CertSecretSource buildTlsTrustedCertificate(int index) {
        return this.tlsTrustedCertificates.get(index).build();
    }

    @Override
    public CertSecretSource buildFirstTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(0).build();
    }

    @Override
    public CertSecretSource buildLastTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(this.tlsTrustedCertificates.size() - 1).build();
    }

    @Override
    public CertSecretSource buildMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item : this.tlsTrustedCertificates) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item : this.tlsTrustedCertificates) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTlsTrustedCertificates(List<CertSecretSource> tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) {
            this._visitables.get((Object)"tlsTrustedCertificates").removeAll(this.tlsTrustedCertificates);
        }
        if (tlsTrustedCertificates != null) {
            this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();
            for (CertSecretSource item : tlsTrustedCertificates) {
                this.addToTlsTrustedCertificates(item);
            }
        } else {
            this.tlsTrustedCertificates = null;
        }
        return (A)this;
    }

    @Override
    public A withTlsTrustedCertificates(CertSecretSource ... tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) {
            this.tlsTrustedCertificates.clear();
        }
        if (tlsTrustedCertificates != null) {
            for (CertSecretSource item : tlsTrustedCertificates) {
                this.addToTlsTrustedCertificates(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsTrustedCertificates() {
        return this.tlsTrustedCertificates != null && !this.tlsTrustedCertificates.isEmpty();
    }

    @Override
    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate() {
        return new TlsTrustedCertificatesNestedImpl();
    }

    @Override
    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(CertSecretSource item) {
        return new TlsTrustedCertificatesNestedImpl(-1, item);
    }

    @Override
    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index, CertSecretSource item) {
        return new TlsTrustedCertificatesNestedImpl(index, item);
    }

    @Override
    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index) {
        if (this.tlsTrustedCertificates.size() <= index) {
            throw new RuntimeException("Can't edit tlsTrustedCertificates. Index exceeds size.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    @Override
    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate() {
        if (this.tlsTrustedCertificates.size() == 0) {
            throw new RuntimeException("Can't edit first tlsTrustedCertificates. The list is empty.");
        }
        return this.setNewTlsTrustedCertificateLike(0, this.buildTlsTrustedCertificate(0));
    }

    @Override
    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate() {
        int index = this.tlsTrustedCertificates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tlsTrustedCertificates. The list is empty.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    @Override
    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tlsTrustedCertificates.size(); ++i) {
            if (!predicate.apply((Object)this.tlsTrustedCertificates.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tlsTrustedCertificates. No match found.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    @Override
    public boolean isDisableTlsHostnameVerification() {
        return this.disableTlsHostnameVerification;
    }

    @Override
    public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification) {
        this.disableTlsHostnameVerification = disableTlsHostnameVerification;
        return (A)this;
    }

    @Override
    public Boolean hasDisableTlsHostnameVerification() {
        return true;
    }

    @Override
    public boolean isDelegateToKafkaAcls() {
        return this.delegateToKafkaAcls;
    }

    @Override
    public A withDelegateToKafkaAcls(boolean delegateToKafkaAcls) {
        this.delegateToKafkaAcls = delegateToKafkaAcls;
        return (A)this;
    }

    @Override
    public Boolean hasDelegateToKafkaAcls() {
        return true;
    }

    @Override
    public A addToSuperUsers(int index, String item) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        this.superUsers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSuperUsers(int index, String item) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        this.superUsers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSuperUsers(String ... items) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        for (String item : items) {
            this.superUsers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSuperUsers(Collection<String> items) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        for (String item : items) {
            this.superUsers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSuperUsers(String ... items) {
        for (String item : items) {
            if (this.superUsers == null) continue;
            this.superUsers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSuperUsers(Collection<String> items) {
        for (String item : items) {
            if (this.superUsers == null) continue;
            this.superUsers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSuperUsers() {
        return this.superUsers;
    }

    @Override
    public String getSuperUser(int index) {
        return this.superUsers.get(index);
    }

    @Override
    public String getFirstSuperUser() {
        return this.superUsers.get(0);
    }

    @Override
    public String getLastSuperUser() {
        return this.superUsers.get(this.superUsers.size() - 1);
    }

    @Override
    public String getMatchingSuperUser(Predicate<String> predicate) {
        for (String item : this.superUsers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSuperUser(Predicate<String> predicate) {
        for (String item : this.superUsers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSuperUsers(List<String> superUsers) {
        if (this.superUsers != null) {
            this._visitables.get((Object)"superUsers").removeAll(this.superUsers);
        }
        if (superUsers != null) {
            this.superUsers = new ArrayList<String>();
            for (String item : superUsers) {
                this.addToSuperUsers(item);
            }
        } else {
            this.superUsers = null;
        }
        return (A)this;
    }

    @Override
    public A withSuperUsers(String ... superUsers) {
        if (this.superUsers != null) {
            this.superUsers.clear();
        }
        if (superUsers != null) {
            for (String item : superUsers) {
                this.addToSuperUsers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSuperUsers() {
        return this.superUsers != null && !this.superUsers.isEmpty();
    }

    @Override
    public A addNewSuperUser(String arg1) {
        return this.addToSuperUsers(new String(arg1));
    }

    @Override
    public A addNewSuperUser(StringBuilder arg1) {
        return this.addToSuperUsers(new String(arg1));
    }

    @Override
    public A addNewSuperUser(StringBuffer arg1) {
        return this.addToSuperUsers(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaAuthorizationKeycloakFluentImpl that = (KafkaAuthorizationKeycloakFluentImpl)o;
        if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) {
            return false;
        }
        if (this.tokenEndpointUri != null ? !this.tokenEndpointUri.equals(that.tokenEndpointUri) : that.tokenEndpointUri != null) {
            return false;
        }
        if (this.tlsTrustedCertificates != null ? !this.tlsTrustedCertificates.equals(that.tlsTrustedCertificates) : that.tlsTrustedCertificates != null) {
            return false;
        }
        if (this.disableTlsHostnameVerification != that.disableTlsHostnameVerification) {
            return false;
        }
        if (this.delegateToKafkaAcls != that.delegateToKafkaAcls) {
            return false;
        }
        return !(this.superUsers != null ? !this.superUsers.equals(that.superUsers) : that.superUsers != null);
    }

    public class TlsTrustedCertificatesNestedImpl<N>
    extends CertSecretSourceFluentImpl<KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<N>>
    implements KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<N>,
    Nested<N> {
        private final CertSecretSourceBuilder builder;
        private final int index;

        TlsTrustedCertificatesNestedImpl(int index, CertSecretSource item) {
            this.index = index;
            this.builder = new CertSecretSourceBuilder(this, item);
        }

        TlsTrustedCertificatesNestedImpl() {
            this.index = -1;
            this.builder = new CertSecretSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaAuthorizationKeycloakFluentImpl.this.setToTlsTrustedCertificates(this.index, this.builder.build());
        }

        @Override
        public N endTlsTrustedCertificate() {
            return this.and();
        }
    }
}

