/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Toleration;
import io.strimzi.api.kafka.model.ExternalLogging;
import io.strimzi.api.kafka.model.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.ExternalLoggingFluentImpl;
import io.strimzi.api.kafka.model.InlineLogging;
import io.strimzi.api.kafka.model.InlineLoggingBuilder;
import io.strimzi.api.kafka.model.InlineLoggingFluentImpl;
import io.strimzi.api.kafka.model.JvmOptions;
import io.strimzi.api.kafka.model.JvmOptionsBuilder;
import io.strimzi.api.kafka.model.JvmOptionsFluentImpl;
import io.strimzi.api.kafka.model.KafkaAuthorization;
import io.strimzi.api.kafka.model.KafkaAuthorizationKeycloak;
import io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakBuilder;
import io.strimzi.api.kafka.model.KafkaAuthorizationKeycloakFluentImpl;
import io.strimzi.api.kafka.model.KafkaAuthorizationOpa;
import io.strimzi.api.kafka.model.KafkaAuthorizationOpaBuilder;
import io.strimzi.api.kafka.model.KafkaAuthorizationOpaFluentImpl;
import io.strimzi.api.kafka.model.KafkaAuthorizationSimple;
import io.strimzi.api.kafka.model.KafkaAuthorizationSimpleBuilder;
import io.strimzi.api.kafka.model.KafkaAuthorizationSimpleFluentImpl;
import io.strimzi.api.kafka.model.KafkaClusterSpec;
import io.strimzi.api.kafka.model.KafkaClusterSpecFluent;
import io.strimzi.api.kafka.model.KafkaJmxOptions;
import io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder;
import io.strimzi.api.kafka.model.KafkaJmxOptionsFluentImpl;
import io.strimzi.api.kafka.model.Logging;
import io.strimzi.api.kafka.model.Probe;
import io.strimzi.api.kafka.model.ProbeBuilder;
import io.strimzi.api.kafka.model.ProbeFluentImpl;
import io.strimzi.api.kafka.model.Rack;
import io.strimzi.api.kafka.model.RackBuilder;
import io.strimzi.api.kafka.model.RackFluentImpl;
import io.strimzi.api.kafka.model.TlsSidecar;
import io.strimzi.api.kafka.model.TlsSidecarBuilder;
import io.strimzi.api.kafka.model.TlsSidecarFluentImpl;
import io.strimzi.api.kafka.model.listener.KafkaListeners;
import io.strimzi.api.kafka.model.listener.KafkaListenersBuilder;
import io.strimzi.api.kafka.model.listener.KafkaListenersFluentImpl;
import io.strimzi.api.kafka.model.storage.EphemeralStorage;
import io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder;
import io.strimzi.api.kafka.model.storage.EphemeralStorageFluentImpl;
import io.strimzi.api.kafka.model.storage.JbodStorage;
import io.strimzi.api.kafka.model.storage.JbodStorageBuilder;
import io.strimzi.api.kafka.model.storage.JbodStorageFluentImpl;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorage;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluentImpl;
import io.strimzi.api.kafka.model.storage.Storage;
import io.strimzi.api.kafka.model.template.KafkaClusterTemplate;
import io.strimzi.api.kafka.model.template.KafkaClusterTemplateBuilder;
import io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class KafkaClusterSpecFluentImpl<A extends KafkaClusterSpecFluent<A>>
extends BaseFluent<A>
implements KafkaClusterSpecFluent<A> {
    private VisitableBuilder<? extends Storage, ?> storage;
    private String version;
    private Map<String, Object> config;
    private String brokerRackInitImage;
    private RackBuilder rack;
    private VisitableBuilder<? extends Logging, ?> logging;
    private TlsSidecarBuilder tlsSidecar;
    private int replicas;
    private String image;
    private ResourceRequirements resources;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private JvmOptionsBuilder jvmOptions;
    private KafkaJmxOptionsBuilder jmxOptions;
    private Map<String, Object> metrics;
    private Affinity affinity;
    private List<Toleration> tolerations;
    private KafkaListenersBuilder listeners;
    private VisitableBuilder<? extends KafkaAuthorization, ?> authorization;
    private KafkaClusterTemplateBuilder template;

    public KafkaClusterSpecFluentImpl() {
    }

    public KafkaClusterSpecFluentImpl(KafkaClusterSpec instance) {
        this.withStorage(instance.getStorage());
        this.withVersion(instance.getVersion());
        this.withConfig(instance.getConfig());
        this.withBrokerRackInitImage(instance.getBrokerRackInitImage());
        this.withRack(instance.getRack());
        this.withLogging(instance.getLogging());
        this.withTlsSidecar(instance.getTlsSidecar());
        this.withReplicas(instance.getReplicas());
        this.withImage(instance.getImage());
        this.withResources(instance.getResources());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withJvmOptions(instance.getJvmOptions());
        this.withJmxOptions(instance.getJmxOptions());
        this.withMetrics(instance.getMetrics());
        this.withAffinity(instance.getAffinity());
        this.withTolerations(instance.getTolerations());
        this.withListeners(instance.getListeners());
        this.withAuthorization(instance.getAuthorization());
        this.withTemplate(instance.getTemplate());
    }

    @Override
    @Deprecated
    public Storage getStorage() {
        return this.storage != null ? (Storage)this.storage.build() : null;
    }

    @Override
    public Storage buildStorage() {
        return this.storage != null ? (Storage)this.storage.build() : null;
    }

    @Override
    public A withStorage(Storage storage) {
        if (storage instanceof PersistentClaimStorage) {
            this.storage = new PersistentClaimStorageBuilder((PersistentClaimStorage)storage);
            this._visitables.get((Object)"storage").add(this.storage);
        }
        if (storage instanceof EphemeralStorage) {
            this.storage = new EphemeralStorageBuilder((EphemeralStorage)storage);
            this._visitables.get((Object)"storage").add(this.storage);
        }
        if (storage instanceof JbodStorage) {
            this.storage = new JbodStorageBuilder((JbodStorage)storage);
            this._visitables.get((Object)"storage").add(this.storage);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStorage() {
        return this.storage != null;
    }

    @Override
    public A withPersistentClaimStorage(PersistentClaimStorage persistentClaimStorage) {
        this._visitables.get((Object)"storage").remove(this.storage);
        if (persistentClaimStorage != null) {
            this.storage = new PersistentClaimStorageBuilder(persistentClaimStorage);
            this._visitables.get((Object)"storage").add(this.storage);
        }
        return (A)this;
    }

    @Override
    public KafkaClusterSpecFluent.PersistentClaimStorageNested<A> withNewPersistentClaimStorage() {
        return new PersistentClaimStorageNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.PersistentClaimStorageNested<A> withNewPersistentClaimStorageLike(PersistentClaimStorage item) {
        return new PersistentClaimStorageNestedImpl(item);
    }

    @Override
    public A withEphemeralStorage(EphemeralStorage ephemeralStorage) {
        this._visitables.get((Object)"storage").remove(this.storage);
        if (ephemeralStorage != null) {
            this.storage = new EphemeralStorageBuilder(ephemeralStorage);
            this._visitables.get((Object)"storage").add(this.storage);
        }
        return (A)this;
    }

    @Override
    public KafkaClusterSpecFluent.EphemeralStorageNested<A> withNewEphemeralStorage() {
        return new EphemeralStorageNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.EphemeralStorageNested<A> withNewEphemeralStorageLike(EphemeralStorage item) {
        return new EphemeralStorageNestedImpl(item);
    }

    @Override
    public A withJbodStorage(JbodStorage jbodStorage) {
        this._visitables.get((Object)"storage").remove(this.storage);
        if (jbodStorage != null) {
            this.storage = new JbodStorageBuilder(jbodStorage);
            this._visitables.get((Object)"storage").add(this.storage);
        }
        return (A)this;
    }

    @Override
    public KafkaClusterSpecFluent.JbodStorageNested<A> withNewJbodStorage() {
        return new JbodStorageNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.JbodStorageNested<A> withNewJbodStorageLike(JbodStorage item) {
        return new JbodStorageNestedImpl(item);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public A withNewVersion(String arg1) {
        return this.withVersion(new String(arg1));
    }

    @Override
    public A withNewVersion(StringBuilder arg1) {
        return this.withVersion(new String(arg1));
    }

    @Override
    public A withNewVersion(StringBuffer arg1) {
        return this.withVersion(new String(arg1));
    }

    @Override
    public A addToConfig(String key, Object value) {
        if (this.config == null && key != null && value != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.config.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToConfig(Map<String, Object> map) {
        if (this.config == null && map != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.config.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(String key) {
        if (this.config == null) {
            return (A)this;
        }
        if (key != null && this.config != null) {
            this.config.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(Map<String, Object> map) {
        if (this.config == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.config == null) continue;
                this.config.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Override
    public A withConfig(Map<String, Object> config) {
        this.config = config == null ? null : new LinkedHashMap<String, Object>(config);
        return (A)this;
    }

    @Override
    public Boolean hasConfig() {
        return this.config != null;
    }

    @Override
    public String getBrokerRackInitImage() {
        return this.brokerRackInitImage;
    }

    @Override
    public A withBrokerRackInitImage(String brokerRackInitImage) {
        this.brokerRackInitImage = brokerRackInitImage;
        return (A)this;
    }

    @Override
    public Boolean hasBrokerRackInitImage() {
        return this.brokerRackInitImage != null;
    }

    @Override
    public A withNewBrokerRackInitImage(String arg1) {
        return this.withBrokerRackInitImage(new String(arg1));
    }

    @Override
    public A withNewBrokerRackInitImage(StringBuilder arg1) {
        return this.withBrokerRackInitImage(new String(arg1));
    }

    @Override
    public A withNewBrokerRackInitImage(StringBuffer arg1) {
        return this.withBrokerRackInitImage(new String(arg1));
    }

    @Override
    @Deprecated
    public Rack getRack() {
        return this.rack != null ? this.rack.build() : null;
    }

    @Override
    public Rack buildRack() {
        return this.rack != null ? this.rack.build() : null;
    }

    @Override
    public A withRack(Rack rack) {
        this._visitables.get((Object)"rack").remove(this.rack);
        if (rack != null) {
            this.rack = new RackBuilder(rack);
            this._visitables.get((Object)"rack").add(this.rack);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRack() {
        return this.rack != null;
    }

    @Override
    public A withNewRack(String topologyKey) {
        return this.withRack(new Rack(topologyKey));
    }

    @Override
    public KafkaClusterSpecFluent.RackNested<A> withNewRack() {
        return new RackNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.RackNested<A> withNewRackLike(Rack item) {
        return new RackNestedImpl(item);
    }

    @Override
    public KafkaClusterSpecFluent.RackNested<A> editRack() {
        return this.withNewRackLike(this.getRack());
    }

    @Override
    public KafkaClusterSpecFluent.RackNested<A> editOrNewRack() {
        return this.withNewRackLike(this.getRack() != null ? this.getRack() : new RackBuilder().build());
    }

    @Override
    public KafkaClusterSpecFluent.RackNested<A> editOrNewRackLike(Rack item) {
        return this.withNewRackLike(this.getRack() != null ? this.getRack() : item);
    }

    @Override
    @Deprecated
    public Logging getLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    @Override
    public Logging buildLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    @Override
    public A withLogging(Logging logging) {
        if (logging instanceof ExternalLogging) {
            this.logging = new ExternalLoggingBuilder((ExternalLogging)logging);
            this._visitables.get((Object)"logging").add(this.logging);
        }
        if (logging instanceof InlineLogging) {
            this.logging = new InlineLoggingBuilder((InlineLogging)logging);
            this._visitables.get((Object)"logging").add(this.logging);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLogging() {
        return this.logging != null;
    }

    @Override
    public A withExternalLogging(ExternalLogging externalLogging) {
        this._visitables.get((Object)"logging").remove(this.logging);
        if (externalLogging != null) {
            this.logging = new ExternalLoggingBuilder(externalLogging);
            this._visitables.get((Object)"logging").add(this.logging);
        }
        return (A)this;
    }

    @Override
    public KafkaClusterSpecFluent.ExternalLoggingNested<A> withNewExternalLogging() {
        return new ExternalLoggingNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
        return new ExternalLoggingNestedImpl(item);
    }

    @Override
    public A withInlineLogging(InlineLogging inlineLogging) {
        this._visitables.get((Object)"logging").remove(this.logging);
        if (inlineLogging != null) {
            this.logging = new InlineLoggingBuilder(inlineLogging);
            this._visitables.get((Object)"logging").add(this.logging);
        }
        return (A)this;
    }

    @Override
    public KafkaClusterSpecFluent.InlineLoggingNested<A> withNewInlineLogging() {
        return new InlineLoggingNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
        return new InlineLoggingNestedImpl(item);
    }

    @Override
    @Deprecated
    public TlsSidecar getTlsSidecar() {
        return this.tlsSidecar != null ? this.tlsSidecar.build() : null;
    }

    @Override
    public TlsSidecar buildTlsSidecar() {
        return this.tlsSidecar != null ? this.tlsSidecar.build() : null;
    }

    @Override
    public A withTlsSidecar(TlsSidecar tlsSidecar) {
        this._visitables.get((Object)"tlsSidecar").remove(this.tlsSidecar);
        if (tlsSidecar != null) {
            this.tlsSidecar = new TlsSidecarBuilder(tlsSidecar);
            this._visitables.get((Object)"tlsSidecar").add(this.tlsSidecar);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsSidecar() {
        return this.tlsSidecar != null;
    }

    @Override
    public KafkaClusterSpecFluent.TlsSidecarNested<A> withNewTlsSidecar() {
        return new TlsSidecarNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.TlsSidecarNested<A> withNewTlsSidecarLike(TlsSidecar item) {
        return new TlsSidecarNestedImpl(item);
    }

    @Override
    public KafkaClusterSpecFluent.TlsSidecarNested<A> editTlsSidecar() {
        return this.withNewTlsSidecarLike(this.getTlsSidecar());
    }

    @Override
    public KafkaClusterSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecar() {
        return this.withNewTlsSidecarLike(this.getTlsSidecar() != null ? this.getTlsSidecar() : new TlsSidecarBuilder().build());
    }

    @Override
    public KafkaClusterSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecarLike(TlsSidecar item) {
        return this.withNewTlsSidecarLike(this.getTlsSidecar() != null ? this.getTlsSidecar() : item);
    }

    @Override
    public int getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(int replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return true;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public A withNewImage(String arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuilder arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuffer arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public ResourceRequirements getResources() {
        return this.resources;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this.resources = resources;
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    @Deprecated
    public Probe getLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.get((Object)"livenessProbe").remove(this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    @Override
    public A withNewLivenessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    @Override
    public KafkaClusterSpecFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNestedImpl(item);
    }

    @Override
    public KafkaClusterSpecFluent.LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe());
    }

    @Override
    public KafkaClusterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : new ProbeBuilder().build());
    }

    @Override
    public KafkaClusterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : item);
    }

    @Override
    @Deprecated
    public Probe getReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.get((Object)"readinessProbe").remove(this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    @Override
    public A withNewReadinessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    @Override
    public KafkaClusterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNestedImpl(item);
    }

    @Override
    public KafkaClusterSpecFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe());
    }

    @Override
    public KafkaClusterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : new ProbeBuilder().build());
    }

    @Override
    public KafkaClusterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : item);
    }

    @Override
    @Deprecated
    public JvmOptions getJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    @Override
    public JvmOptions buildJvmOptions() {
        return this.jvmOptions != null ? this.jvmOptions.build() : null;
    }

    @Override
    public A withJvmOptions(JvmOptions jvmOptions) {
        this._visitables.get((Object)"jvmOptions").remove(this.jvmOptions);
        if (jvmOptions != null) {
            this.jvmOptions = new JvmOptionsBuilder(jvmOptions);
            this._visitables.get((Object)"jvmOptions").add(this.jvmOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    @Override
    public KafkaClusterSpecFluent.JvmOptionsNested<A> withNewJvmOptions() {
        return new JvmOptionsNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
        return new JvmOptionsNestedImpl(item);
    }

    @Override
    public KafkaClusterSpecFluent.JvmOptionsNested<A> editJvmOptions() {
        return this.withNewJvmOptionsLike(this.getJvmOptions());
    }

    @Override
    public KafkaClusterSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions() {
        return this.withNewJvmOptionsLike(this.getJvmOptions() != null ? this.getJvmOptions() : new JvmOptionsBuilder().build());
    }

    @Override
    public KafkaClusterSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
        return this.withNewJvmOptionsLike(this.getJvmOptions() != null ? this.getJvmOptions() : item);
    }

    @Override
    @Deprecated
    public KafkaJmxOptions getJmxOptions() {
        return this.jmxOptions != null ? this.jmxOptions.build() : null;
    }

    @Override
    public KafkaJmxOptions buildJmxOptions() {
        return this.jmxOptions != null ? this.jmxOptions.build() : null;
    }

    @Override
    public A withJmxOptions(KafkaJmxOptions jmxOptions) {
        this._visitables.get((Object)"jmxOptions").remove(this.jmxOptions);
        if (jmxOptions != null) {
            this.jmxOptions = new KafkaJmxOptionsBuilder(jmxOptions);
            this._visitables.get((Object)"jmxOptions").add(this.jmxOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasJmxOptions() {
        return this.jmxOptions != null;
    }

    @Override
    public KafkaClusterSpecFluent.JmxOptionsNested<A> withNewJmxOptions() {
        return new JmxOptionsNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.JmxOptionsNested<A> withNewJmxOptionsLike(KafkaJmxOptions item) {
        return new JmxOptionsNestedImpl(item);
    }

    @Override
    public KafkaClusterSpecFluent.JmxOptionsNested<A> editJmxOptions() {
        return this.withNewJmxOptionsLike(this.getJmxOptions());
    }

    @Override
    public KafkaClusterSpecFluent.JmxOptionsNested<A> editOrNewJmxOptions() {
        return this.withNewJmxOptionsLike(this.getJmxOptions() != null ? this.getJmxOptions() : new KafkaJmxOptionsBuilder().build());
    }

    @Override
    public KafkaClusterSpecFluent.JmxOptionsNested<A> editOrNewJmxOptionsLike(KafkaJmxOptions item) {
        return this.withNewJmxOptionsLike(this.getJmxOptions() != null ? this.getJmxOptions() : item);
    }

    @Override
    public A addToMetrics(String key, Object value) {
        if (this.metrics == null && key != null && value != null) {
            this.metrics = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.metrics.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToMetrics(Map<String, Object> map) {
        if (this.metrics == null && map != null) {
            this.metrics = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.metrics.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetrics(String key) {
        if (this.metrics == null) {
            return (A)this;
        }
        if (key != null && this.metrics != null) {
            this.metrics.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetrics(Map<String, Object> map) {
        if (this.metrics == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.metrics == null) continue;
                this.metrics.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getMetrics() {
        return this.metrics;
    }

    @Override
    public A withMetrics(Map<String, Object> metrics) {
        this.metrics = metrics == null ? null : new LinkedHashMap<String, Object>(metrics);
        return (A)this;
    }

    @Override
    public Boolean hasMetrics() {
        return this.metrics != null;
    }

    @Override
    public Affinity getAffinity() {
        return this.affinity;
    }

    @Override
    public A withAffinity(Affinity affinity) {
        this.affinity = affinity;
        return (A)this;
    }

    @Override
    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    @Override
    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTolerations(Toleration ... items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    @Override
    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    @Override
    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    @Override
    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    @Override
    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTolerations(List<Toleration> tolerations) {
        if (this.tolerations != null) {
            this._visitables.get((Object)"tolerations").removeAll(this.tolerations);
        }
        if (tolerations != null) {
            this.tolerations = new ArrayList<Toleration>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    @Override
    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    @Override
    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    @Override
    @Deprecated
    public KafkaListeners getListeners() {
        return this.listeners != null ? this.listeners.build() : null;
    }

    @Override
    public KafkaListeners buildListeners() {
        return this.listeners != null ? this.listeners.build() : null;
    }

    @Override
    public A withListeners(KafkaListeners listeners) {
        this._visitables.get((Object)"listeners").remove(this.listeners);
        if (listeners != null) {
            this.listeners = new KafkaListenersBuilder(listeners);
            this._visitables.get((Object)"listeners").add(this.listeners);
        }
        return (A)this;
    }

    @Override
    public Boolean hasListeners() {
        return this.listeners != null;
    }

    @Override
    public KafkaClusterSpecFluent.ListenersNested<A> withNewListeners() {
        return new ListenersNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.ListenersNested<A> withNewListenersLike(KafkaListeners item) {
        return new ListenersNestedImpl(item);
    }

    @Override
    public KafkaClusterSpecFluent.ListenersNested<A> editListeners() {
        return this.withNewListenersLike(this.getListeners());
    }

    @Override
    public KafkaClusterSpecFluent.ListenersNested<A> editOrNewListeners() {
        return this.withNewListenersLike(this.getListeners() != null ? this.getListeners() : new KafkaListenersBuilder().build());
    }

    @Override
    public KafkaClusterSpecFluent.ListenersNested<A> editOrNewListenersLike(KafkaListeners item) {
        return this.withNewListenersLike(this.getListeners() != null ? this.getListeners() : item);
    }

    @Override
    @Deprecated
    public KafkaAuthorization getAuthorization() {
        return this.authorization != null ? (KafkaAuthorization)this.authorization.build() : null;
    }

    @Override
    public KafkaAuthorization buildAuthorization() {
        return this.authorization != null ? (KafkaAuthorization)this.authorization.build() : null;
    }

    @Override
    public A withAuthorization(KafkaAuthorization authorization) {
        if (authorization instanceof KafkaAuthorizationOpa) {
            this.authorization = new KafkaAuthorizationOpaBuilder((KafkaAuthorizationOpa)authorization);
            this._visitables.get((Object)"authorization").add(this.authorization);
        }
        if (authorization instanceof KafkaAuthorizationKeycloak) {
            this.authorization = new KafkaAuthorizationKeycloakBuilder((KafkaAuthorizationKeycloak)authorization);
            this._visitables.get((Object)"authorization").add(this.authorization);
        }
        if (authorization instanceof KafkaAuthorizationSimple) {
            this.authorization = new KafkaAuthorizationSimpleBuilder((KafkaAuthorizationSimple)authorization);
            this._visitables.get((Object)"authorization").add(this.authorization);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthorization() {
        return this.authorization != null;
    }

    @Override
    public A withKafkaAuthorizationOpa(KafkaAuthorizationOpa kafkaAuthorizationOpa) {
        this._visitables.get((Object)"authorization").remove(this.authorization);
        if (kafkaAuthorizationOpa != null) {
            this.authorization = new KafkaAuthorizationOpaBuilder(kafkaAuthorizationOpa);
            this._visitables.get((Object)"authorization").add(this.authorization);
        }
        return (A)this;
    }

    @Override
    public KafkaClusterSpecFluent.KafkaAuthorizationOpaNested<A> withNewKafkaAuthorizationOpa() {
        return new KafkaAuthorizationOpaNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.KafkaAuthorizationOpaNested<A> withNewKafkaAuthorizationOpaLike(KafkaAuthorizationOpa item) {
        return new KafkaAuthorizationOpaNestedImpl(item);
    }

    @Override
    public A withKafkaAuthorizationKeycloak(KafkaAuthorizationKeycloak kafkaAuthorizationKeycloak) {
        this._visitables.get((Object)"authorization").remove(this.authorization);
        if (kafkaAuthorizationKeycloak != null) {
            this.authorization = new KafkaAuthorizationKeycloakBuilder(kafkaAuthorizationKeycloak);
            this._visitables.get((Object)"authorization").add(this.authorization);
        }
        return (A)this;
    }

    @Override
    public KafkaClusterSpecFluent.KafkaAuthorizationKeycloakNested<A> withNewKafkaAuthorizationKeycloak() {
        return new KafkaAuthorizationKeycloakNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.KafkaAuthorizationKeycloakNested<A> withNewKafkaAuthorizationKeycloakLike(KafkaAuthorizationKeycloak item) {
        return new KafkaAuthorizationKeycloakNestedImpl(item);
    }

    @Override
    public A withKafkaAuthorizationSimple(KafkaAuthorizationSimple kafkaAuthorizationSimple) {
        this._visitables.get((Object)"authorization").remove(this.authorization);
        if (kafkaAuthorizationSimple != null) {
            this.authorization = new KafkaAuthorizationSimpleBuilder(kafkaAuthorizationSimple);
            this._visitables.get((Object)"authorization").add(this.authorization);
        }
        return (A)this;
    }

    @Override
    public KafkaClusterSpecFluent.KafkaAuthorizationSimpleNested<A> withNewKafkaAuthorizationSimple() {
        return new KafkaAuthorizationSimpleNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.KafkaAuthorizationSimpleNested<A> withNewKafkaAuthorizationSimpleLike(KafkaAuthorizationSimple item) {
        return new KafkaAuthorizationSimpleNestedImpl(item);
    }

    @Override
    @Deprecated
    public KafkaClusterTemplate getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public KafkaClusterTemplate buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(KafkaClusterTemplate template) {
        this._visitables.get((Object)"template").remove(this.template);
        if (template != null) {
            this.template = new KafkaClusterTemplateBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public KafkaClusterSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public KafkaClusterSpecFluent.TemplateNested<A> withNewTemplateLike(KafkaClusterTemplate item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public KafkaClusterSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public KafkaClusterSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new KafkaClusterTemplateBuilder().build());
    }

    @Override
    public KafkaClusterSpecFluent.TemplateNested<A> editOrNewTemplateLike(KafkaClusterTemplate item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaClusterSpecFluentImpl that = (KafkaClusterSpecFluentImpl)o;
        if (this.storage != null ? !this.storage.equals(that.storage) : that.storage != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.config != null ? !this.config.equals(that.config) : that.config != null) {
            return false;
        }
        if (this.brokerRackInitImage != null ? !this.brokerRackInitImage.equals(that.brokerRackInitImage) : that.brokerRackInitImage != null) {
            return false;
        }
        if (this.rack != null ? !this.rack.equals(that.rack) : that.rack != null) {
            return false;
        }
        if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) {
            return false;
        }
        if (this.tlsSidecar != null ? !this.tlsSidecar.equals(that.tlsSidecar) : that.tlsSidecar != null) {
            return false;
        }
        if (this.replicas != that.replicas) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals((Object)that.resources) : that.resources != null) {
            return false;
        }
        if (this.livenessProbe != null ? !this.livenessProbe.equals(that.livenessProbe) : that.livenessProbe != null) {
            return false;
        }
        if (this.readinessProbe != null ? !this.readinessProbe.equals(that.readinessProbe) : that.readinessProbe != null) {
            return false;
        }
        if (this.jvmOptions != null ? !this.jvmOptions.equals(that.jvmOptions) : that.jvmOptions != null) {
            return false;
        }
        if (this.jmxOptions != null ? !this.jmxOptions.equals(that.jmxOptions) : that.jmxOptions != null) {
            return false;
        }
        if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) {
            return false;
        }
        if (this.affinity != null ? !this.affinity.equals((Object)that.affinity) : that.affinity != null) {
            return false;
        }
        if (this.tolerations != null ? !this.tolerations.equals(that.tolerations) : that.tolerations != null) {
            return false;
        }
        if (this.listeners != null ? !this.listeners.equals(that.listeners) : that.listeners != null) {
            return false;
        }
        if (this.authorization != null ? !this.authorization.equals(that.authorization) : that.authorization != null) {
            return false;
        }
        return !(this.template != null ? !this.template.equals(that.template) : that.template != null);
    }

    public class TemplateNestedImpl<N>
    extends KafkaClusterTemplateFluentImpl<KafkaClusterSpecFluent.TemplateNested<N>>
    implements KafkaClusterSpecFluent.TemplateNested<N>,
    Nested<N> {
        private final KafkaClusterTemplateBuilder builder;

        TemplateNestedImpl(KafkaClusterTemplate item) {
            this.builder = new KafkaClusterTemplateBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new KafkaClusterTemplateBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    public class KafkaAuthorizationSimpleNestedImpl<N>
    extends KafkaAuthorizationSimpleFluentImpl<KafkaClusterSpecFluent.KafkaAuthorizationSimpleNested<N>>
    implements KafkaClusterSpecFluent.KafkaAuthorizationSimpleNested<N>,
    Nested<N> {
        private final KafkaAuthorizationSimpleBuilder builder;

        KafkaAuthorizationSimpleNestedImpl(KafkaAuthorizationSimple item) {
            this.builder = new KafkaAuthorizationSimpleBuilder(this, item);
        }

        KafkaAuthorizationSimpleNestedImpl() {
            this.builder = new KafkaAuthorizationSimpleBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withKafkaAuthorizationSimple(this.builder.build());
        }

        @Override
        public N endKafkaAuthorizationSimple() {
            return this.and();
        }
    }

    public class KafkaAuthorizationKeycloakNestedImpl<N>
    extends KafkaAuthorizationKeycloakFluentImpl<KafkaClusterSpecFluent.KafkaAuthorizationKeycloakNested<N>>
    implements KafkaClusterSpecFluent.KafkaAuthorizationKeycloakNested<N>,
    Nested<N> {
        private final KafkaAuthorizationKeycloakBuilder builder;

        KafkaAuthorizationKeycloakNestedImpl(KafkaAuthorizationKeycloak item) {
            this.builder = new KafkaAuthorizationKeycloakBuilder(this, item);
        }

        KafkaAuthorizationKeycloakNestedImpl() {
            this.builder = new KafkaAuthorizationKeycloakBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withKafkaAuthorizationKeycloak(this.builder.build());
        }

        @Override
        public N endKafkaAuthorizationKeycloak() {
            return this.and();
        }
    }

    public class KafkaAuthorizationOpaNestedImpl<N>
    extends KafkaAuthorizationOpaFluentImpl<KafkaClusterSpecFluent.KafkaAuthorizationOpaNested<N>>
    implements KafkaClusterSpecFluent.KafkaAuthorizationOpaNested<N>,
    Nested<N> {
        private final KafkaAuthorizationOpaBuilder builder;

        KafkaAuthorizationOpaNestedImpl(KafkaAuthorizationOpa item) {
            this.builder = new KafkaAuthorizationOpaBuilder(this, item);
        }

        KafkaAuthorizationOpaNestedImpl() {
            this.builder = new KafkaAuthorizationOpaBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withKafkaAuthorizationOpa(this.builder.build());
        }

        @Override
        public N endKafkaAuthorizationOpa() {
            return this.and();
        }
    }

    public class ListenersNestedImpl<N>
    extends KafkaListenersFluentImpl<KafkaClusterSpecFluent.ListenersNested<N>>
    implements KafkaClusterSpecFluent.ListenersNested<N>,
    Nested<N> {
        private final KafkaListenersBuilder builder;

        ListenersNestedImpl(KafkaListeners item) {
            this.builder = new KafkaListenersBuilder(this, item);
        }

        ListenersNestedImpl() {
            this.builder = new KafkaListenersBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withListeners(this.builder.build());
        }

        @Override
        public N endListeners() {
            return this.and();
        }
    }

    public class JmxOptionsNestedImpl<N>
    extends KafkaJmxOptionsFluentImpl<KafkaClusterSpecFluent.JmxOptionsNested<N>>
    implements KafkaClusterSpecFluent.JmxOptionsNested<N>,
    Nested<N> {
        private final KafkaJmxOptionsBuilder builder;

        JmxOptionsNestedImpl(KafkaJmxOptions item) {
            this.builder = new KafkaJmxOptionsBuilder(this, item);
        }

        JmxOptionsNestedImpl() {
            this.builder = new KafkaJmxOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withJmxOptions(this.builder.build());
        }

        @Override
        public N endJmxOptions() {
            return this.and();
        }
    }

    public class JvmOptionsNestedImpl<N>
    extends JvmOptionsFluentImpl<KafkaClusterSpecFluent.JvmOptionsNested<N>>
    implements KafkaClusterSpecFluent.JvmOptionsNested<N>,
    Nested<N> {
        private final JvmOptionsBuilder builder;

        JvmOptionsNestedImpl(JvmOptions item) {
            this.builder = new JvmOptionsBuilder(this, item);
        }

        JvmOptionsNestedImpl() {
            this.builder = new JvmOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withJvmOptions(this.builder.build());
        }

        @Override
        public N endJvmOptions() {
            return this.and();
        }
    }

    public class ReadinessProbeNestedImpl<N>
    extends ProbeFluentImpl<KafkaClusterSpecFluent.ReadinessProbeNested<N>>
    implements KafkaClusterSpecFluent.ReadinessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        ReadinessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        ReadinessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withReadinessProbe(this.builder.build());
        }

        @Override
        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class LivenessProbeNestedImpl<N>
    extends ProbeFluentImpl<KafkaClusterSpecFluent.LivenessProbeNested<N>>
    implements KafkaClusterSpecFluent.LivenessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        LivenessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        LivenessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withLivenessProbe(this.builder.build());
        }

        @Override
        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class TlsSidecarNestedImpl<N>
    extends TlsSidecarFluentImpl<KafkaClusterSpecFluent.TlsSidecarNested<N>>
    implements KafkaClusterSpecFluent.TlsSidecarNested<N>,
    Nested<N> {
        private final TlsSidecarBuilder builder;

        TlsSidecarNestedImpl(TlsSidecar item) {
            this.builder = new TlsSidecarBuilder(this, item);
        }

        TlsSidecarNestedImpl() {
            this.builder = new TlsSidecarBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withTlsSidecar(this.builder.build());
        }

        @Override
        public N endTlsSidecar() {
            return this.and();
        }
    }

    public class InlineLoggingNestedImpl<N>
    extends InlineLoggingFluentImpl<KafkaClusterSpecFluent.InlineLoggingNested<N>>
    implements KafkaClusterSpecFluent.InlineLoggingNested<N>,
    Nested<N> {
        private final InlineLoggingBuilder builder;

        InlineLoggingNestedImpl(InlineLogging item) {
            this.builder = new InlineLoggingBuilder(this, item);
        }

        InlineLoggingNestedImpl() {
            this.builder = new InlineLoggingBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withInlineLogging(this.builder.build());
        }

        @Override
        public N endInlineLogging() {
            return this.and();
        }
    }

    public class ExternalLoggingNestedImpl<N>
    extends ExternalLoggingFluentImpl<KafkaClusterSpecFluent.ExternalLoggingNested<N>>
    implements KafkaClusterSpecFluent.ExternalLoggingNested<N>,
    Nested<N> {
        private final ExternalLoggingBuilder builder;

        ExternalLoggingNestedImpl(ExternalLogging item) {
            this.builder = new ExternalLoggingBuilder(this, item);
        }

        ExternalLoggingNestedImpl() {
            this.builder = new ExternalLoggingBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withExternalLogging(this.builder.build());
        }

        @Override
        public N endExternalLogging() {
            return this.and();
        }
    }

    public class RackNestedImpl<N>
    extends RackFluentImpl<KafkaClusterSpecFluent.RackNested<N>>
    implements KafkaClusterSpecFluent.RackNested<N>,
    Nested<N> {
        private final RackBuilder builder;

        RackNestedImpl(Rack item) {
            this.builder = new RackBuilder(this, item);
        }

        RackNestedImpl() {
            this.builder = new RackBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withRack(this.builder.build());
        }

        @Override
        public N endRack() {
            return this.and();
        }
    }

    public class JbodStorageNestedImpl<N>
    extends JbodStorageFluentImpl<KafkaClusterSpecFluent.JbodStorageNested<N>>
    implements KafkaClusterSpecFluent.JbodStorageNested<N>,
    Nested<N> {
        private final JbodStorageBuilder builder;

        JbodStorageNestedImpl(JbodStorage item) {
            this.builder = new JbodStorageBuilder(this, item);
        }

        JbodStorageNestedImpl() {
            this.builder = new JbodStorageBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withJbodStorage(this.builder.build());
        }

        @Override
        public N endJbodStorage() {
            return this.and();
        }
    }

    public class EphemeralStorageNestedImpl<N>
    extends EphemeralStorageFluentImpl<KafkaClusterSpecFluent.EphemeralStorageNested<N>>
    implements KafkaClusterSpecFluent.EphemeralStorageNested<N>,
    Nested<N> {
        private final EphemeralStorageBuilder builder;

        EphemeralStorageNestedImpl(EphemeralStorage item) {
            this.builder = new EphemeralStorageBuilder(this, item);
        }

        EphemeralStorageNestedImpl() {
            this.builder = new EphemeralStorageBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withEphemeralStorage(this.builder.build());
        }

        @Override
        public N endEphemeralStorage() {
            return this.and();
        }
    }

    public class PersistentClaimStorageNestedImpl<N>
    extends PersistentClaimStorageFluentImpl<KafkaClusterSpecFluent.PersistentClaimStorageNested<N>>
    implements KafkaClusterSpecFluent.PersistentClaimStorageNested<N>,
    Nested<N> {
        private final PersistentClaimStorageBuilder builder;

        PersistentClaimStorageNestedImpl(PersistentClaimStorage item) {
            this.builder = new PersistentClaimStorageBuilder(this, item);
        }

        PersistentClaimStorageNestedImpl() {
            this.builder = new PersistentClaimStorageBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClusterSpecFluentImpl.this.withPersistentClaimStorage(this.builder.build());
        }

        @Override
        public N endPersistentClaimStorage() {
            return this.and();
        }
    }
}

