/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl;
import io.strimzi.api.kafka.model.KafkaConnectSpec;
import io.strimzi.api.kafka.model.KafkaConnectSpecFluent;
import io.strimzi.api.kafka.model.KafkaConnectTls;
import io.strimzi.api.kafka.model.KafkaConnectTlsBuilder;
import io.strimzi.api.kafka.model.KafkaConnectTlsFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512FluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;

public class KafkaConnectSpecFluentImpl<A extends KafkaConnectSpecFluent<A>>
extends AbstractKafkaConnectSpecFluentImpl<A>
implements KafkaConnectSpecFluent<A> {
    private Map<String, Object> config;
    private String bootstrapServers;
    private KafkaConnectTlsBuilder tls;
    private VisitableBuilder<? extends KafkaClientAuthentication, ?> authentication;

    public KafkaConnectSpecFluentImpl() {
    }

    public KafkaConnectSpecFluentImpl(KafkaConnectSpec instance) {
        this.withConfig(instance.getConfig());
        this.withBootstrapServers(instance.getBootstrapServers());
        this.withTls(instance.getTls());
        this.withAuthentication(instance.getAuthentication());
        this.withLogging(instance.getLogging());
        this.withReplicas(instance.getReplicas());
        this.withVersion(instance.getVersion());
        this.withImage(instance.getImage());
        this.withResources(instance.getResources());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withJvmOptions(instance.getJvmOptions());
        this.withMetrics(instance.getMetrics());
        this.withTracing(instance.getTracing());
        this.withAffinity(instance.getAffinity());
        this.withTolerations(instance.getTolerations());
        this.withTemplate(instance.getTemplate());
        this.withExternalConfiguration(instance.getExternalConfiguration());
    }

    @Override
    public A addToConfig(String key, Object value) {
        if (this.config == null && key != null && value != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.config.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToConfig(Map<String, Object> map) {
        if (this.config == null && map != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.config.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(String key) {
        if (this.config == null) {
            return (A)this;
        }
        if (key != null && this.config != null) {
            this.config.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(Map<String, Object> map) {
        if (this.config == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.config == null) continue;
                this.config.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Override
    public A withConfig(Map<String, Object> config) {
        this.config = config == null ? null : new LinkedHashMap<String, Object>(config);
        return (A)this;
    }

    @Override
    public Boolean hasConfig() {
        return this.config != null;
    }

    @Override
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @Override
    public A withBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        return (A)this;
    }

    @Override
    public Boolean hasBootstrapServers() {
        return this.bootstrapServers != null;
    }

    @Override
    public A withNewBootstrapServers(String arg1) {
        return this.withBootstrapServers(new String(arg1));
    }

    @Override
    public A withNewBootstrapServers(StringBuilder arg1) {
        return this.withBootstrapServers(new String(arg1));
    }

    @Override
    public A withNewBootstrapServers(StringBuffer arg1) {
        return this.withBootstrapServers(new String(arg1));
    }

    @Override
    @Deprecated
    public KafkaConnectTls getTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    @Override
    public KafkaConnectTls buildTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    @Override
    public A withTls(KafkaConnectTls tls) {
        this._visitables.get((Object)"tls").remove(this.tls);
        if (tls != null) {
            this.tls = new KafkaConnectTlsBuilder(tls);
            this._visitables.get((Object)"tls").add(this.tls);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTls() {
        return this.tls != null;
    }

    @Override
    public KafkaConnectSpecFluent.TlsNested<A> withNewTls() {
        return new TlsNestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.TlsNested<A> withNewTlsLike(KafkaConnectTls item) {
        return new TlsNestedImpl(item);
    }

    @Override
    public KafkaConnectSpecFluent.TlsNested<A> editTls() {
        return this.withNewTlsLike(this.getTls());
    }

    @Override
    public KafkaConnectSpecFluent.TlsNested<A> editOrNewTls() {
        return this.withNewTlsLike(this.getTls() != null ? this.getTls() : new KafkaConnectTlsBuilder().build());
    }

    @Override
    public KafkaConnectSpecFluent.TlsNested<A> editOrNewTlsLike(KafkaConnectTls item) {
        return this.withNewTlsLike(this.getTls() != null ? this.getTls() : item);
    }

    @Override
    @Deprecated
    public KafkaClientAuthentication getAuthentication() {
        return this.authentication != null ? (KafkaClientAuthentication)this.authentication.build() : null;
    }

    @Override
    public KafkaClientAuthentication buildAuthentication() {
        return this.authentication != null ? (KafkaClientAuthentication)this.authentication.build() : null;
    }

    @Override
    public A withAuthentication(KafkaClientAuthentication authentication) {
        if (authentication instanceof KafkaClientAuthenticationScramSha512) {
            this.authentication = new KafkaClientAuthenticationScramSha512Builder((KafkaClientAuthenticationScramSha512)authentication);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        if (authentication instanceof KafkaClientAuthenticationPlain) {
            this.authentication = new KafkaClientAuthenticationPlainBuilder((KafkaClientAuthenticationPlain)authentication);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        if (authentication instanceof KafkaClientAuthenticationOAuth) {
            this.authentication = new KafkaClientAuthenticationOAuthBuilder((KafkaClientAuthenticationOAuth)authentication);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        if (authentication instanceof KafkaClientAuthenticationTls) {
            this.authentication = new KafkaClientAuthenticationTlsBuilder((KafkaClientAuthenticationTls)authentication);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthentication() {
        return this.authentication != null;
    }

    @Override
    public A withKafkaClientAuthenticationScramSha512(KafkaClientAuthenticationScramSha512 kafkaClientAuthenticationScramSha512) {
        this._visitables.get((Object)"authentication").remove(this.authentication);
        if (kafkaClientAuthenticationScramSha512 != null) {
            this.authentication = new KafkaClientAuthenticationScramSha512Builder(kafkaClientAuthenticationScramSha512);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512() {
        return new KafkaClientAuthenticationScramSha512NestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(KafkaClientAuthenticationScramSha512 item) {
        return new KafkaClientAuthenticationScramSha512NestedImpl(item);
    }

    @Override
    public A withKafkaClientAuthenticationPlain(KafkaClientAuthenticationPlain kafkaClientAuthenticationPlain) {
        this._visitables.get((Object)"authentication").remove(this.authentication);
        if (kafkaClientAuthenticationPlain != null) {
            this.authentication = new KafkaClientAuthenticationPlainBuilder(kafkaClientAuthenticationPlain);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain() {
        return new KafkaClientAuthenticationPlainNestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(KafkaClientAuthenticationPlain item) {
        return new KafkaClientAuthenticationPlainNestedImpl(item);
    }

    @Override
    public A withKafkaClientAuthenticationOAuth(KafkaClientAuthenticationOAuth kafkaClientAuthenticationOAuth) {
        this._visitables.get((Object)"authentication").remove(this.authentication);
        if (kafkaClientAuthenticationOAuth != null) {
            this.authentication = new KafkaClientAuthenticationOAuthBuilder(kafkaClientAuthenticationOAuth);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth() {
        return new KafkaClientAuthenticationOAuthNestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(KafkaClientAuthenticationOAuth item) {
        return new KafkaClientAuthenticationOAuthNestedImpl(item);
    }

    @Override
    public A withKafkaClientAuthenticationTls(KafkaClientAuthenticationTls kafkaClientAuthenticationTls) {
        this._visitables.get((Object)"authentication").remove(this.authentication);
        if (kafkaClientAuthenticationTls != null) {
            this.authentication = new KafkaClientAuthenticationTlsBuilder(kafkaClientAuthenticationTls);
            this._visitables.get((Object)"authentication").add(this.authentication);
        }
        return (A)this;
    }

    @Override
    public KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls() {
        return new KafkaClientAuthenticationTlsNestedImpl();
    }

    @Override
    public KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(KafkaClientAuthenticationTls item) {
        return new KafkaClientAuthenticationTlsNestedImpl(item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaConnectSpecFluentImpl that = (KafkaConnectSpecFluentImpl)o;
        if (this.config != null ? !this.config.equals(that.config) : that.config != null) {
            return false;
        }
        if (this.bootstrapServers != null ? !this.bootstrapServers.equals(that.bootstrapServers) : that.bootstrapServers != null) {
            return false;
        }
        if (this.tls != null ? !this.tls.equals(that.tls) : that.tls != null) {
            return false;
        }
        return !(this.authentication != null ? !this.authentication.equals(that.authentication) : that.authentication != null);
    }

    public class KafkaClientAuthenticationTlsNestedImpl<N>
    extends KafkaClientAuthenticationTlsFluentImpl<KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<N>>
    implements KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<N>,
    Nested<N> {
        private final KafkaClientAuthenticationTlsBuilder builder;

        KafkaClientAuthenticationTlsNestedImpl(KafkaClientAuthenticationTls item) {
            this.builder = new KafkaClientAuthenticationTlsBuilder(this, item);
        }

        KafkaClientAuthenticationTlsNestedImpl() {
            this.builder = new KafkaClientAuthenticationTlsBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withKafkaClientAuthenticationTls(this.builder.build());
        }

        @Override
        public N endKafkaClientAuthenticationTls() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationOAuthNestedImpl<N>
    extends KafkaClientAuthenticationOAuthFluentImpl<KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<N>>
    implements KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<N>,
    Nested<N> {
        private final KafkaClientAuthenticationOAuthBuilder builder;

        KafkaClientAuthenticationOAuthNestedImpl(KafkaClientAuthenticationOAuth item) {
            this.builder = new KafkaClientAuthenticationOAuthBuilder(this, item);
        }

        KafkaClientAuthenticationOAuthNestedImpl() {
            this.builder = new KafkaClientAuthenticationOAuthBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withKafkaClientAuthenticationOAuth(this.builder.build());
        }

        @Override
        public N endKafkaClientAuthenticationOAuth() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationPlainNestedImpl<N>
    extends KafkaClientAuthenticationPlainFluentImpl<KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<N>>
    implements KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<N>,
    Nested<N> {
        private final KafkaClientAuthenticationPlainBuilder builder;

        KafkaClientAuthenticationPlainNestedImpl(KafkaClientAuthenticationPlain item) {
            this.builder = new KafkaClientAuthenticationPlainBuilder(this, item);
        }

        KafkaClientAuthenticationPlainNestedImpl() {
            this.builder = new KafkaClientAuthenticationPlainBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withKafkaClientAuthenticationPlain(this.builder.build());
        }

        @Override
        public N endKafkaClientAuthenticationPlain() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationScramSha512NestedImpl<N>
    extends KafkaClientAuthenticationScramSha512FluentImpl<KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>>
    implements KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>,
    Nested<N> {
        private final KafkaClientAuthenticationScramSha512Builder builder;

        KafkaClientAuthenticationScramSha512NestedImpl(KafkaClientAuthenticationScramSha512 item) {
            this.builder = new KafkaClientAuthenticationScramSha512Builder(this, item);
        }

        KafkaClientAuthenticationScramSha512NestedImpl() {
            this.builder = new KafkaClientAuthenticationScramSha512Builder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withKafkaClientAuthenticationScramSha512(this.builder.build());
        }

        @Override
        public N endKafkaClientAuthenticationScramSha512() {
            return this.and();
        }
    }

    public class TlsNestedImpl<N>
    extends KafkaConnectTlsFluentImpl<KafkaConnectSpecFluent.TlsNested<N>>
    implements KafkaConnectSpecFluent.TlsNested<N>,
    Nested<N> {
        private final KafkaConnectTlsBuilder builder;

        TlsNestedImpl(KafkaConnectTls item) {
            this.builder = new KafkaConnectTlsBuilder(this, item);
        }

        TlsNestedImpl() {
            this.builder = new KafkaConnectTlsBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaConnectSpecFluentImpl.this.withTls(this.builder.build());
        }

        @Override
        public N endTls() {
            return this.and();
        }
    }
}

