/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.strimzi.api.annotations.DeprecatedProperty;
import io.strimzi.api.kafka.model.CertificateAuthority;
import io.strimzi.api.kafka.model.CruiseControlSpec;
import io.strimzi.api.kafka.model.EntityOperatorSpec;
import io.strimzi.api.kafka.model.JmxTransSpec;
import io.strimzi.api.kafka.model.KafkaClusterSpec;
import io.strimzi.api.kafka.model.KafkaExporterSpec;
import io.strimzi.api.kafka.model.TopicOperatorSpec;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.ZookeeperClusterSpec;
import io.strimzi.crdgenerator.annotations.Description;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"kafka", "zookeeper", "topicOperator", "entityOperator", "clusterCa", "clientsCa", "maintenance"})
public class KafkaSpec
implements UnknownPropertyPreserving,
Serializable {
    private static final long serialVersionUID = 1L;
    private KafkaClusterSpec kafka;
    private ZookeeperClusterSpec zookeeper;
    private TopicOperatorSpec topicOperator;
    private EntityOperatorSpec entityOperator;
    private CertificateAuthority clusterCa;
    private JmxTransSpec jmxTrans;
    private KafkaExporterSpec kafkaExporter;
    private CruiseControlSpec cruiseControl;
    private CertificateAuthority clientsCa;
    private List<String> maintenanceTimeWindows;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="Configuration of the Kafka cluster")
    @JsonProperty(required=true)
    public KafkaClusterSpec getKafka() {
        return this.kafka;
    }

    public void setKafka(KafkaClusterSpec kafka) {
        this.kafka = kafka;
    }

    @Description(value="Configuration of the ZooKeeper cluster")
    @JsonProperty(required=true)
    public ZookeeperClusterSpec getZookeeper() {
        return this.zookeeper;
    }

    public void setZookeeper(ZookeeperClusterSpec zookeeper) {
        this.zookeeper = zookeeper;
    }

    @Deprecated
    @DeprecatedProperty(movedToPath="spec.entityOperator.topicOperator")
    @Description(value="Configuration of the Topic Operator")
    public TopicOperatorSpec getTopicOperator() {
        return this.topicOperator;
    }

    @Deprecated
    public void setTopicOperator(TopicOperatorSpec topicOperator) {
        this.topicOperator = topicOperator;
    }

    @Description(value="Configuration of the Entity Operator")
    public EntityOperatorSpec getEntityOperator() {
        return this.entityOperator;
    }

    public void setEntityOperator(EntityOperatorSpec entityOperator) {
        this.entityOperator = entityOperator;
    }

    @Description(value="Configuration of the cluster certificate authority")
    public CertificateAuthority getClusterCa() {
        return this.clusterCa;
    }

    public void setClusterCa(CertificateAuthority clusterCa) {
        this.clusterCa = clusterCa;
    }

    @Description(value="Configuration of the clients certificate authority")
    public CertificateAuthority getClientsCa() {
        return this.clientsCa;
    }

    public void setClientsCa(CertificateAuthority clientsCa) {
        this.clientsCa = clientsCa;
    }

    @Description(value="A list of time windows for maintenance tasks (that is, certificates renewal). Each time window is defined by a cron expression.")
    public List<String> getMaintenanceTimeWindows() {
        return this.maintenanceTimeWindows;
    }

    @Description(value="Configuration for JmxTrans. When the property is present a JmxTrans deployment is created for gathering JMX metrics from each Kafka broker. For more information see https://github.com/jmxtrans/jmxtrans[JmxTrans GitHub]")
    public JmxTransSpec getJmxTrans() {
        return this.jmxTrans;
    }

    public void setJmxTrans(JmxTransSpec jmxTrans) {
        this.jmxTrans = jmxTrans;
    }

    public void setMaintenanceTimeWindows(List<String> maintenanceTimeWindows) {
        this.maintenanceTimeWindows = maintenanceTimeWindows;
    }

    @Description(value="Configuration of the Kafka Exporter. Kafka Exporter can provide additional metrics, for example lag of consumer group at topic/partition.")
    public KafkaExporterSpec getKafkaExporter() {
        return this.kafkaExporter;
    }

    public void setKafkaExporter(KafkaExporterSpec kafkaExporter) {
        this.kafkaExporter = kafkaExporter;
    }

    @Description(value="Configuration for Cruise Control deployment. Deploys a Cruise Control instance when specified")
    public CruiseControlSpec getCruiseControl() {
        return this.cruiseControl;
    }

    public void setCruiseControl(CruiseControlSpec cruiseControl) {
        this.cruiseControl = cruiseControl;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        YAMLMapper mapper = new YAMLMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaSpec)) {
            return false;
        }
        KafkaSpec other = (KafkaSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        KafkaClusterSpec this$kafka = this.getKafka();
        KafkaClusterSpec other$kafka = other.getKafka();
        if (this$kafka == null ? other$kafka != null : !((Object)this$kafka).equals(other$kafka)) {
            return false;
        }
        ZookeeperClusterSpec this$zookeeper = this.getZookeeper();
        ZookeeperClusterSpec other$zookeeper = other.getZookeeper();
        if (this$zookeeper == null ? other$zookeeper != null : !((Object)this$zookeeper).equals(other$zookeeper)) {
            return false;
        }
        TopicOperatorSpec this$topicOperator = this.getTopicOperator();
        TopicOperatorSpec other$topicOperator = other.getTopicOperator();
        if (this$topicOperator == null ? other$topicOperator != null : !((Object)this$topicOperator).equals(other$topicOperator)) {
            return false;
        }
        EntityOperatorSpec this$entityOperator = this.getEntityOperator();
        EntityOperatorSpec other$entityOperator = other.getEntityOperator();
        if (this$entityOperator == null ? other$entityOperator != null : !((Object)this$entityOperator).equals(other$entityOperator)) {
            return false;
        }
        CertificateAuthority this$clusterCa = this.getClusterCa();
        CertificateAuthority other$clusterCa = other.getClusterCa();
        if (this$clusterCa == null ? other$clusterCa != null : !((Object)this$clusterCa).equals(other$clusterCa)) {
            return false;
        }
        JmxTransSpec this$jmxTrans = this.getJmxTrans();
        JmxTransSpec other$jmxTrans = other.getJmxTrans();
        if (this$jmxTrans == null ? other$jmxTrans != null : !((Object)this$jmxTrans).equals(other$jmxTrans)) {
            return false;
        }
        KafkaExporterSpec this$kafkaExporter = this.getKafkaExporter();
        KafkaExporterSpec other$kafkaExporter = other.getKafkaExporter();
        if (this$kafkaExporter == null ? other$kafkaExporter != null : !((Object)this$kafkaExporter).equals(other$kafkaExporter)) {
            return false;
        }
        CruiseControlSpec this$cruiseControl = this.getCruiseControl();
        CruiseControlSpec other$cruiseControl = other.getCruiseControl();
        if (this$cruiseControl == null ? other$cruiseControl != null : !((Object)this$cruiseControl).equals(other$cruiseControl)) {
            return false;
        }
        CertificateAuthority this$clientsCa = this.getClientsCa();
        CertificateAuthority other$clientsCa = other.getClientsCa();
        if (this$clientsCa == null ? other$clientsCa != null : !((Object)this$clientsCa).equals(other$clientsCa)) {
            return false;
        }
        List<String> this$maintenanceTimeWindows = this.getMaintenanceTimeWindows();
        List<String> other$maintenanceTimeWindows = other.getMaintenanceTimeWindows();
        if (this$maintenanceTimeWindows == null ? other$maintenanceTimeWindows != null : !((Object)this$maintenanceTimeWindows).equals(other$maintenanceTimeWindows)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KafkaClusterSpec $kafka = this.getKafka();
        result = result * 59 + ($kafka == null ? 43 : ((Object)$kafka).hashCode());
        ZookeeperClusterSpec $zookeeper = this.getZookeeper();
        result = result * 59 + ($zookeeper == null ? 43 : ((Object)$zookeeper).hashCode());
        TopicOperatorSpec $topicOperator = this.getTopicOperator();
        result = result * 59 + ($topicOperator == null ? 43 : ((Object)$topicOperator).hashCode());
        EntityOperatorSpec $entityOperator = this.getEntityOperator();
        result = result * 59 + ($entityOperator == null ? 43 : ((Object)$entityOperator).hashCode());
        CertificateAuthority $clusterCa = this.getClusterCa();
        result = result * 59 + ($clusterCa == null ? 43 : ((Object)$clusterCa).hashCode());
        JmxTransSpec $jmxTrans = this.getJmxTrans();
        result = result * 59 + ($jmxTrans == null ? 43 : ((Object)$jmxTrans).hashCode());
        KafkaExporterSpec $kafkaExporter = this.getKafkaExporter();
        result = result * 59 + ($kafkaExporter == null ? 43 : ((Object)$kafkaExporter).hashCode());
        CruiseControlSpec $cruiseControl = this.getCruiseControl();
        result = result * 59 + ($cruiseControl == null ? 43 : ((Object)$cruiseControl).hashCode());
        CertificateAuthority $clientsCa = this.getClientsCa();
        result = result * 59 + ($clientsCa == null ? 43 : ((Object)$clientsCa).hashCode());
        List<String> $maintenanceTimeWindows = this.getMaintenanceTimeWindows();
        result = result * 59 + ($maintenanceTimeWindows == null ? 43 : ((Object)$maintenanceTimeWindows).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

