/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Maximum;
import io.strimzi.crdgenerator.annotations.Minimum;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"partitions", "replicas", "config"})
public class KafkaTopicSpec
implements UnknownPropertyPreserving,
Serializable {
    private static final long serialVersionUID = 1L;
    private String topicName;
    private Integer partitions;
    private Integer replicas;
    private Map<String, Object> config;
    private Map<String, Object> additionalProperties;

    @Description(value="The name of the topic. When absent this will default to the metadata.name of the topic. It is recommended to not set this unless the topic name is not a valid Kubernetes resource name.")
    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    @Description(value="The number of partitions the topic should have. This cannot be decreased after topic creation. It can be increased after topic creation, but it is important to understand the consequences that has, especially for topics with semantic partitioning.")
    @Minimum(value=1)
    @JsonProperty(required=true)
    public Integer getPartitions() {
        return this.partitions;
    }

    public void setPartitions(Integer partitions) {
        this.partitions = partitions;
    }

    @Description(value="The number of replicas the topic should have.")
    @Minimum(value=1)
    @Maximum(value=32767)
    @JsonProperty(required=true)
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    @Description(value="The topic configuration.")
    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Collections.emptyMap();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(1);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaTopicSpec)) {
            return false;
        }
        KafkaTopicSpec other = (KafkaTopicSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$topicName = this.getTopicName();
        String other$topicName = other.getTopicName();
        if (this$topicName == null ? other$topicName != null : !this$topicName.equals(other$topicName)) {
            return false;
        }
        Integer this$partitions = this.getPartitions();
        Integer other$partitions = other.getPartitions();
        if (this$partitions == null ? other$partitions != null : !((Object)this$partitions).equals(other$partitions)) {
            return false;
        }
        Integer this$replicas = this.getReplicas();
        Integer other$replicas = other.getReplicas();
        if (this$replicas == null ? other$replicas != null : !((Object)this$replicas).equals(other$replicas)) {
            return false;
        }
        Map<String, Object> this$config = this.getConfig();
        Map<String, Object> other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaTopicSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $topicName = this.getTopicName();
        result = result * 59 + ($topicName == null ? 43 : $topicName.hashCode());
        Integer $partitions = this.getPartitions();
        result = result * 59 + ($partitions == null ? 43 : ((Object)$partitions).hashCode());
        Integer $replicas = this.getReplicas();
        result = result * 59 + ($replicas == null ? 43 : ((Object)$replicas).hashCode());
        Map<String, Object> $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

