/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.Probe;
import io.strimzi.api.kafka.model.ProbeBuilder;
import io.strimzi.api.kafka.model.ProbeFluentImpl;
import io.strimzi.api.kafka.model.SidecarFluentImpl;
import io.strimzi.api.kafka.model.TlsSidecar;
import io.strimzi.api.kafka.model.TlsSidecarFluent;
import io.strimzi.api.kafka.model.TlsSidecarLogLevel;

public class TlsSidecarFluentImpl<A extends TlsSidecarFluent<A>>
extends SidecarFluentImpl<A>
implements TlsSidecarFluent<A> {
    private TlsSidecarLogLevel logLevel;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;

    public TlsSidecarFluentImpl() {
    }

    public TlsSidecarFluentImpl(TlsSidecar instance) {
        this.withLogLevel(instance.getLogLevel());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withImage(instance.getImage());
        this.withResources(instance.getResources());
    }

    @Override
    public TlsSidecarLogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public A withLogLevel(TlsSidecarLogLevel logLevel) {
        this.logLevel = logLevel;
        return (A)this;
    }

    @Override
    public Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    @Override
    @Deprecated
    public Probe getLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.get((Object)"livenessProbe").remove(this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    @Override
    public A withNewLivenessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    @Override
    public TlsSidecarFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNestedImpl();
    }

    @Override
    public TlsSidecarFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNestedImpl(item);
    }

    @Override
    public TlsSidecarFluent.LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe());
    }

    @Override
    public TlsSidecarFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : new ProbeBuilder().build());
    }

    @Override
    public TlsSidecarFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : item);
    }

    @Override
    @Deprecated
    public Probe getReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.get((Object)"readinessProbe").remove(this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    @Override
    public A withNewReadinessProbe(int initialDelaySeconds, int timeoutSeconds) {
        return this.withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    @Override
    public TlsSidecarFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNestedImpl();
    }

    @Override
    public TlsSidecarFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNestedImpl(item);
    }

    @Override
    public TlsSidecarFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe());
    }

    @Override
    public TlsSidecarFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : new ProbeBuilder().build());
    }

    @Override
    public TlsSidecarFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TlsSidecarFluentImpl that = (TlsSidecarFluentImpl)o;
        if (this.logLevel != null ? !this.logLevel.equals((Object)that.logLevel) : that.logLevel != null) {
            return false;
        }
        if (this.livenessProbe != null ? !this.livenessProbe.equals(that.livenessProbe) : that.livenessProbe != null) {
            return false;
        }
        return !(this.readinessProbe != null ? !this.readinessProbe.equals(that.readinessProbe) : that.readinessProbe != null);
    }

    public class ReadinessProbeNestedImpl<N>
    extends ProbeFluentImpl<TlsSidecarFluent.ReadinessProbeNested<N>>
    implements TlsSidecarFluent.ReadinessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        ReadinessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        ReadinessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)TlsSidecarFluentImpl.this.withReadinessProbe(this.builder.build());
        }

        @Override
        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class LivenessProbeNestedImpl<N>
    extends ProbeFluentImpl<TlsSidecarFluent.LivenessProbeNested<N>>
    implements TlsSidecarFluent.LivenessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        LivenessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        LivenessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)TlsSidecarFluentImpl.this.withLivenessProbe(this.builder.build());
        }

        @Override
        public N endLivenessProbe() {
            return this.and();
        }
    }
}

