/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyPeer;
import io.strimzi.api.kafka.model.listener.IngressListenerConfiguration;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication;
import io.strimzi.api.kafka.model.listener.KafkaListenerExternal;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.KubeLink;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "authentication", "overrides"})
public class KafkaListenerExternalIngress
extends KafkaListenerExternal {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_INGRESS = "ingress";
    private KafkaListenerAuthentication auth;
    private List<NetworkPolicyPeer> networkPolicyPeers;
    private IngressListenerConfiguration configuration;
    private String ingressClass;

    @Override
    @Description(value="Must be `ingress`")
    public String getType() {
        return TYPE_INGRESS;
    }

    @Override
    @Description(value="Authentication configuration for Kafka brokers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="authentication")
    public KafkaListenerAuthentication getAuth() {
        return this.auth;
    }

    @Override
    public void setAuth(KafkaListenerAuthentication auth) {
        this.auth = auth;
    }

    @Override
    @Description(value="List of peers which should be able to connect to this listener. Peers in this list are combined using a logical OR operation. If this field is empty or missing, all connections will be allowed for this listener. If this field is present and contains at least one item, the listener only allows the traffic which matches at least one item in this list.")
    @KubeLink(group="networking.k8s.io", version="v1", kind="networkpolicypeer")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<NetworkPolicyPeer> getNetworkPolicyPeers() {
        return this.networkPolicyPeers;
    }

    @Override
    public void setNetworkPolicyPeers(List<NetworkPolicyPeer> networkPolicyPeers) {
        this.networkPolicyPeers = networkPolicyPeers;
    }

    @Description(value="External listener configuration")
    public IngressListenerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IngressListenerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Description(value="Configures the `Ingress` class that defines which `Ingress` controller will be used. If not set, the `Ingress` class is set to `nginx`.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="class")
    public String getIngressClass() {
        return this.ingressClass;
    }

    public void setIngressClass(String ingressClass) {
        this.ingressClass = ingressClass;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaListenerExternalIngress)) {
            return false;
        }
        KafkaListenerExternalIngress other = (KafkaListenerExternalIngress)o;
        if (!other.canEqual(this)) {
            return false;
        }
        KafkaListenerAuthentication this$auth = this.getAuth();
        KafkaListenerAuthentication other$auth = other.getAuth();
        if (this$auth == null ? other$auth != null : !((Object)this$auth).equals(other$auth)) {
            return false;
        }
        List<NetworkPolicyPeer> this$networkPolicyPeers = this.getNetworkPolicyPeers();
        List<NetworkPolicyPeer> other$networkPolicyPeers = other.getNetworkPolicyPeers();
        if (this$networkPolicyPeers == null ? other$networkPolicyPeers != null : !((Object)this$networkPolicyPeers).equals(other$networkPolicyPeers)) {
            return false;
        }
        IngressListenerConfiguration this$configuration = this.getConfiguration();
        IngressListenerConfiguration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        String this$ingressClass = this.getIngressClass();
        String other$ingressClass = other.getIngressClass();
        return !(this$ingressClass == null ? other$ingressClass != null : !this$ingressClass.equals(other$ingressClass));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaListenerExternalIngress;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KafkaListenerAuthentication $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : ((Object)$auth).hashCode());
        List<NetworkPolicyPeer> $networkPolicyPeers = this.getNetworkPolicyPeers();
        result = result * 59 + ($networkPolicyPeers == null ? 43 : ((Object)$networkPolicyPeers).hashCode());
        IngressListenerConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        String $ingressClass = this.getIngressClass();
        result = result * 59 + ($ingressClass == null ? 43 : $ingressClass.hashCode());
        return result;
    }
}

