/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener;

import io.strimzi.api.kafka.model.listener.ExternalListenerBrokerOverrideFluentImpl;
import io.strimzi.api.kafka.model.listener.LoadBalancerListenerBrokerOverride;
import io.strimzi.api.kafka.model.listener.LoadBalancerListenerBrokerOverrideFluent;
import java.util.LinkedHashMap;
import java.util.Map;

public class LoadBalancerListenerBrokerOverrideFluentImpl<A extends LoadBalancerListenerBrokerOverrideFluent<A>>
extends ExternalListenerBrokerOverrideFluentImpl<A>
implements LoadBalancerListenerBrokerOverrideFluent<A> {
    private Map<String, String> dnsAnnotations;
    private String loadBalancerIP;

    public LoadBalancerListenerBrokerOverrideFluentImpl() {
    }

    public LoadBalancerListenerBrokerOverrideFluentImpl(LoadBalancerListenerBrokerOverride instance) {
        this.withDnsAnnotations(instance.getDnsAnnotations());
        this.withLoadBalancerIP(instance.getLoadBalancerIP());
        this.withBroker(instance.getBroker());
        this.withAdvertisedHost(instance.getAdvertisedHost());
        this.withAdvertisedPort(instance.getAdvertisedPort());
    }

    @Override
    public A addToDnsAnnotations(String key, String value) {
        if (this.dnsAnnotations == null && key != null && value != null) {
            this.dnsAnnotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.dnsAnnotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToDnsAnnotations(Map<String, String> map) {
        if (this.dnsAnnotations == null && map != null) {
            this.dnsAnnotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.dnsAnnotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromDnsAnnotations(String key) {
        if (this.dnsAnnotations == null) {
            return (A)this;
        }
        if (key != null && this.dnsAnnotations != null) {
            this.dnsAnnotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromDnsAnnotations(Map<String, String> map) {
        if (this.dnsAnnotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.dnsAnnotations == null) continue;
                this.dnsAnnotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getDnsAnnotations() {
        return this.dnsAnnotations;
    }

    @Override
    public A withDnsAnnotations(Map<String, String> dnsAnnotations) {
        this.dnsAnnotations = dnsAnnotations == null ? null : new LinkedHashMap<String, String>(dnsAnnotations);
        return (A)this;
    }

    @Override
    public Boolean hasDnsAnnotations() {
        return this.dnsAnnotations != null;
    }

    @Override
    public String getLoadBalancerIP() {
        return this.loadBalancerIP;
    }

    @Override
    public A withLoadBalancerIP(String loadBalancerIP) {
        this.loadBalancerIP = loadBalancerIP;
        return (A)this;
    }

    @Override
    public Boolean hasLoadBalancerIP() {
        return this.loadBalancerIP != null;
    }

    @Override
    public A withNewLoadBalancerIP(String arg1) {
        return this.withLoadBalancerIP(new String(arg1));
    }

    @Override
    public A withNewLoadBalancerIP(StringBuilder arg1) {
        return this.withLoadBalancerIP(new String(arg1));
    }

    @Override
    public A withNewLoadBalancerIP(StringBuffer arg1) {
        return this.withLoadBalancerIP(new String(arg1));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LoadBalancerListenerBrokerOverrideFluentImpl that = (LoadBalancerListenerBrokerOverrideFluentImpl)o;
        if (this.dnsAnnotations != null ? !this.dnsAnnotations.equals(that.dnsAnnotations) : that.dnsAnnotations != null) {
            return false;
        }
        return !(this.loadBalancerIP != null ? !this.loadBalancerIP.equals(that.loadBalancerIP) : that.loadBalancerIP != null);
    }
}

