/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.strimzi.api.kafka.model.listener.NodePortListenerBootstrapOverride;
import io.strimzi.api.kafka.model.listener.NodePortListenerBootstrapOverrideBuilder;
import io.strimzi.api.kafka.model.listener.NodePortListenerBootstrapOverrideFluentImpl;
import io.strimzi.api.kafka.model.listener.NodePortListenerBrokerOverride;
import io.strimzi.api.kafka.model.listener.NodePortListenerBrokerOverrideBuilder;
import io.strimzi.api.kafka.model.listener.NodePortListenerBrokerOverrideFluentImpl;
import io.strimzi.api.kafka.model.listener.NodePortListenerOverride;
import io.strimzi.api.kafka.model.listener.NodePortListenerOverrideFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class NodePortListenerOverrideFluentImpl<A extends NodePortListenerOverrideFluent<A>>
extends BaseFluent<A>
implements NodePortListenerOverrideFluent<A> {
    private NodePortListenerBootstrapOverrideBuilder bootstrap;
    private List<NodePortListenerBrokerOverrideBuilder> brokers;

    public NodePortListenerOverrideFluentImpl() {
    }

    public NodePortListenerOverrideFluentImpl(NodePortListenerOverride instance) {
        this.withBootstrap(instance.getBootstrap());
        this.withBrokers(instance.getBrokers());
    }

    @Override
    @Deprecated
    public NodePortListenerBootstrapOverride getBootstrap() {
        return this.bootstrap != null ? this.bootstrap.build() : null;
    }

    @Override
    public NodePortListenerBootstrapOverride buildBootstrap() {
        return this.bootstrap != null ? this.bootstrap.build() : null;
    }

    @Override
    public A withBootstrap(NodePortListenerBootstrapOverride bootstrap) {
        this._visitables.get((Object)"bootstrap").remove(this.bootstrap);
        if (bootstrap != null) {
            this.bootstrap = new NodePortListenerBootstrapOverrideBuilder(bootstrap);
            this._visitables.get((Object)"bootstrap").add(this.bootstrap);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBootstrap() {
        return this.bootstrap != null;
    }

    @Override
    public NodePortListenerOverrideFluent.BootstrapNested<A> withNewBootstrap() {
        return new BootstrapNestedImpl();
    }

    @Override
    public NodePortListenerOverrideFluent.BootstrapNested<A> withNewBootstrapLike(NodePortListenerBootstrapOverride item) {
        return new BootstrapNestedImpl(item);
    }

    @Override
    public NodePortListenerOverrideFluent.BootstrapNested<A> editBootstrap() {
        return this.withNewBootstrapLike(this.getBootstrap());
    }

    @Override
    public NodePortListenerOverrideFluent.BootstrapNested<A> editOrNewBootstrap() {
        return this.withNewBootstrapLike(this.getBootstrap() != null ? this.getBootstrap() : new NodePortListenerBootstrapOverrideBuilder().build());
    }

    @Override
    public NodePortListenerOverrideFluent.BootstrapNested<A> editOrNewBootstrapLike(NodePortListenerBootstrapOverride item) {
        return this.withNewBootstrapLike(this.getBootstrap() != null ? this.getBootstrap() : item);
    }

    @Override
    public A addToBrokers(int index, NodePortListenerBrokerOverride item) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<NodePortListenerBrokerOverrideBuilder>();
        }
        NodePortListenerBrokerOverrideBuilder builder = new NodePortListenerBrokerOverrideBuilder(item);
        this._visitables.get((Object)"brokers").add(index >= 0 ? index : this._visitables.get((Object)"brokers").size(), builder);
        this.brokers.add(index >= 0 ? index : this.brokers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToBrokers(int index, NodePortListenerBrokerOverride item) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<NodePortListenerBrokerOverrideBuilder>();
        }
        NodePortListenerBrokerOverrideBuilder builder = new NodePortListenerBrokerOverrideBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"brokers").size()) {
            this._visitables.get((Object)"brokers").add(builder);
        } else {
            this._visitables.get((Object)"brokers").set(index, builder);
        }
        if (index < 0 || index >= this.brokers.size()) {
            this.brokers.add(builder);
        } else {
            this.brokers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToBrokers(NodePortListenerBrokerOverride ... items) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<NodePortListenerBrokerOverrideBuilder>();
        }
        for (NodePortListenerBrokerOverride item : items) {
            NodePortListenerBrokerOverrideBuilder builder = new NodePortListenerBrokerOverrideBuilder(item);
            this._visitables.get((Object)"brokers").add(builder);
            this.brokers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToBrokers(Collection<NodePortListenerBrokerOverride> items) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<NodePortListenerBrokerOverrideBuilder>();
        }
        for (NodePortListenerBrokerOverride item : items) {
            NodePortListenerBrokerOverrideBuilder builder = new NodePortListenerBrokerOverrideBuilder(item);
            this._visitables.get((Object)"brokers").add(builder);
            this.brokers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromBrokers(NodePortListenerBrokerOverride ... items) {
        for (NodePortListenerBrokerOverride item : items) {
            NodePortListenerBrokerOverrideBuilder builder = new NodePortListenerBrokerOverrideBuilder(item);
            this._visitables.get((Object)"brokers").remove(builder);
            if (this.brokers == null) continue;
            this.brokers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromBrokers(Collection<NodePortListenerBrokerOverride> items) {
        for (NodePortListenerBrokerOverride item : items) {
            NodePortListenerBrokerOverrideBuilder builder = new NodePortListenerBrokerOverrideBuilder(item);
            this._visitables.get((Object)"brokers").remove(builder);
            if (this.brokers == null) continue;
            this.brokers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromBrokers(Predicate<NodePortListenerBrokerOverrideBuilder> predicate) {
        if (this.brokers == null) {
            return (A)this;
        }
        Iterator<NodePortListenerBrokerOverrideBuilder> each = this.brokers.iterator();
        List visitables = this._visitables.get((Object)"brokers");
        while (each.hasNext()) {
            NodePortListenerBrokerOverrideBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NodePortListenerBrokerOverride> getBrokers() {
        return NodePortListenerOverrideFluentImpl.build(this.brokers);
    }

    @Override
    public List<NodePortListenerBrokerOverride> buildBrokers() {
        return NodePortListenerOverrideFluentImpl.build(this.brokers);
    }

    @Override
    public NodePortListenerBrokerOverride buildBroker(int index) {
        return this.brokers.get(index).build();
    }

    @Override
    public NodePortListenerBrokerOverride buildFirstBroker() {
        return this.brokers.get(0).build();
    }

    @Override
    public NodePortListenerBrokerOverride buildLastBroker() {
        return this.brokers.get(this.brokers.size() - 1).build();
    }

    @Override
    public NodePortListenerBrokerOverride buildMatchingBroker(Predicate<NodePortListenerBrokerOverrideBuilder> predicate) {
        for (NodePortListenerBrokerOverrideBuilder item : this.brokers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingBroker(Predicate<NodePortListenerBrokerOverrideBuilder> predicate) {
        for (NodePortListenerBrokerOverrideBuilder item : this.brokers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withBrokers(List<NodePortListenerBrokerOverride> brokers) {
        if (this.brokers != null) {
            this._visitables.get((Object)"brokers").removeAll(this.brokers);
        }
        if (brokers != null) {
            this.brokers = new ArrayList<NodePortListenerBrokerOverrideBuilder>();
            for (NodePortListenerBrokerOverride item : brokers) {
                this.addToBrokers(item);
            }
        } else {
            this.brokers = null;
        }
        return (A)this;
    }

    @Override
    public A withBrokers(NodePortListenerBrokerOverride ... brokers) {
        if (this.brokers != null) {
            this.brokers.clear();
        }
        if (brokers != null) {
            for (NodePortListenerBrokerOverride item : brokers) {
                this.addToBrokers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasBrokers() {
        return this.brokers != null && !this.brokers.isEmpty();
    }

    @Override
    public NodePortListenerOverrideFluent.BrokersNested<A> addNewBroker() {
        return new BrokersNestedImpl();
    }

    @Override
    public NodePortListenerOverrideFluent.BrokersNested<A> addNewBrokerLike(NodePortListenerBrokerOverride item) {
        return new BrokersNestedImpl(-1, item);
    }

    @Override
    public NodePortListenerOverrideFluent.BrokersNested<A> setNewBrokerLike(int index, NodePortListenerBrokerOverride item) {
        return new BrokersNestedImpl(index, item);
    }

    @Override
    public NodePortListenerOverrideFluent.BrokersNested<A> editBroker(int index) {
        if (this.brokers.size() <= index) {
            throw new RuntimeException("Can't edit brokers. Index exceeds size.");
        }
        return this.setNewBrokerLike(index, this.buildBroker(index));
    }

    @Override
    public NodePortListenerOverrideFluent.BrokersNested<A> editFirstBroker() {
        if (this.brokers.size() == 0) {
            throw new RuntimeException("Can't edit first brokers. The list is empty.");
        }
        return this.setNewBrokerLike(0, this.buildBroker(0));
    }

    @Override
    public NodePortListenerOverrideFluent.BrokersNested<A> editLastBroker() {
        int index = this.brokers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last brokers. The list is empty.");
        }
        return this.setNewBrokerLike(index, this.buildBroker(index));
    }

    @Override
    public NodePortListenerOverrideFluent.BrokersNested<A> editMatchingBroker(Predicate<NodePortListenerBrokerOverrideBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.brokers.size(); ++i) {
            if (!predicate.apply((Object)this.brokers.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching brokers. No match found.");
        }
        return this.setNewBrokerLike(index, this.buildBroker(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodePortListenerOverrideFluentImpl that = (NodePortListenerOverrideFluentImpl)o;
        if (this.bootstrap != null ? !this.bootstrap.equals(that.bootstrap) : that.bootstrap != null) {
            return false;
        }
        return !(this.brokers != null ? !this.brokers.equals(that.brokers) : that.brokers != null);
    }

    public class BrokersNestedImpl<N>
    extends NodePortListenerBrokerOverrideFluentImpl<NodePortListenerOverrideFluent.BrokersNested<N>>
    implements NodePortListenerOverrideFluent.BrokersNested<N>,
    Nested<N> {
        private final NodePortListenerBrokerOverrideBuilder builder;
        private final int index;

        BrokersNestedImpl(int index, NodePortListenerBrokerOverride item) {
            this.index = index;
            this.builder = new NodePortListenerBrokerOverrideBuilder(this, item);
        }

        BrokersNestedImpl() {
            this.index = -1;
            this.builder = new NodePortListenerBrokerOverrideBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodePortListenerOverrideFluentImpl.this.setToBrokers(this.index, this.builder.build());
        }

        @Override
        public N endBroker() {
            return this.and();
        }
    }

    public class BootstrapNestedImpl<N>
    extends NodePortListenerBootstrapOverrideFluentImpl<NodePortListenerOverrideFluent.BootstrapNested<N>>
    implements NodePortListenerOverrideFluent.BootstrapNested<N>,
    Nested<N> {
        private final NodePortListenerBootstrapOverrideBuilder builder;

        BootstrapNestedImpl(NodePortListenerBootstrapOverride item) {
            this.builder = new NodePortListenerBootstrapOverrideBuilder(this, item);
        }

        BootstrapNestedImpl() {
            this.builder = new NodePortListenerBootstrapOverrideBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodePortListenerOverrideFluentImpl.this.withBootstrap(this.builder.build());
        }

        @Override
        public N endBootstrap() {
            return this.and();
        }
    }
}

