/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.status;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.strimzi.api.kafka.model.connect.ConnectorPlugin;
import io.strimzi.api.kafka.model.status.Status;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.KubeLink;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"conditions", "observedGeneration", "url", "connectorPlugins"})
public class KafkaConnectStatus
extends Status {
    private static final long serialVersionUID = 1L;
    private String url;
    private List<ConnectorPlugin> connectorPlugins;
    private int replicas;
    private LabelSelector podSelector;

    @Description(value="The URL of the REST API endpoint for managing and monitoring Kafka Connect connectors.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Description(value="The list of connector plugins available in this Kafka Connect deployment.")
    public List<ConnectorPlugin> getConnectorPlugins() {
        return this.connectorPlugins;
    }

    public void setConnectorPlugins(List<ConnectorPlugin> connectorPlugins) {
        this.connectorPlugins = connectorPlugins;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Description(value="The current number of pods being used to provide this resource.")
    public int getReplicas() {
        return this.replicas;
    }

    public void setReplicas(int replicas) {
        this.replicas = replicas;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @KubeLink(group="meta", version="v1", kind="labelselector")
    @Description(value="Label selector for pods providing this resource.")
    public LabelSelector getPodSelector() {
        return this.podSelector;
    }

    public void setPodSelector(LabelSelector podSelector) {
        this.podSelector = podSelector;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaConnectStatus)) {
            return false;
        }
        KafkaConnectStatus other = (KafkaConnectStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        List<ConnectorPlugin> this$connectorPlugins = this.getConnectorPlugins();
        List<ConnectorPlugin> other$connectorPlugins = other.getConnectorPlugins();
        if (this$connectorPlugins == null ? other$connectorPlugins != null : !((Object)this$connectorPlugins).equals(other$connectorPlugins)) {
            return false;
        }
        if (this.getReplicas() != other.getReplicas()) {
            return false;
        }
        LabelSelector this$podSelector = this.getPodSelector();
        LabelSelector other$podSelector = other.getPodSelector();
        return !(this$podSelector == null ? other$podSelector != null : !this$podSelector.equals(other$podSelector));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaConnectStatus;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        List<ConnectorPlugin> $connectorPlugins = this.getConnectorPlugins();
        result = result * 59 + ($connectorPlugins == null ? 43 : ((Object)$connectorPlugins).hashCode());
        result = result * 59 + this.getReplicas();
        LabelSelector $podSelector = this.getPodSelector();
        result = result * 59 + ($podSelector == null ? 43 : $podSelector.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KafkaConnectStatus(super=" + super.toString() + ", url=" + this.getUrl() + ", connectorPlugins=" + this.getConnectorPlugins() + ", replicas=" + this.getReplicas() + ", podSelector=" + this.getPodSelector() + ")";
    }
}

