/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.strimzi.api.kafka.model.status.KafkaStatus;
import io.strimzi.api.kafka.model.status.KafkaStatusFluent;
import io.strimzi.api.kafka.model.status.ListenerStatus;
import io.strimzi.api.kafka.model.status.ListenerStatusBuilder;
import io.strimzi.api.kafka.model.status.ListenerStatusFluentImpl;
import io.strimzi.api.kafka.model.status.StatusFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class KafkaStatusFluentImpl<A extends KafkaStatusFluent<A>>
extends StatusFluentImpl<A>
implements KafkaStatusFluent<A> {
    private List<ListenerStatusBuilder> listeners;

    public KafkaStatusFluentImpl() {
    }

    public KafkaStatusFluentImpl(KafkaStatus instance) {
        this.withListeners(instance.getListeners());
        this.withConditions(instance.getConditions());
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    @Override
    public A addToListeners(int index, ListenerStatus item) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ListenerStatusBuilder>();
        }
        ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
        this._visitables.get((Object)"listeners").add(index >= 0 ? index : this._visitables.get((Object)"listeners").size(), builder);
        this.listeners.add(index >= 0 ? index : this.listeners.size(), builder);
        return (A)this;
    }

    @Override
    public A setToListeners(int index, ListenerStatus item) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ListenerStatusBuilder>();
        }
        ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"listeners").size()) {
            this._visitables.get((Object)"listeners").add(builder);
        } else {
            this._visitables.get((Object)"listeners").set(index, builder);
        }
        if (index < 0 || index >= this.listeners.size()) {
            this.listeners.add(builder);
        } else {
            this.listeners.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToListeners(ListenerStatus ... items) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ListenerStatusBuilder>();
        }
        for (ListenerStatus item : items) {
            ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
            this._visitables.get((Object)"listeners").add(builder);
            this.listeners.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToListeners(Collection<ListenerStatus> items) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ListenerStatusBuilder>();
        }
        for (ListenerStatus item : items) {
            ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
            this._visitables.get((Object)"listeners").add(builder);
            this.listeners.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromListeners(ListenerStatus ... items) {
        for (ListenerStatus item : items) {
            ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
            this._visitables.get((Object)"listeners").remove(builder);
            if (this.listeners == null) continue;
            this.listeners.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromListeners(Collection<ListenerStatus> items) {
        for (ListenerStatus item : items) {
            ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
            this._visitables.get((Object)"listeners").remove(builder);
            if (this.listeners == null) continue;
            this.listeners.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromListeners(Predicate<ListenerStatusBuilder> predicate) {
        if (this.listeners == null) {
            return (A)this;
        }
        Iterator<ListenerStatusBuilder> each = this.listeners.iterator();
        List visitables = this._visitables.get((Object)"listeners");
        while (each.hasNext()) {
            ListenerStatusBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ListenerStatus> getListeners() {
        return KafkaStatusFluentImpl.build(this.listeners);
    }

    @Override
    public List<ListenerStatus> buildListeners() {
        return KafkaStatusFluentImpl.build(this.listeners);
    }

    @Override
    public ListenerStatus buildListener(int index) {
        return this.listeners.get(index).build();
    }

    @Override
    public ListenerStatus buildFirstListener() {
        return this.listeners.get(0).build();
    }

    @Override
    public ListenerStatus buildLastListener() {
        return this.listeners.get(this.listeners.size() - 1).build();
    }

    @Override
    public ListenerStatus buildMatchingListener(Predicate<ListenerStatusBuilder> predicate) {
        for (ListenerStatusBuilder item : this.listeners) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingListener(Predicate<ListenerStatusBuilder> predicate) {
        for (ListenerStatusBuilder item : this.listeners) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withListeners(List<ListenerStatus> listeners) {
        if (this.listeners != null) {
            this._visitables.get((Object)"listeners").removeAll(this.listeners);
        }
        if (listeners != null) {
            this.listeners = new ArrayList<ListenerStatusBuilder>();
            for (ListenerStatus item : listeners) {
                this.addToListeners(item);
            }
        } else {
            this.listeners = null;
        }
        return (A)this;
    }

    @Override
    public A withListeners(ListenerStatus ... listeners) {
        if (this.listeners != null) {
            this.listeners.clear();
        }
        if (listeners != null) {
            for (ListenerStatus item : listeners) {
                this.addToListeners(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    @Override
    public KafkaStatusFluent.ListenersNested<A> addNewListener() {
        return new ListenersNestedImpl();
    }

    @Override
    public KafkaStatusFluent.ListenersNested<A> addNewListenerLike(ListenerStatus item) {
        return new ListenersNestedImpl(-1, item);
    }

    @Override
    public KafkaStatusFluent.ListenersNested<A> setNewListenerLike(int index, ListenerStatus item) {
        return new ListenersNestedImpl(index, item);
    }

    @Override
    public KafkaStatusFluent.ListenersNested<A> editListener(int index) {
        if (this.listeners.size() <= index) {
            throw new RuntimeException("Can't edit listeners. Index exceeds size.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    @Override
    public KafkaStatusFluent.ListenersNested<A> editFirstListener() {
        if (this.listeners.size() == 0) {
            throw new RuntimeException("Can't edit first listeners. The list is empty.");
        }
        return this.setNewListenerLike(0, this.buildListener(0));
    }

    @Override
    public KafkaStatusFluent.ListenersNested<A> editLastListener() {
        int index = this.listeners.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last listeners. The list is empty.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    @Override
    public KafkaStatusFluent.ListenersNested<A> editMatchingListener(Predicate<ListenerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (!predicate.apply((Object)this.listeners.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching listeners. No match found.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaStatusFluentImpl that = (KafkaStatusFluentImpl)o;
        return !(this.listeners != null ? !this.listeners.equals(that.listeners) : that.listeners != null);
    }

    public class ListenersNestedImpl<N>
    extends ListenerStatusFluentImpl<KafkaStatusFluent.ListenersNested<N>>
    implements KafkaStatusFluent.ListenersNested<N>,
    Nested<N> {
        private final ListenerStatusBuilder builder;
        private final int index;

        ListenersNestedImpl(int index, ListenerStatus item) {
            this.index = index;
            this.builder = new ListenerStatusBuilder(this, item);
        }

        ListenersNestedImpl() {
            this.index = -1;
            this.builder = new ListenerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaStatusFluentImpl.this.setToListeners(this.index, this.builder.build());
        }

        @Override
        public N endListener() {
            return this.and();
        }
    }
}

