package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface CertificateAuthorityFluent<A extends CertificateAuthorityFluent<A>> extends Fluent<A>{


    public int getValidityDays();
    public A withValidityDays(int validityDays);
    public Boolean hasValidityDays();
    public boolean isGenerateCertificateAuthority();
    public A withGenerateCertificateAuthority(boolean generateCertificateAuthority);
    public Boolean hasGenerateCertificateAuthority();
    public boolean isGenerateSecretOwnerReference();
    public A withGenerateSecretOwnerReference(boolean generateSecretOwnerReference);
    public Boolean hasGenerateSecretOwnerReference();
    public int getRenewalDays();
    public A withRenewalDays(int renewalDays);
    public Boolean hasRenewalDays();
    public CertificateExpirationPolicy getCertificateExpirationPolicy();
    public A withCertificateExpirationPolicy(CertificateExpirationPolicy certificateExpirationPolicy);
    public Boolean hasCertificateExpirationPolicy();



}
