package io.strimzi.api.kafka.model;

import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public interface EntityTopicOperatorSpecFluent<A extends EntityTopicOperatorSpecFluent<A>> extends Fluent<A>{


    public String getWatchedNamespace();
    public A withWatchedNamespace(String watchedNamespace);
    public Boolean hasWatchedNamespace();
    public A withNewWatchedNamespace(String arg1);
    public A withNewWatchedNamespace(StringBuilder arg1);
    public A withNewWatchedNamespace(StringBuffer arg1);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(String arg1);
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(StringBuffer arg1);
    public int getReconciliationIntervalSeconds();
    public A withReconciliationIntervalSeconds(int reconciliationIntervalSeconds);
    public Boolean hasReconciliationIntervalSeconds();
    public int getZookeeperSessionTimeoutSeconds();
    public A withZookeeperSessionTimeoutSeconds(int zookeeperSessionTimeoutSeconds);
    public Boolean hasZookeeperSessionTimeoutSeconds();
    public int getTopicMetadataMaxAttempts();
    public A withTopicMetadataMaxAttempts(int topicMetadataMaxAttempts);
    public Boolean hasTopicMetadataMaxAttempts();
    
/**
 * This method has been deprecated, please use method buildLivenessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getLivenessProbe();
    public Probe buildLivenessProbe();
    public A withLivenessProbe(Probe livenessProbe);
    public Boolean hasLivenessProbe();
    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds);
    public EntityTopicOperatorSpecFluent.LivenessProbeNested<A> withNewLivenessProbe();
    public EntityTopicOperatorSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item);
    public EntityTopicOperatorSpecFluent.LivenessProbeNested<A> editLivenessProbe();
    public EntityTopicOperatorSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe();
    public EntityTopicOperatorSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item);
    
/**
 * This method has been deprecated, please use method buildReadinessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getReadinessProbe();
    public Probe buildReadinessProbe();
    public A withReadinessProbe(Probe readinessProbe);
    public Boolean hasReadinessProbe();
    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds);
    public EntityTopicOperatorSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe();
    public EntityTopicOperatorSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item);
    public EntityTopicOperatorSpecFluent.ReadinessProbeNested<A> editReadinessProbe();
    public EntityTopicOperatorSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe();
    public EntityTopicOperatorSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item);
    public ResourceRequirements getResources();
    public A withResources(ResourceRequirements resources);
    public Boolean hasResources();
    
/**
 * This method has been deprecated, please use method buildLogging instead.
 * @return The buildable object.
 */
@Deprecated public Logging getLogging();
    public Logging buildLogging();
    public A withLogging(Logging logging);
    public Boolean hasLogging();
    public A withExternalLogging(ExternalLogging externalLogging);
    public EntityTopicOperatorSpecFluent.ExternalLoggingNested<A> withNewExternalLogging();
    public EntityTopicOperatorSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item);
    public A withInlineLogging(InlineLogging inlineLogging);
    public EntityTopicOperatorSpecFluent.InlineLoggingNested<A> withNewInlineLogging();
    public EntityTopicOperatorSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item);
    
/**
 * This method has been deprecated, please use method buildJvmOptions instead.
 * @return The buildable object.
 */
@Deprecated public JvmOptions getJvmOptions();
    public JvmOptions buildJvmOptions();
    public A withJvmOptions(JvmOptions jvmOptions);
    public Boolean hasJvmOptions();
    public EntityTopicOperatorSpecFluent.JvmOptionsNested<A> withNewJvmOptions();
    public EntityTopicOperatorSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item);
    public EntityTopicOperatorSpecFluent.JvmOptionsNested<A> editJvmOptions();
    public EntityTopicOperatorSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions();
    public EntityTopicOperatorSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item);

    public interface LivenessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<EntityTopicOperatorSpecFluent.LivenessProbeNested<N>>{

        
    public N and();    public N endLivenessProbe();
}
    public interface ReadinessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<EntityTopicOperatorSpecFluent.ReadinessProbeNested<N>>{

        
    public N and();    public N endReadinessProbe();
}
    public interface ExternalLoggingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ExternalLoggingFluent<EntityTopicOperatorSpecFluent.ExternalLoggingNested<N>>{

        
    public N and();    public N endExternalLogging();
}
    public interface InlineLoggingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,InlineLoggingFluent<EntityTopicOperatorSpecFluent.InlineLoggingNested<N>>{

        
    public N and();    public N endInlineLogging();
}
    public interface JvmOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,JvmOptionsFluent<EntityTopicOperatorSpecFluent.JvmOptionsNested<N>>{

        
    public N and();    public N endJvmOptions();
}


}
