package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EntityUserOperatorSpecBuilder extends EntityUserOperatorSpecFluentImpl<EntityUserOperatorSpecBuilder> implements VisitableBuilder<EntityUserOperatorSpec,EntityUserOperatorSpecBuilder>{

    EntityUserOperatorSpecFluent<?> fluent;
    Boolean validationEnabled;

    public EntityUserOperatorSpecBuilder(){
            this(true);
    }
    public EntityUserOperatorSpecBuilder(Boolean validationEnabled){
            this(new EntityUserOperatorSpec(), validationEnabled);
    }
    public EntityUserOperatorSpecBuilder(EntityUserOperatorSpecFluent<?> fluent){
            this(fluent, true);
    }
    public EntityUserOperatorSpecBuilder(EntityUserOperatorSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new EntityUserOperatorSpec(), validationEnabled);
    }
    public EntityUserOperatorSpecBuilder(EntityUserOperatorSpecFluent<?> fluent,EntityUserOperatorSpec instance){
            this(fluent, instance, true);
    }
    public EntityUserOperatorSpecBuilder(EntityUserOperatorSpecFluent<?> fluent,EntityUserOperatorSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withWatchedNamespace(instance.getWatchedNamespace());

            fluent.withImage(instance.getImage());

            fluent.withSecretPrefix(instance.getSecretPrefix());

            fluent.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());

            fluent.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());

            fluent.withLivenessProbe(instance.getLivenessProbe());

            fluent.withReadinessProbe(instance.getReadinessProbe());

            fluent.withResources(instance.getResources());

            fluent.withLogging(instance.getLogging());

            fluent.withJvmOptions(instance.getJvmOptions());

            this.validationEnabled = validationEnabled; 
    }
    public EntityUserOperatorSpecBuilder(EntityUserOperatorSpec instance){
            this(instance,true);
    }
    public EntityUserOperatorSpecBuilder(EntityUserOperatorSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withWatchedNamespace(instance.getWatchedNamespace());

            this.withImage(instance.getImage());

            this.withSecretPrefix(instance.getSecretPrefix());

            this.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());

            this.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());

            this.withLivenessProbe(instance.getLivenessProbe());

            this.withReadinessProbe(instance.getReadinessProbe());

            this.withResources(instance.getResources());

            this.withLogging(instance.getLogging());

            this.withJvmOptions(instance.getJvmOptions());

            this.validationEnabled = validationEnabled; 
    }

    public EntityUserOperatorSpec build(){
            EntityUserOperatorSpec buildable = new EntityUserOperatorSpec();
            buildable.setWatchedNamespace(fluent.getWatchedNamespace());
            buildable.setImage(fluent.getImage());
            buildable.setSecretPrefix(fluent.getSecretPrefix());
            buildable.setReconciliationIntervalSeconds(fluent.getReconciliationIntervalSeconds());
            buildable.setZookeeperSessionTimeoutSeconds(fluent.getZookeeperSessionTimeoutSeconds());
            buildable.setLivenessProbe(fluent.getLivenessProbe());
            buildable.setReadinessProbe(fluent.getReadinessProbe());
            buildable.setResources(fluent.getResources());
            buildable.setLogging(fluent.getLogging());
            buildable.setJvmOptions(fluent.getJvmOptions());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EntityUserOperatorSpecBuilder that = (EntityUserOperatorSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
