package io.strimzi.api.kafka.model;

import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public interface EntityUserOperatorSpecFluent<A extends EntityUserOperatorSpecFluent<A>> extends Fluent<A>{


    public String getWatchedNamespace();
    public A withWatchedNamespace(String watchedNamespace);
    public Boolean hasWatchedNamespace();
    public A withNewWatchedNamespace(String arg1);
    public A withNewWatchedNamespace(StringBuilder arg1);
    public A withNewWatchedNamespace(StringBuffer arg1);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(String arg1);
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(StringBuffer arg1);
    public String getSecretPrefix();
    public A withSecretPrefix(String secretPrefix);
    public Boolean hasSecretPrefix();
    public A withNewSecretPrefix(String arg1);
    public A withNewSecretPrefix(StringBuilder arg1);
    public A withNewSecretPrefix(StringBuffer arg1);
    public long getReconciliationIntervalSeconds();
    public A withReconciliationIntervalSeconds(long reconciliationIntervalSeconds);
    public Boolean hasReconciliationIntervalSeconds();
    public long getZookeeperSessionTimeoutSeconds();
    public A withZookeeperSessionTimeoutSeconds(long zookeeperSessionTimeoutSeconds);
    public Boolean hasZookeeperSessionTimeoutSeconds();
    
/**
 * This method has been deprecated, please use method buildLivenessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getLivenessProbe();
    public Probe buildLivenessProbe();
    public A withLivenessProbe(Probe livenessProbe);
    public Boolean hasLivenessProbe();
    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds);
    public EntityUserOperatorSpecFluent.LivenessProbeNested<A> withNewLivenessProbe();
    public EntityUserOperatorSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item);
    public EntityUserOperatorSpecFluent.LivenessProbeNested<A> editLivenessProbe();
    public EntityUserOperatorSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe();
    public EntityUserOperatorSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item);
    
/**
 * This method has been deprecated, please use method buildReadinessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getReadinessProbe();
    public Probe buildReadinessProbe();
    public A withReadinessProbe(Probe readinessProbe);
    public Boolean hasReadinessProbe();
    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds);
    public EntityUserOperatorSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe();
    public EntityUserOperatorSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item);
    public EntityUserOperatorSpecFluent.ReadinessProbeNested<A> editReadinessProbe();
    public EntityUserOperatorSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe();
    public EntityUserOperatorSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item);
    public ResourceRequirements getResources();
    public A withResources(ResourceRequirements resources);
    public Boolean hasResources();
    
/**
 * This method has been deprecated, please use method buildLogging instead.
 * @return The buildable object.
 */
@Deprecated public Logging getLogging();
    public Logging buildLogging();
    public A withLogging(Logging logging);
    public Boolean hasLogging();
    public A withExternalLogging(ExternalLogging externalLogging);
    public EntityUserOperatorSpecFluent.ExternalLoggingNested<A> withNewExternalLogging();
    public EntityUserOperatorSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item);
    public A withInlineLogging(InlineLogging inlineLogging);
    public EntityUserOperatorSpecFluent.InlineLoggingNested<A> withNewInlineLogging();
    public EntityUserOperatorSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item);
    
/**
 * This method has been deprecated, please use method buildJvmOptions instead.
 * @return The buildable object.
 */
@Deprecated public JvmOptions getJvmOptions();
    public JvmOptions buildJvmOptions();
    public A withJvmOptions(JvmOptions jvmOptions);
    public Boolean hasJvmOptions();
    public EntityUserOperatorSpecFluent.JvmOptionsNested<A> withNewJvmOptions();
    public EntityUserOperatorSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item);
    public EntityUserOperatorSpecFluent.JvmOptionsNested<A> editJvmOptions();
    public EntityUserOperatorSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions();
    public EntityUserOperatorSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item);

    public interface LivenessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<EntityUserOperatorSpecFluent.LivenessProbeNested<N>>{

        
    public N and();    public N endLivenessProbe();
}
    public interface ReadinessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<EntityUserOperatorSpecFluent.ReadinessProbeNested<N>>{

        
    public N and();    public N endReadinessProbe();
}
    public interface ExternalLoggingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ExternalLoggingFluent<EntityUserOperatorSpecFluent.ExternalLoggingNested<N>>{

        
    public N and();    public N endExternalLogging();
}
    public interface InlineLoggingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,InlineLoggingFluent<EntityUserOperatorSpecFluent.InlineLoggingNested<N>>{

        
    public N and();    public N endInlineLogging();
}
    public interface JvmOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,JvmOptionsFluent<EntityUserOperatorSpecFluent.JvmOptionsNested<N>>{

        
    public N and();    public N endJvmOptions();
}


}
