package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.lang.Object;

public class EntityUserOperatorSpecFluentImpl<A extends EntityUserOperatorSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EntityUserOperatorSpecFluent<A>{

    private String watchedNamespace;
    private String image;
    private String secretPrefix;
    private long reconciliationIntervalSeconds;
    private long zookeeperSessionTimeoutSeconds;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private ResourceRequirements resources;
    private VisitableBuilder<? extends Logging,?> logging;
    private JvmOptionsBuilder jvmOptions;

    public EntityUserOperatorSpecFluentImpl(){
    }
    public EntityUserOperatorSpecFluentImpl(EntityUserOperatorSpec instance){
            this.withWatchedNamespace(instance.getWatchedNamespace());

            this.withImage(instance.getImage());

            this.withSecretPrefix(instance.getSecretPrefix());

            this.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());

            this.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());

            this.withLivenessProbe(instance.getLivenessProbe());

            this.withReadinessProbe(instance.getReadinessProbe());

            this.withResources(instance.getResources());

            this.withLogging(instance.getLogging());

            this.withJvmOptions(instance.getJvmOptions());

    }

    public String getWatchedNamespace(){
            return this.watchedNamespace;
    }

    public A withWatchedNamespace(String watchedNamespace){
            this.watchedNamespace=watchedNamespace; return (A) this;
    }

    public Boolean hasWatchedNamespace(){
            return this.watchedNamespace != null;
    }

    public A withNewWatchedNamespace(String arg1){
            return (A)withWatchedNamespace(new String(arg1));
    }

    public A withNewWatchedNamespace(StringBuilder arg1){
            return (A)withWatchedNamespace(new String(arg1));
    }

    public A withNewWatchedNamespace(StringBuffer arg1){
            return (A)withWatchedNamespace(new String(arg1));
    }

    public String getImage(){
            return this.image;
    }

    public A withImage(String image){
            this.image=image; return (A) this;
    }

    public Boolean hasImage(){
            return this.image != null;
    }

    public A withNewImage(String arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuilder arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1){
            return (A)withImage(new String(arg1));
    }

    public String getSecretPrefix(){
            return this.secretPrefix;
    }

    public A withSecretPrefix(String secretPrefix){
            this.secretPrefix=secretPrefix; return (A) this;
    }

    public Boolean hasSecretPrefix(){
            return this.secretPrefix != null;
    }

    public A withNewSecretPrefix(String arg1){
            return (A)withSecretPrefix(new String(arg1));
    }

    public A withNewSecretPrefix(StringBuilder arg1){
            return (A)withSecretPrefix(new String(arg1));
    }

    public A withNewSecretPrefix(StringBuffer arg1){
            return (A)withSecretPrefix(new String(arg1));
    }

    public long getReconciliationIntervalSeconds(){
            return this.reconciliationIntervalSeconds;
    }

    public A withReconciliationIntervalSeconds(long reconciliationIntervalSeconds){
            this.reconciliationIntervalSeconds=reconciliationIntervalSeconds; return (A) this;
    }

    public Boolean hasReconciliationIntervalSeconds(){
            return true;
    }

    public long getZookeeperSessionTimeoutSeconds(){
            return this.zookeeperSessionTimeoutSeconds;
    }

    public A withZookeeperSessionTimeoutSeconds(long zookeeperSessionTimeoutSeconds){
            this.zookeeperSessionTimeoutSeconds=zookeeperSessionTimeoutSeconds; return (A) this;
    }

    public Boolean hasZookeeperSessionTimeoutSeconds(){
            return true;
    }

    
/**
 * This method has been deprecated, please use method buildLivenessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getLivenessProbe(){
            return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public Probe buildLivenessProbe(){
            return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public A withLivenessProbe(Probe livenessProbe){
            _visitables.get("livenessProbe").remove(this.livenessProbe);
            if (livenessProbe!=null){ this.livenessProbe= new ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} return (A) this;
    }

    public Boolean hasLivenessProbe(){
            return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds){
            return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public EntityUserOperatorSpecFluent.LivenessProbeNested<A> withNewLivenessProbe(){
            return new LivenessProbeNestedImpl();
    }

    public EntityUserOperatorSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item){
            return new LivenessProbeNestedImpl(item);
    }

    public EntityUserOperatorSpecFluent.LivenessProbeNested<A> editLivenessProbe(){
            return withNewLivenessProbeLike(getLivenessProbe());
    }

    public EntityUserOperatorSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe(){
            return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): new ProbeBuilder().build());
    }

    public EntityUserOperatorSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item){
            return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): item);
    }

    
/**
 * This method has been deprecated, please use method buildReadinessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getReadinessProbe(){
            return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public Probe buildReadinessProbe(){
            return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public A withReadinessProbe(Probe readinessProbe){
            _visitables.get("readinessProbe").remove(this.readinessProbe);
            if (readinessProbe!=null){ this.readinessProbe= new ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} return (A) this;
    }

    public Boolean hasReadinessProbe(){
            return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds){
            return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public EntityUserOperatorSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe(){
            return new ReadinessProbeNestedImpl();
    }

    public EntityUserOperatorSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item){
            return new ReadinessProbeNestedImpl(item);
    }

    public EntityUserOperatorSpecFluent.ReadinessProbeNested<A> editReadinessProbe(){
            return withNewReadinessProbeLike(getReadinessProbe());
    }

    public EntityUserOperatorSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe(){
            return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): new ProbeBuilder().build());
    }

    public EntityUserOperatorSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item){
            return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): item);
    }

    public ResourceRequirements getResources(){
            return this.resources;
    }

    public A withResources(ResourceRequirements resources){
            this.resources=resources; return (A) this;
    }

    public Boolean hasResources(){
            return this.resources != null;
    }

    
/**
 * This method has been deprecated, please use method buildLogging instead.
 * @return The buildable object.
 */
@Deprecated public Logging getLogging(){
            return this.logging!=null?this.logging.build():null;
    }

    public Logging buildLogging(){
            return this.logging!=null?this.logging.build():null;
    }

    public A withLogging(Logging logging){
            if (logging instanceof ExternalLogging){ this.logging= new ExternalLoggingBuilder((ExternalLogging)logging); _visitables.get("logging").add(this.logging);}
            if (logging instanceof InlineLogging){ this.logging= new InlineLoggingBuilder((InlineLogging)logging); _visitables.get("logging").add(this.logging);}
            return (A) this;
    }

    public Boolean hasLogging(){
            return this.logging != null;
    }

    public A withExternalLogging(ExternalLogging externalLogging){
            _visitables.get("logging").remove(this.logging);
            if (externalLogging!=null){ this.logging= new ExternalLoggingBuilder(externalLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public EntityUserOperatorSpecFluent.ExternalLoggingNested<A> withNewExternalLogging(){
            return new ExternalLoggingNestedImpl();
    }

    public EntityUserOperatorSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item){
            return new ExternalLoggingNestedImpl(item);
    }

    public A withInlineLogging(InlineLogging inlineLogging){
            _visitables.get("logging").remove(this.logging);
            if (inlineLogging!=null){ this.logging= new InlineLoggingBuilder(inlineLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public EntityUserOperatorSpecFluent.InlineLoggingNested<A> withNewInlineLogging(){
            return new InlineLoggingNestedImpl();
    }

    public EntityUserOperatorSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item){
            return new InlineLoggingNestedImpl(item);
    }

    
/**
 * This method has been deprecated, please use method buildJvmOptions instead.
 * @return The buildable object.
 */
@Deprecated public JvmOptions getJvmOptions(){
            return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public JvmOptions buildJvmOptions(){
            return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public A withJvmOptions(JvmOptions jvmOptions){
            _visitables.get("jvmOptions").remove(this.jvmOptions);
            if (jvmOptions!=null){ this.jvmOptions= new JvmOptionsBuilder(jvmOptions); _visitables.get("jvmOptions").add(this.jvmOptions);} return (A) this;
    }

    public Boolean hasJvmOptions(){
            return this.jvmOptions != null;
    }

    public EntityUserOperatorSpecFluent.JvmOptionsNested<A> withNewJvmOptions(){
            return new JvmOptionsNestedImpl();
    }

    public EntityUserOperatorSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item){
            return new JvmOptionsNestedImpl(item);
    }

    public EntityUserOperatorSpecFluent.JvmOptionsNested<A> editJvmOptions(){
            return withNewJvmOptionsLike(getJvmOptions());
    }

    public EntityUserOperatorSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions(){
            return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): new JvmOptionsBuilder().build());
    }

    public EntityUserOperatorSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item){
            return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            EntityUserOperatorSpecFluentImpl that = (EntityUserOperatorSpecFluentImpl) o;
            if (watchedNamespace != null ? !watchedNamespace.equals(that.watchedNamespace) :that.watchedNamespace != null) return false;
            if (image != null ? !image.equals(that.image) :that.image != null) return false;
            if (secretPrefix != null ? !secretPrefix.equals(that.secretPrefix) :that.secretPrefix != null) return false;
            if (reconciliationIntervalSeconds != that.reconciliationIntervalSeconds) return false;
            if (zookeeperSessionTimeoutSeconds != that.zookeeperSessionTimeoutSeconds) return false;
            if (livenessProbe != null ? !livenessProbe.equals(that.livenessProbe) :that.livenessProbe != null) return false;
            if (readinessProbe != null ? !readinessProbe.equals(that.readinessProbe) :that.readinessProbe != null) return false;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            if (logging != null ? !logging.equals(that.logging) :that.logging != null) return false;
            if (jvmOptions != null ? !jvmOptions.equals(that.jvmOptions) :that.jvmOptions != null) return false;
            return true;
    }


    public class LivenessProbeNestedImpl<N> extends ProbeFluentImpl<EntityUserOperatorSpecFluent.LivenessProbeNested<N>> implements EntityUserOperatorSpecFluent.LivenessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProbeBuilder builder;
    
            LivenessProbeNestedImpl(Probe item){
                    this.builder = new ProbeBuilder(this, item);
            }
            LivenessProbeNestedImpl(){
                    this.builder = new ProbeBuilder(this);
            }
    
    public N and(){
            return (N) EntityUserOperatorSpecFluentImpl.this.withLivenessProbe(builder.build());
    }
    public N endLivenessProbe(){
            return and();
    }

}
    public class ReadinessProbeNestedImpl<N> extends ProbeFluentImpl<EntityUserOperatorSpecFluent.ReadinessProbeNested<N>> implements EntityUserOperatorSpecFluent.ReadinessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProbeBuilder builder;
    
            ReadinessProbeNestedImpl(Probe item){
                    this.builder = new ProbeBuilder(this, item);
            }
            ReadinessProbeNestedImpl(){
                    this.builder = new ProbeBuilder(this);
            }
    
    public N and(){
            return (N) EntityUserOperatorSpecFluentImpl.this.withReadinessProbe(builder.build());
    }
    public N endReadinessProbe(){
            return and();
    }

}
    public class ExternalLoggingNestedImpl<N> extends ExternalLoggingFluentImpl<EntityUserOperatorSpecFluent.ExternalLoggingNested<N>> implements EntityUserOperatorSpecFluent.ExternalLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ExternalLoggingBuilder builder;
    
            ExternalLoggingNestedImpl(ExternalLogging item){
                    this.builder = new ExternalLoggingBuilder(this, item);
            }
            ExternalLoggingNestedImpl(){
                    this.builder = new ExternalLoggingBuilder(this);
            }
    
    public N and(){
            return (N) EntityUserOperatorSpecFluentImpl.this.withExternalLogging(builder.build());
    }
    public N endExternalLogging(){
            return and();
    }

}
    public class InlineLoggingNestedImpl<N> extends InlineLoggingFluentImpl<EntityUserOperatorSpecFluent.InlineLoggingNested<N>> implements EntityUserOperatorSpecFluent.InlineLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final InlineLoggingBuilder builder;
    
            InlineLoggingNestedImpl(InlineLogging item){
                    this.builder = new InlineLoggingBuilder(this, item);
            }
            InlineLoggingNestedImpl(){
                    this.builder = new InlineLoggingBuilder(this);
            }
    
    public N and(){
            return (N) EntityUserOperatorSpecFluentImpl.this.withInlineLogging(builder.build());
    }
    public N endInlineLogging(){
            return and();
    }

}
    public class JvmOptionsNestedImpl<N> extends JvmOptionsFluentImpl<EntityUserOperatorSpecFluent.JvmOptionsNested<N>> implements EntityUserOperatorSpecFluent.JvmOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final JvmOptionsBuilder builder;
    
            JvmOptionsNestedImpl(JvmOptions item){
                    this.builder = new JvmOptionsBuilder(this, item);
            }
            JvmOptionsNestedImpl(){
                    this.builder = new JvmOptionsBuilder(this);
            }
    
    public N and(){
            return (N) EntityUserOperatorSpecFluentImpl.this.withJvmOptions(builder.build());
    }
    public N endJvmOptions(){
            return and();
    }

}


}
