package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExternalConfigurationMetricsBuilder extends ExternalConfigurationMetricsFluentImpl<ExternalConfigurationMetricsBuilder> implements VisitableBuilder<ExternalConfigurationMetrics,ExternalConfigurationMetricsBuilder>{

    ExternalConfigurationMetricsFluent<?> fluent;
    Boolean validationEnabled;

    public ExternalConfigurationMetricsBuilder(){
            this(true);
    }
    public ExternalConfigurationMetricsBuilder(Boolean validationEnabled){
            this(new ExternalConfigurationMetrics(), validationEnabled);
    }
    public ExternalConfigurationMetricsBuilder(ExternalConfigurationMetricsFluent<?> fluent){
            this(fluent, true);
    }
    public ExternalConfigurationMetricsBuilder(ExternalConfigurationMetricsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExternalConfigurationMetrics(), validationEnabled);
    }
    public ExternalConfigurationMetricsBuilder(ExternalConfigurationMetricsFluent<?> fluent,ExternalConfigurationMetrics instance){
            this(fluent, instance, true);
    }
    public ExternalConfigurationMetricsBuilder(ExternalConfigurationMetricsFluent<?> fluent,ExternalConfigurationMetrics instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConfigMapKeyRef(instance.getConfigMapKeyRef());

            this.validationEnabled = validationEnabled; 
    }
    public ExternalConfigurationMetricsBuilder(ExternalConfigurationMetrics instance){
            this(instance,true);
    }
    public ExternalConfigurationMetricsBuilder(ExternalConfigurationMetrics instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConfigMapKeyRef(instance.getConfigMapKeyRef());

            this.validationEnabled = validationEnabled; 
    }

    public ExternalConfigurationMetrics build(){
            ExternalConfigurationMetrics buildable = new ExternalConfigurationMetrics();
            buildable.setConfigMapKeyRef(fluent.getConfigMapKeyRef());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExternalConfigurationMetricsBuilder that = (ExternalConfigurationMetricsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
