package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;

public class ExternalConfigurationMetricsFluentImpl<A extends ExternalConfigurationMetricsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ExternalConfigurationMetricsFluent<A>{

    private ConfigMapKeySelector configMapKeyRef;

    public ExternalConfigurationMetricsFluentImpl(){
    }
    public ExternalConfigurationMetricsFluentImpl(ExternalConfigurationMetrics instance){
            this.withConfigMapKeyRef(instance.getConfigMapKeyRef());

    }

    public ConfigMapKeySelector getConfigMapKeyRef(){
            return this.configMapKeyRef;
    }

    public A withConfigMapKeyRef(ConfigMapKeySelector configMapKeyRef){
            this.configMapKeyRef=configMapKeyRef; return (A) this;
    }

    public Boolean hasConfigMapKeyRef(){
            return this.configMapKeyRef != null;
    }

    public A withNewConfigMapKeyRef(String key,String name,Boolean optional){
            return (A)withConfigMapKeyRef(new ConfigMapKeySelector(key, name, optional));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ExternalConfigurationMetricsFluentImpl that = (ExternalConfigurationMetricsFluentImpl) o;
            if (configMapKeyRef != null ? !configMapKeyRef.equals(that.configMapKeyRef) :that.configMapKeyRef != null) return false;
            return true;
    }




}
