package io.strimzi.api.kafka.model;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class GenericSecretSourceFluentImpl<A extends GenericSecretSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements GenericSecretSourceFluent<A>{

    private String secretName;
    private String key;

    public GenericSecretSourceFluentImpl(){
    }
    public GenericSecretSourceFluentImpl(GenericSecretSource instance){
            this.withSecretName(instance.getSecretName());

            this.withKey(instance.getKey());

    }

    public String getSecretName(){
            return this.secretName;
    }

    public A withSecretName(String secretName){
            this.secretName=secretName; return (A) this;
    }

    public Boolean hasSecretName(){
            return this.secretName != null;
    }

    public A withNewSecretName(String arg1){
            return (A)withSecretName(new String(arg1));
    }

    public A withNewSecretName(StringBuilder arg1){
            return (A)withSecretName(new String(arg1));
    }

    public A withNewSecretName(StringBuffer arg1){
            return (A)withSecretName(new String(arg1));
    }

    public String getKey(){
            return this.key;
    }

    public A withKey(String key){
            this.key=key; return (A) this;
    }

    public Boolean hasKey(){
            return this.key != null;
    }

    public A withNewKey(String arg1){
            return (A)withKey(new String(arg1));
    }

    public A withNewKey(StringBuilder arg1){
            return (A)withKey(new String(arg1));
    }

    public A withNewKey(StringBuffer arg1){
            return (A)withKey(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            GenericSecretSourceFluentImpl that = (GenericSecretSourceFluentImpl) o;
            if (secretName != null ? !secretName.equals(that.secretName) :that.secretName != null) return false;
            if (key != null ? !key.equals(that.key) :that.key != null) return false;
            return true;
    }




}
