package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JmxPrometheusExporterMetricsBuilder extends JmxPrometheusExporterMetricsFluentImpl<JmxPrometheusExporterMetricsBuilder> implements VisitableBuilder<JmxPrometheusExporterMetrics,JmxPrometheusExporterMetricsBuilder>{

    JmxPrometheusExporterMetricsFluent<?> fluent;
    Boolean validationEnabled;

    public JmxPrometheusExporterMetricsBuilder(){
            this(true);
    }
    public JmxPrometheusExporterMetricsBuilder(Boolean validationEnabled){
            this(new JmxPrometheusExporterMetrics(), validationEnabled);
    }
    public JmxPrometheusExporterMetricsBuilder(JmxPrometheusExporterMetricsFluent<?> fluent){
            this(fluent, true);
    }
    public JmxPrometheusExporterMetricsBuilder(JmxPrometheusExporterMetricsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new JmxPrometheusExporterMetrics(), validationEnabled);
    }
    public JmxPrometheusExporterMetricsBuilder(JmxPrometheusExporterMetricsFluent<?> fluent,JmxPrometheusExporterMetrics instance){
            this(fluent, instance, true);
    }
    public JmxPrometheusExporterMetricsBuilder(JmxPrometheusExporterMetricsFluent<?> fluent,JmxPrometheusExporterMetrics instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withValueFrom(instance.getValueFrom());

            this.validationEnabled = validationEnabled; 
    }
    public JmxPrometheusExporterMetricsBuilder(JmxPrometheusExporterMetrics instance){
            this(instance,true);
    }
    public JmxPrometheusExporterMetricsBuilder(JmxPrometheusExporterMetrics instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withValueFrom(instance.getValueFrom());

            this.validationEnabled = validationEnabled; 
    }

    public JmxPrometheusExporterMetrics build(){
            JmxPrometheusExporterMetrics buildable = new JmxPrometheusExporterMetrics();
            buildable.setValueFrom(fluent.getValueFrom());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            JmxPrometheusExporterMetricsBuilder that = (JmxPrometheusExporterMetricsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
