package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate;
import io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder;
import io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateFluent;
import io.strimzi.api.kafka.model.template.JmxTransQueryTemplate;
import io.strimzi.api.kafka.model.template.JmxTransTemplateFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.strimzi.api.kafka.model.template.JmxTransTemplateBuilder;
import java.lang.StringBuffer;
import io.strimzi.api.kafka.model.template.JmxTransQueryTemplateFluent;
import java.util.Collection;
import java.lang.Object;
import io.strimzi.api.kafka.model.template.JmxTransTemplate;
import java.util.Map;

public interface JmxTransSpecFluent<A extends JmxTransSpecFluent<A>> extends Fluent<A>{


    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(String arg1);
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(StringBuffer arg1);
    public String getLogLevel();
    public A withLogLevel(String logLevel);
    public Boolean hasLogLevel();
    public A withNewLogLevel(String arg1);
    public A withNewLogLevel(StringBuilder arg1);
    public A withNewLogLevel(StringBuffer arg1);
    public A addToOutputDefinitions(int index,JmxTransOutputDefinitionTemplate item);
    public A setToOutputDefinitions(int index,JmxTransOutputDefinitionTemplate item);
    public A addToOutputDefinitions(JmxTransOutputDefinitionTemplate... items);
    public A addAllToOutputDefinitions(Collection<JmxTransOutputDefinitionTemplate> items);
    public A removeFromOutputDefinitions(JmxTransOutputDefinitionTemplate... items);
    public A removeAllFromOutputDefinitions(Collection<JmxTransOutputDefinitionTemplate> items);
    public A removeMatchingFromOutputDefinitions(io.fabric8.kubernetes.api.builder.Predicate<JmxTransOutputDefinitionTemplateBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildOutputDefinitions instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<JmxTransOutputDefinitionTemplate> getOutputDefinitions();
    public java.util.List<JmxTransOutputDefinitionTemplate> buildOutputDefinitions();
    public JmxTransOutputDefinitionTemplate buildOutputDefinition(int index);
    public JmxTransOutputDefinitionTemplate buildFirstOutputDefinition();
    public JmxTransOutputDefinitionTemplate buildLastOutputDefinition();
    public JmxTransOutputDefinitionTemplate buildMatchingOutputDefinition(io.fabric8.kubernetes.api.builder.Predicate<JmxTransOutputDefinitionTemplateBuilder> predicate);
    public Boolean hasMatchingOutputDefinition(io.fabric8.kubernetes.api.builder.Predicate<JmxTransOutputDefinitionTemplateBuilder> predicate);
    public A withOutputDefinitions(java.util.List<JmxTransOutputDefinitionTemplate> outputDefinitions);
    public A withOutputDefinitions(JmxTransOutputDefinitionTemplate... outputDefinitions);
    public Boolean hasOutputDefinitions();
    public JmxTransSpecFluent.OutputDefinitionsNested<A> addNewOutputDefinition();
    public JmxTransSpecFluent.OutputDefinitionsNested<A> addNewOutputDefinitionLike(JmxTransOutputDefinitionTemplate item);
    public JmxTransSpecFluent.OutputDefinitionsNested<A> setNewOutputDefinitionLike(int index,JmxTransOutputDefinitionTemplate item);
    public JmxTransSpecFluent.OutputDefinitionsNested<A> editOutputDefinition(int index);
    public JmxTransSpecFluent.OutputDefinitionsNested<A> editFirstOutputDefinition();
    public JmxTransSpecFluent.OutputDefinitionsNested<A> editLastOutputDefinition();
    public JmxTransSpecFluent.OutputDefinitionsNested<A> editMatchingOutputDefinition(io.fabric8.kubernetes.api.builder.Predicate<JmxTransOutputDefinitionTemplateBuilder> predicate);
    public A addToKafkaQueries(int index,JmxTransQueryTemplate item);
    public A setToKafkaQueries(int index,JmxTransQueryTemplate item);
    public A addToKafkaQueries(JmxTransQueryTemplate... items);
    public A addAllToKafkaQueries(Collection<JmxTransQueryTemplate> items);
    public A removeFromKafkaQueries(JmxTransQueryTemplate... items);
    public A removeAllFromKafkaQueries(Collection<JmxTransQueryTemplate> items);
    public A removeMatchingFromKafkaQueries(io.fabric8.kubernetes.api.builder.Predicate<JmxTransQueryTemplateBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildKafkaQueries instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<JmxTransQueryTemplate> getKafkaQueries();
    public java.util.List<JmxTransQueryTemplate> buildKafkaQueries();
    public JmxTransQueryTemplate buildKafkaQuery(int index);
    public JmxTransQueryTemplate buildFirstKafkaQuery();
    public JmxTransQueryTemplate buildLastKafkaQuery();
    public JmxTransQueryTemplate buildMatchingKafkaQuery(io.fabric8.kubernetes.api.builder.Predicate<JmxTransQueryTemplateBuilder> predicate);
    public Boolean hasMatchingKafkaQuery(io.fabric8.kubernetes.api.builder.Predicate<JmxTransQueryTemplateBuilder> predicate);
    public A withKafkaQueries(java.util.List<JmxTransQueryTemplate> kafkaQueries);
    public A withKafkaQueries(JmxTransQueryTemplate... kafkaQueries);
    public Boolean hasKafkaQueries();
    public JmxTransSpecFluent.KafkaQueriesNested<A> addNewKafkaQuery();
    public JmxTransSpecFluent.KafkaQueriesNested<A> addNewKafkaQueryLike(JmxTransQueryTemplate item);
    public JmxTransSpecFluent.KafkaQueriesNested<A> setNewKafkaQueryLike(int index,JmxTransQueryTemplate item);
    public JmxTransSpecFluent.KafkaQueriesNested<A> editKafkaQuery(int index);
    public JmxTransSpecFluent.KafkaQueriesNested<A> editFirstKafkaQuery();
    public JmxTransSpecFluent.KafkaQueriesNested<A> editLastKafkaQuery();
    public JmxTransSpecFluent.KafkaQueriesNested<A> editMatchingKafkaQuery(io.fabric8.kubernetes.api.builder.Predicate<JmxTransQueryTemplateBuilder> predicate);
    public ResourceRequirements getResources();
    public A withResources(ResourceRequirements resources);
    public Boolean hasResources();
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public JmxTransTemplate getTemplate();
    public JmxTransTemplate buildTemplate();
    public A withTemplate(JmxTransTemplate template);
    public Boolean hasTemplate();
    public JmxTransSpecFluent.TemplateNested<A> withNewTemplate();
    public JmxTransSpecFluent.TemplateNested<A> withNewTemplateLike(JmxTransTemplate item);
    public JmxTransSpecFluent.TemplateNested<A> editTemplate();
    public JmxTransSpecFluent.TemplateNested<A> editOrNewTemplate();
    public JmxTransSpecFluent.TemplateNested<A> editOrNewTemplateLike(JmxTransTemplate item);

    public interface OutputDefinitionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,JmxTransOutputDefinitionTemplateFluent<JmxTransSpecFluent.OutputDefinitionsNested<N>>{

        
    public N and();    public N endOutputDefinition();
}
    public interface KafkaQueriesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,JmxTransQueryTemplateFluent<JmxTransSpecFluent.KafkaQueriesNested<N>>{

        
    public N and();    public N endKafkaQuery();
}
    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,JmxTransTemplateFluent<JmxTransSpecFluent.TemplateNested<N>>{

        
    public N and();    public N endTemplate();
}


}
