package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate;
import io.strimzi.api.kafka.model.template.JmxTransQueryTemplateBuilder;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder;
import io.strimzi.api.kafka.model.template.JmxTransTemplateFluentImpl;
import io.strimzi.api.kafka.model.template.JmxTransQueryTemplate;
import io.strimzi.api.kafka.model.template.JmxTransTemplateBuilder;
import io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateFluentImpl;
import io.strimzi.api.kafka.model.template.JmxTransQueryTemplateFluentImpl;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import io.strimzi.api.kafka.model.template.JmxTransTemplate;

public class JmxTransSpecFluentImpl<A extends JmxTransSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements JmxTransSpecFluent<A>{

    private String image;
    private String logLevel;
    private java.util.List<JmxTransOutputDefinitionTemplateBuilder> outputDefinitions;
    private java.util.List<JmxTransQueryTemplateBuilder> kafkaQueries;
    private ResourceRequirements resources;
    private JmxTransTemplateBuilder template;

    public JmxTransSpecFluentImpl(){
    }
    public JmxTransSpecFluentImpl(JmxTransSpec instance){
            this.withImage(instance.getImage());

            this.withLogLevel(instance.getLogLevel());

            this.withOutputDefinitions(instance.getOutputDefinitions());

            this.withKafkaQueries(instance.getKafkaQueries());

            this.withResources(instance.getResources());

            this.withTemplate(instance.getTemplate());

    }

    public String getImage(){
            return this.image;
    }

    public A withImage(String image){
            this.image=image; return (A) this;
    }

    public Boolean hasImage(){
            return this.image != null;
    }

    public A withNewImage(String arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuilder arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1){
            return (A)withImage(new String(arg1));
    }

    public String getLogLevel(){
            return this.logLevel;
    }

    public A withLogLevel(String logLevel){
            this.logLevel=logLevel; return (A) this;
    }

    public Boolean hasLogLevel(){
            return this.logLevel != null;
    }

    public A withNewLogLevel(String arg1){
            return (A)withLogLevel(new String(arg1));
    }

    public A withNewLogLevel(StringBuilder arg1){
            return (A)withLogLevel(new String(arg1));
    }

    public A withNewLogLevel(StringBuffer arg1){
            return (A)withLogLevel(new String(arg1));
    }

    public A addToOutputDefinitions(int index,JmxTransOutputDefinitionTemplate item){
            if (this.outputDefinitions == null) {this.outputDefinitions = new ArrayList<JmxTransOutputDefinitionTemplateBuilder>();}
            JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);_visitables.get("outputDefinitions").add(index >= 0 ? index : _visitables.get("outputDefinitions").size(), builder);this.outputDefinitions.add(index >= 0 ? index : outputDefinitions.size(), builder); return (A)this;
    }

    public A setToOutputDefinitions(int index,JmxTransOutputDefinitionTemplate item){
            if (this.outputDefinitions == null) {this.outputDefinitions = new ArrayList<JmxTransOutputDefinitionTemplateBuilder>();}
            JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);
            if (index < 0 || index >= _visitables.get("outputDefinitions").size()) { _visitables.get("outputDefinitions").add(builder); } else { _visitables.get("outputDefinitions").set(index, builder);}
            if (index < 0 || index >= outputDefinitions.size()) { outputDefinitions.add(builder); } else { outputDefinitions.set(index, builder);}
             return (A)this;
    }

    public A addToOutputDefinitions(JmxTransOutputDefinitionTemplate... items){
            if (this.outputDefinitions == null) {this.outputDefinitions = new ArrayList<JmxTransOutputDefinitionTemplateBuilder>();}
            for (JmxTransOutputDefinitionTemplate item : items) {JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);_visitables.get("outputDefinitions").add(builder);this.outputDefinitions.add(builder);} return (A)this;
    }

    public A addAllToOutputDefinitions(Collection<JmxTransOutputDefinitionTemplate> items){
            if (this.outputDefinitions == null) {this.outputDefinitions = new ArrayList<JmxTransOutputDefinitionTemplateBuilder>();}
            for (JmxTransOutputDefinitionTemplate item : items) {JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);_visitables.get("outputDefinitions").add(builder);this.outputDefinitions.add(builder);} return (A)this;
    }

    public A removeFromOutputDefinitions(JmxTransOutputDefinitionTemplate... items){
            for (JmxTransOutputDefinitionTemplate item : items) {JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);_visitables.get("outputDefinitions").remove(builder);if (this.outputDefinitions != null) {this.outputDefinitions.remove(builder);}} return (A)this;
    }

    public A removeAllFromOutputDefinitions(Collection<JmxTransOutputDefinitionTemplate> items){
            for (JmxTransOutputDefinitionTemplate item : items) {JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);_visitables.get("outputDefinitions").remove(builder);if (this.outputDefinitions != null) {this.outputDefinitions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromOutputDefinitions(io.fabric8.kubernetes.api.builder.Predicate<JmxTransOutputDefinitionTemplateBuilder> predicate){
            if (outputDefinitions == null) return (A) this;
            final Iterator<JmxTransOutputDefinitionTemplateBuilder> each = outputDefinitions.iterator();
            final List visitables = _visitables.get("outputDefinitions");
            while (each.hasNext()) {
              JmxTransOutputDefinitionTemplateBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildOutputDefinitions instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<JmxTransOutputDefinitionTemplate> getOutputDefinitions(){
            return build(outputDefinitions);
    }

    public java.util.List<JmxTransOutputDefinitionTemplate> buildOutputDefinitions(){
            return build(outputDefinitions);
    }

    public JmxTransOutputDefinitionTemplate buildOutputDefinition(int index){
            return this.outputDefinitions.get(index).build();
    }

    public JmxTransOutputDefinitionTemplate buildFirstOutputDefinition(){
            return this.outputDefinitions.get(0).build();
    }

    public JmxTransOutputDefinitionTemplate buildLastOutputDefinition(){
            return this.outputDefinitions.get(outputDefinitions.size() - 1).build();
    }

    public JmxTransOutputDefinitionTemplate buildMatchingOutputDefinition(io.fabric8.kubernetes.api.builder.Predicate<JmxTransOutputDefinitionTemplateBuilder> predicate){
            for (JmxTransOutputDefinitionTemplateBuilder item: outputDefinitions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingOutputDefinition(io.fabric8.kubernetes.api.builder.Predicate<JmxTransOutputDefinitionTemplateBuilder> predicate){
            for (JmxTransOutputDefinitionTemplateBuilder item: outputDefinitions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withOutputDefinitions(java.util.List<JmxTransOutputDefinitionTemplate> outputDefinitions){
            if (this.outputDefinitions != null) { _visitables.get("outputDefinitions").removeAll(this.outputDefinitions);}
            if (outputDefinitions != null) {this.outputDefinitions = new ArrayList<JmxTransOutputDefinitionTemplateBuilder>(); for (JmxTransOutputDefinitionTemplate item : outputDefinitions){this.addToOutputDefinitions(item);}} else { this.outputDefinitions = null;} return (A) this;
    }

    public A withOutputDefinitions(JmxTransOutputDefinitionTemplate... outputDefinitions){
            if (this.outputDefinitions != null) {this.outputDefinitions.clear();}
            if (outputDefinitions != null) {for (JmxTransOutputDefinitionTemplate item :outputDefinitions){ this.addToOutputDefinitions(item);}} return (A) this;
    }

    public Boolean hasOutputDefinitions(){
            return outputDefinitions != null && !outputDefinitions.isEmpty();
    }

    public JmxTransSpecFluent.OutputDefinitionsNested<A> addNewOutputDefinition(){
            return new OutputDefinitionsNestedImpl();
    }

    public JmxTransSpecFluent.OutputDefinitionsNested<A> addNewOutputDefinitionLike(JmxTransOutputDefinitionTemplate item){
            return new OutputDefinitionsNestedImpl(-1, item);
    }

    public JmxTransSpecFluent.OutputDefinitionsNested<A> setNewOutputDefinitionLike(int index,JmxTransOutputDefinitionTemplate item){
            return new OutputDefinitionsNestedImpl(index, item);
    }

    public JmxTransSpecFluent.OutputDefinitionsNested<A> editOutputDefinition(int index){
            if (outputDefinitions.size() <= index) throw new RuntimeException("Can't edit outputDefinitions. Index exceeds size.");
            return setNewOutputDefinitionLike(index, buildOutputDefinition(index));
    }

    public JmxTransSpecFluent.OutputDefinitionsNested<A> editFirstOutputDefinition(){
            if (outputDefinitions.size() == 0) throw new RuntimeException("Can't edit first outputDefinitions. The list is empty.");
            return setNewOutputDefinitionLike(0, buildOutputDefinition(0));
    }

    public JmxTransSpecFluent.OutputDefinitionsNested<A> editLastOutputDefinition(){
            int index = outputDefinitions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last outputDefinitions. The list is empty.");
            return setNewOutputDefinitionLike(index, buildOutputDefinition(index));
    }

    public JmxTransSpecFluent.OutputDefinitionsNested<A> editMatchingOutputDefinition(io.fabric8.kubernetes.api.builder.Predicate<JmxTransOutputDefinitionTemplateBuilder> predicate){
            int index = -1;
            for (int i=0;i<outputDefinitions.size();i++) { 
            if (predicate.apply(outputDefinitions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching outputDefinitions. No match found.");
            return setNewOutputDefinitionLike(index, buildOutputDefinition(index));
    }

    public A addToKafkaQueries(int index,JmxTransQueryTemplate item){
            if (this.kafkaQueries == null) {this.kafkaQueries = new ArrayList<JmxTransQueryTemplateBuilder>();}
            JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);_visitables.get("kafkaQueries").add(index >= 0 ? index : _visitables.get("kafkaQueries").size(), builder);this.kafkaQueries.add(index >= 0 ? index : kafkaQueries.size(), builder); return (A)this;
    }

    public A setToKafkaQueries(int index,JmxTransQueryTemplate item){
            if (this.kafkaQueries == null) {this.kafkaQueries = new ArrayList<JmxTransQueryTemplateBuilder>();}
            JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);
            if (index < 0 || index >= _visitables.get("kafkaQueries").size()) { _visitables.get("kafkaQueries").add(builder); } else { _visitables.get("kafkaQueries").set(index, builder);}
            if (index < 0 || index >= kafkaQueries.size()) { kafkaQueries.add(builder); } else { kafkaQueries.set(index, builder);}
             return (A)this;
    }

    public A addToKafkaQueries(JmxTransQueryTemplate... items){
            if (this.kafkaQueries == null) {this.kafkaQueries = new ArrayList<JmxTransQueryTemplateBuilder>();}
            for (JmxTransQueryTemplate item : items) {JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);_visitables.get("kafkaQueries").add(builder);this.kafkaQueries.add(builder);} return (A)this;
    }

    public A addAllToKafkaQueries(Collection<JmxTransQueryTemplate> items){
            if (this.kafkaQueries == null) {this.kafkaQueries = new ArrayList<JmxTransQueryTemplateBuilder>();}
            for (JmxTransQueryTemplate item : items) {JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);_visitables.get("kafkaQueries").add(builder);this.kafkaQueries.add(builder);} return (A)this;
    }

    public A removeFromKafkaQueries(JmxTransQueryTemplate... items){
            for (JmxTransQueryTemplate item : items) {JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);_visitables.get("kafkaQueries").remove(builder);if (this.kafkaQueries != null) {this.kafkaQueries.remove(builder);}} return (A)this;
    }

    public A removeAllFromKafkaQueries(Collection<JmxTransQueryTemplate> items){
            for (JmxTransQueryTemplate item : items) {JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);_visitables.get("kafkaQueries").remove(builder);if (this.kafkaQueries != null) {this.kafkaQueries.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromKafkaQueries(io.fabric8.kubernetes.api.builder.Predicate<JmxTransQueryTemplateBuilder> predicate){
            if (kafkaQueries == null) return (A) this;
            final Iterator<JmxTransQueryTemplateBuilder> each = kafkaQueries.iterator();
            final List visitables = _visitables.get("kafkaQueries");
            while (each.hasNext()) {
              JmxTransQueryTemplateBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildKafkaQueries instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<JmxTransQueryTemplate> getKafkaQueries(){
            return build(kafkaQueries);
    }

    public java.util.List<JmxTransQueryTemplate> buildKafkaQueries(){
            return build(kafkaQueries);
    }

    public JmxTransQueryTemplate buildKafkaQuery(int index){
            return this.kafkaQueries.get(index).build();
    }

    public JmxTransQueryTemplate buildFirstKafkaQuery(){
            return this.kafkaQueries.get(0).build();
    }

    public JmxTransQueryTemplate buildLastKafkaQuery(){
            return this.kafkaQueries.get(kafkaQueries.size() - 1).build();
    }

    public JmxTransQueryTemplate buildMatchingKafkaQuery(io.fabric8.kubernetes.api.builder.Predicate<JmxTransQueryTemplateBuilder> predicate){
            for (JmxTransQueryTemplateBuilder item: kafkaQueries) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingKafkaQuery(io.fabric8.kubernetes.api.builder.Predicate<JmxTransQueryTemplateBuilder> predicate){
            for (JmxTransQueryTemplateBuilder item: kafkaQueries) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withKafkaQueries(java.util.List<JmxTransQueryTemplate> kafkaQueries){
            if (this.kafkaQueries != null) { _visitables.get("kafkaQueries").removeAll(this.kafkaQueries);}
            if (kafkaQueries != null) {this.kafkaQueries = new ArrayList<JmxTransQueryTemplateBuilder>(); for (JmxTransQueryTemplate item : kafkaQueries){this.addToKafkaQueries(item);}} else { this.kafkaQueries = null;} return (A) this;
    }

    public A withKafkaQueries(JmxTransQueryTemplate... kafkaQueries){
            if (this.kafkaQueries != null) {this.kafkaQueries.clear();}
            if (kafkaQueries != null) {for (JmxTransQueryTemplate item :kafkaQueries){ this.addToKafkaQueries(item);}} return (A) this;
    }

    public Boolean hasKafkaQueries(){
            return kafkaQueries != null && !kafkaQueries.isEmpty();
    }

    public JmxTransSpecFluent.KafkaQueriesNested<A> addNewKafkaQuery(){
            return new KafkaQueriesNestedImpl();
    }

    public JmxTransSpecFluent.KafkaQueriesNested<A> addNewKafkaQueryLike(JmxTransQueryTemplate item){
            return new KafkaQueriesNestedImpl(-1, item);
    }

    public JmxTransSpecFluent.KafkaQueriesNested<A> setNewKafkaQueryLike(int index,JmxTransQueryTemplate item){
            return new KafkaQueriesNestedImpl(index, item);
    }

    public JmxTransSpecFluent.KafkaQueriesNested<A> editKafkaQuery(int index){
            if (kafkaQueries.size() <= index) throw new RuntimeException("Can't edit kafkaQueries. Index exceeds size.");
            return setNewKafkaQueryLike(index, buildKafkaQuery(index));
    }

    public JmxTransSpecFluent.KafkaQueriesNested<A> editFirstKafkaQuery(){
            if (kafkaQueries.size() == 0) throw new RuntimeException("Can't edit first kafkaQueries. The list is empty.");
            return setNewKafkaQueryLike(0, buildKafkaQuery(0));
    }

    public JmxTransSpecFluent.KafkaQueriesNested<A> editLastKafkaQuery(){
            int index = kafkaQueries.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last kafkaQueries. The list is empty.");
            return setNewKafkaQueryLike(index, buildKafkaQuery(index));
    }

    public JmxTransSpecFluent.KafkaQueriesNested<A> editMatchingKafkaQuery(io.fabric8.kubernetes.api.builder.Predicate<JmxTransQueryTemplateBuilder> predicate){
            int index = -1;
            for (int i=0;i<kafkaQueries.size();i++) { 
            if (predicate.apply(kafkaQueries.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching kafkaQueries. No match found.");
            return setNewKafkaQueryLike(index, buildKafkaQuery(index));
    }

    public ResourceRequirements getResources(){
            return this.resources;
    }

    public A withResources(ResourceRequirements resources){
            this.resources=resources; return (A) this;
    }

    public Boolean hasResources(){
            return this.resources != null;
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public JmxTransTemplate getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public JmxTransTemplate buildTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(JmxTransTemplate template){
            _visitables.get("template").remove(this.template);
            if (template!=null){ this.template= new JmxTransTemplateBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template != null;
    }

    public JmxTransSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public JmxTransSpecFluent.TemplateNested<A> withNewTemplateLike(JmxTransTemplate item){
            return new TemplateNestedImpl(item);
    }

    public JmxTransSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public JmxTransSpecFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new JmxTransTemplateBuilder().build());
    }

    public JmxTransSpecFluent.TemplateNested<A> editOrNewTemplateLike(JmxTransTemplate item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            JmxTransSpecFluentImpl that = (JmxTransSpecFluentImpl) o;
            if (image != null ? !image.equals(that.image) :that.image != null) return false;
            if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
            if (outputDefinitions != null ? !outputDefinitions.equals(that.outputDefinitions) :that.outputDefinitions != null) return false;
            if (kafkaQueries != null ? !kafkaQueries.equals(that.kafkaQueries) :that.kafkaQueries != null) return false;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            return true;
    }


    public class OutputDefinitionsNestedImpl<N> extends JmxTransOutputDefinitionTemplateFluentImpl<JmxTransSpecFluent.OutputDefinitionsNested<N>> implements JmxTransSpecFluent.OutputDefinitionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final JmxTransOutputDefinitionTemplateBuilder builder;
        private final int index;
    
            OutputDefinitionsNestedImpl(int index,JmxTransOutputDefinitionTemplate item){
                    this.index = index;
                    this.builder = new JmxTransOutputDefinitionTemplateBuilder(this, item);
            }
            OutputDefinitionsNestedImpl(){
                    this.index = -1;
                    this.builder = new JmxTransOutputDefinitionTemplateBuilder(this);
            }
    
    public N and(){
            return (N) JmxTransSpecFluentImpl.this.setToOutputDefinitions(index, builder.build());
    }
    public N endOutputDefinition(){
            return and();
    }

}
    public class KafkaQueriesNestedImpl<N> extends JmxTransQueryTemplateFluentImpl<JmxTransSpecFluent.KafkaQueriesNested<N>> implements JmxTransSpecFluent.KafkaQueriesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final JmxTransQueryTemplateBuilder builder;
        private final int index;
    
            KafkaQueriesNestedImpl(int index,JmxTransQueryTemplate item){
                    this.index = index;
                    this.builder = new JmxTransQueryTemplateBuilder(this, item);
            }
            KafkaQueriesNestedImpl(){
                    this.index = -1;
                    this.builder = new JmxTransQueryTemplateBuilder(this);
            }
    
    public N and(){
            return (N) JmxTransSpecFluentImpl.this.setToKafkaQueries(index, builder.build());
    }
    public N endKafkaQuery(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends JmxTransTemplateFluentImpl<JmxTransSpecFluent.TemplateNested<N>> implements JmxTransSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final JmxTransTemplateBuilder builder;
    
            TemplateNestedImpl(JmxTransTemplate item){
                    this.builder = new JmxTransTemplateBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new JmxTransTemplateBuilder(this);
            }
    
    public N and(){
            return (N) JmxTransSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}


}
