package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface JvmOptionsFluent<A extends JvmOptionsFluent<A>> extends Fluent<A>{


    public String getXmx();
    public A withXmx(String xmx);
    public Boolean hasXmx();
    public A withNewXmx(String arg1);
    public A withNewXmx(StringBuilder arg1);
    public A withNewXmx(StringBuffer arg1);
    public String getXms();
    public A withXms(String xms);
    public Boolean hasXms();
    public A withNewXms(String arg1);
    public A withNewXms(StringBuilder arg1);
    public A withNewXms(StringBuffer arg1);
    public boolean isGcLoggingEnabled();
    public A withGcLoggingEnabled(boolean gcLoggingEnabled);
    public Boolean hasGcLoggingEnabled();
    public A addToJavaSystemProperties(int index,SystemProperty item);
    public A setToJavaSystemProperties(int index,SystemProperty item);
    public A addToJavaSystemProperties(SystemProperty... items);
    public A addAllToJavaSystemProperties(Collection<SystemProperty> items);
    public A removeFromJavaSystemProperties(SystemProperty... items);
    public A removeAllFromJavaSystemProperties(Collection<SystemProperty> items);
    public A removeMatchingFromJavaSystemProperties(io.fabric8.kubernetes.api.builder.Predicate<SystemPropertyBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildJavaSystemProperties instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<SystemProperty> getJavaSystemProperties();
    public java.util.List<SystemProperty> buildJavaSystemProperties();
    public SystemProperty buildJavaSystemProperty(int index);
    public SystemProperty buildFirstJavaSystemProperty();
    public SystemProperty buildLastJavaSystemProperty();
    public SystemProperty buildMatchingJavaSystemProperty(io.fabric8.kubernetes.api.builder.Predicate<SystemPropertyBuilder> predicate);
    public Boolean hasMatchingJavaSystemProperty(io.fabric8.kubernetes.api.builder.Predicate<SystemPropertyBuilder> predicate);
    public A withJavaSystemProperties(java.util.List<SystemProperty> javaSystemProperties);
    public A withJavaSystemProperties(SystemProperty... javaSystemProperties);
    public Boolean hasJavaSystemProperties();
    public JvmOptionsFluent.JavaSystemPropertiesNested<A> addNewJavaSystemProperty();
    public JvmOptionsFluent.JavaSystemPropertiesNested<A> addNewJavaSystemPropertyLike(SystemProperty item);
    public JvmOptionsFluent.JavaSystemPropertiesNested<A> setNewJavaSystemPropertyLike(int index,SystemProperty item);
    public JvmOptionsFluent.JavaSystemPropertiesNested<A> editJavaSystemProperty(int index);
    public JvmOptionsFluent.JavaSystemPropertiesNested<A> editFirstJavaSystemProperty();
    public JvmOptionsFluent.JavaSystemPropertiesNested<A> editLastJavaSystemProperty();
    public JvmOptionsFluent.JavaSystemPropertiesNested<A> editMatchingJavaSystemProperty(io.fabric8.kubernetes.api.builder.Predicate<SystemPropertyBuilder> predicate);
    public A addToXx(String key,String value);
    public A addToXx(Map<String,String> map);
    public A removeFromXx(String key);
    public A removeFromXx(Map<String,String> map);
    public Map<String,String> getXx();
    public A withXx(Map<String,String> xx);
    public Boolean hasXx();

    public interface JavaSystemPropertiesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SystemPropertyFluent<JvmOptionsFluent.JavaSystemPropertiesNested<N>>{

        
    public N and();    public N endJavaSystemProperty();
}


}
