package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class JvmOptionsFluentImpl<A extends JvmOptionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements JvmOptionsFluent<A>{

    private String xmx;
    private String xms;
    private boolean gcLoggingEnabled;
    private java.util.List<SystemPropertyBuilder> javaSystemProperties;
    private Map<String,String> xx;

    public JvmOptionsFluentImpl(){
    }
    public JvmOptionsFluentImpl(JvmOptions instance){
            this.withXmx(instance.getXmx());

            this.withXms(instance.getXms());

            this.withGcLoggingEnabled(instance.isGcLoggingEnabled());

            this.withJavaSystemProperties(instance.getJavaSystemProperties());

            this.withXx(instance.getXx());

    }

    public String getXmx(){
            return this.xmx;
    }

    public A withXmx(String xmx){
            this.xmx=xmx; return (A) this;
    }

    public Boolean hasXmx(){
            return this.xmx != null;
    }

    public A withNewXmx(String arg1){
            return (A)withXmx(new String(arg1));
    }

    public A withNewXmx(StringBuilder arg1){
            return (A)withXmx(new String(arg1));
    }

    public A withNewXmx(StringBuffer arg1){
            return (A)withXmx(new String(arg1));
    }

    public String getXms(){
            return this.xms;
    }

    public A withXms(String xms){
            this.xms=xms; return (A) this;
    }

    public Boolean hasXms(){
            return this.xms != null;
    }

    public A withNewXms(String arg1){
            return (A)withXms(new String(arg1));
    }

    public A withNewXms(StringBuilder arg1){
            return (A)withXms(new String(arg1));
    }

    public A withNewXms(StringBuffer arg1){
            return (A)withXms(new String(arg1));
    }

    public boolean isGcLoggingEnabled(){
            return this.gcLoggingEnabled;
    }

    public A withGcLoggingEnabled(boolean gcLoggingEnabled){
            this.gcLoggingEnabled=gcLoggingEnabled; return (A) this;
    }

    public Boolean hasGcLoggingEnabled(){
            return true;
    }

    public A addToJavaSystemProperties(int index,SystemProperty item){
            if (this.javaSystemProperties == null) {this.javaSystemProperties = new ArrayList<SystemPropertyBuilder>();}
            SystemPropertyBuilder builder = new SystemPropertyBuilder(item);_visitables.get("javaSystemProperties").add(index >= 0 ? index : _visitables.get("javaSystemProperties").size(), builder);this.javaSystemProperties.add(index >= 0 ? index : javaSystemProperties.size(), builder); return (A)this;
    }

    public A setToJavaSystemProperties(int index,SystemProperty item){
            if (this.javaSystemProperties == null) {this.javaSystemProperties = new ArrayList<SystemPropertyBuilder>();}
            SystemPropertyBuilder builder = new SystemPropertyBuilder(item);
            if (index < 0 || index >= _visitables.get("javaSystemProperties").size()) { _visitables.get("javaSystemProperties").add(builder); } else { _visitables.get("javaSystemProperties").set(index, builder);}
            if (index < 0 || index >= javaSystemProperties.size()) { javaSystemProperties.add(builder); } else { javaSystemProperties.set(index, builder);}
             return (A)this;
    }

    public A addToJavaSystemProperties(SystemProperty... items){
            if (this.javaSystemProperties == null) {this.javaSystemProperties = new ArrayList<SystemPropertyBuilder>();}
            for (SystemProperty item : items) {SystemPropertyBuilder builder = new SystemPropertyBuilder(item);_visitables.get("javaSystemProperties").add(builder);this.javaSystemProperties.add(builder);} return (A)this;
    }

    public A addAllToJavaSystemProperties(Collection<SystemProperty> items){
            if (this.javaSystemProperties == null) {this.javaSystemProperties = new ArrayList<SystemPropertyBuilder>();}
            for (SystemProperty item : items) {SystemPropertyBuilder builder = new SystemPropertyBuilder(item);_visitables.get("javaSystemProperties").add(builder);this.javaSystemProperties.add(builder);} return (A)this;
    }

    public A removeFromJavaSystemProperties(SystemProperty... items){
            for (SystemProperty item : items) {SystemPropertyBuilder builder = new SystemPropertyBuilder(item);_visitables.get("javaSystemProperties").remove(builder);if (this.javaSystemProperties != null) {this.javaSystemProperties.remove(builder);}} return (A)this;
    }

    public A removeAllFromJavaSystemProperties(Collection<SystemProperty> items){
            for (SystemProperty item : items) {SystemPropertyBuilder builder = new SystemPropertyBuilder(item);_visitables.get("javaSystemProperties").remove(builder);if (this.javaSystemProperties != null) {this.javaSystemProperties.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromJavaSystemProperties(io.fabric8.kubernetes.api.builder.Predicate<SystemPropertyBuilder> predicate){
            if (javaSystemProperties == null) return (A) this;
            final Iterator<SystemPropertyBuilder> each = javaSystemProperties.iterator();
            final List visitables = _visitables.get("javaSystemProperties");
            while (each.hasNext()) {
              SystemPropertyBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildJavaSystemProperties instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<SystemProperty> getJavaSystemProperties(){
            return build(javaSystemProperties);
    }

    public java.util.List<SystemProperty> buildJavaSystemProperties(){
            return build(javaSystemProperties);
    }

    public SystemProperty buildJavaSystemProperty(int index){
            return this.javaSystemProperties.get(index).build();
    }

    public SystemProperty buildFirstJavaSystemProperty(){
            return this.javaSystemProperties.get(0).build();
    }

    public SystemProperty buildLastJavaSystemProperty(){
            return this.javaSystemProperties.get(javaSystemProperties.size() - 1).build();
    }

    public SystemProperty buildMatchingJavaSystemProperty(io.fabric8.kubernetes.api.builder.Predicate<SystemPropertyBuilder> predicate){
            for (SystemPropertyBuilder item: javaSystemProperties) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingJavaSystemProperty(io.fabric8.kubernetes.api.builder.Predicate<SystemPropertyBuilder> predicate){
            for (SystemPropertyBuilder item: javaSystemProperties) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withJavaSystemProperties(java.util.List<SystemProperty> javaSystemProperties){
            if (this.javaSystemProperties != null) { _visitables.get("javaSystemProperties").removeAll(this.javaSystemProperties);}
            if (javaSystemProperties != null) {this.javaSystemProperties = new ArrayList<SystemPropertyBuilder>(); for (SystemProperty item : javaSystemProperties){this.addToJavaSystemProperties(item);}} else { this.javaSystemProperties = null;} return (A) this;
    }

    public A withJavaSystemProperties(SystemProperty... javaSystemProperties){
            if (this.javaSystemProperties != null) {this.javaSystemProperties.clear();}
            if (javaSystemProperties != null) {for (SystemProperty item :javaSystemProperties){ this.addToJavaSystemProperties(item);}} return (A) this;
    }

    public Boolean hasJavaSystemProperties(){
            return javaSystemProperties != null && !javaSystemProperties.isEmpty();
    }

    public JvmOptionsFluent.JavaSystemPropertiesNested<A> addNewJavaSystemProperty(){
            return new JavaSystemPropertiesNestedImpl();
    }

    public JvmOptionsFluent.JavaSystemPropertiesNested<A> addNewJavaSystemPropertyLike(SystemProperty item){
            return new JavaSystemPropertiesNestedImpl(-1, item);
    }

    public JvmOptionsFluent.JavaSystemPropertiesNested<A> setNewJavaSystemPropertyLike(int index,SystemProperty item){
            return new JavaSystemPropertiesNestedImpl(index, item);
    }

    public JvmOptionsFluent.JavaSystemPropertiesNested<A> editJavaSystemProperty(int index){
            if (javaSystemProperties.size() <= index) throw new RuntimeException("Can't edit javaSystemProperties. Index exceeds size.");
            return setNewJavaSystemPropertyLike(index, buildJavaSystemProperty(index));
    }

    public JvmOptionsFluent.JavaSystemPropertiesNested<A> editFirstJavaSystemProperty(){
            if (javaSystemProperties.size() == 0) throw new RuntimeException("Can't edit first javaSystemProperties. The list is empty.");
            return setNewJavaSystemPropertyLike(0, buildJavaSystemProperty(0));
    }

    public JvmOptionsFluent.JavaSystemPropertiesNested<A> editLastJavaSystemProperty(){
            int index = javaSystemProperties.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last javaSystemProperties. The list is empty.");
            return setNewJavaSystemPropertyLike(index, buildJavaSystemProperty(index));
    }

    public JvmOptionsFluent.JavaSystemPropertiesNested<A> editMatchingJavaSystemProperty(io.fabric8.kubernetes.api.builder.Predicate<SystemPropertyBuilder> predicate){
            int index = -1;
            for (int i=0;i<javaSystemProperties.size();i++) { 
            if (predicate.apply(javaSystemProperties.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching javaSystemProperties. No match found.");
            return setNewJavaSystemPropertyLike(index, buildJavaSystemProperty(index));
    }

    public A addToXx(String key,String value){
            if(this.xx == null && key != null && value != null) { this.xx = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.xx.put(key, value);} return (A)this;
    }

    public A addToXx(Map<String,String> map){
            if(this.xx == null && map != null) { this.xx = new LinkedHashMap<String,String>(); }
            if(map != null) { this.xx.putAll(map);} return (A)this;
    }

    public A removeFromXx(String key){
            if(this.xx == null) { return (A) this; }
            if(key != null && this.xx != null) {this.xx.remove(key);} return (A)this;
    }

    public A removeFromXx(Map<String,String> map){
            if(this.xx == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.xx != null){this.xx.remove(key);}}} return (A)this;
    }

    public Map<String,String> getXx(){
            return this.xx;
    }

    public A withXx(Map<String,String> xx){
            if (xx == null) { this.xx =  null;} else {this.xx = new LinkedHashMap<String,String>(xx);} return (A) this;
    }

    public Boolean hasXx(){
            return this.xx != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            JvmOptionsFluentImpl that = (JvmOptionsFluentImpl) o;
            if (xmx != null ? !xmx.equals(that.xmx) :that.xmx != null) return false;
            if (xms != null ? !xms.equals(that.xms) :that.xms != null) return false;
            if (gcLoggingEnabled != that.gcLoggingEnabled) return false;
            if (javaSystemProperties != null ? !javaSystemProperties.equals(that.javaSystemProperties) :that.javaSystemProperties != null) return false;
            if (xx != null ? !xx.equals(that.xx) :that.xx != null) return false;
            return true;
    }


    public class JavaSystemPropertiesNestedImpl<N> extends SystemPropertyFluentImpl<JvmOptionsFluent.JavaSystemPropertiesNested<N>> implements JvmOptionsFluent.JavaSystemPropertiesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SystemPropertyBuilder builder;
        private final int index;
    
            JavaSystemPropertiesNestedImpl(int index,SystemProperty item){
                    this.index = index;
                    this.builder = new SystemPropertyBuilder(this, item);
            }
            JavaSystemPropertiesNestedImpl(){
                    this.index = -1;
                    this.builder = new SystemPropertyBuilder(this);
            }
    
    public N and(){
            return (N) JvmOptionsFluentImpl.this.setToJavaSystemProperties(index, builder.build());
    }
    public N endJavaSystemProperty(){
            return and();
    }

}


}
