package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaAuthorizationKeycloakBuilder extends KafkaAuthorizationKeycloakFluentImpl<KafkaAuthorizationKeycloakBuilder> implements VisitableBuilder<KafkaAuthorizationKeycloak,KafkaAuthorizationKeycloakBuilder>{

    KafkaAuthorizationKeycloakFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaAuthorizationKeycloakBuilder(){
            this(true);
    }
    public KafkaAuthorizationKeycloakBuilder(Boolean validationEnabled){
            this(new KafkaAuthorizationKeycloak(), validationEnabled);
    }
    public KafkaAuthorizationKeycloakBuilder(KafkaAuthorizationKeycloakFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaAuthorizationKeycloakBuilder(KafkaAuthorizationKeycloakFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaAuthorizationKeycloak(), validationEnabled);
    }
    public KafkaAuthorizationKeycloakBuilder(KafkaAuthorizationKeycloakFluent<?> fluent,KafkaAuthorizationKeycloak instance){
            this(fluent, instance, true);
    }
    public KafkaAuthorizationKeycloakBuilder(KafkaAuthorizationKeycloakFluent<?> fluent,KafkaAuthorizationKeycloak instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withClientId(instance.getClientId());

            fluent.withTokenEndpointUri(instance.getTokenEndpointUri());

            fluent.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());

            fluent.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());

            fluent.withDelegateToKafkaAcls(instance.isDelegateToKafkaAcls());

            fluent.withGrantsRefreshPeriodSeconds(instance.getGrantsRefreshPeriodSeconds());

            fluent.withGrantsRefreshPoolSize(instance.getGrantsRefreshPoolSize());

            fluent.withSuperUsers(instance.getSuperUsers());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaAuthorizationKeycloakBuilder(KafkaAuthorizationKeycloak instance){
            this(instance,true);
    }
    public KafkaAuthorizationKeycloakBuilder(KafkaAuthorizationKeycloak instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withClientId(instance.getClientId());

            this.withTokenEndpointUri(instance.getTokenEndpointUri());

            this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());

            this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());

            this.withDelegateToKafkaAcls(instance.isDelegateToKafkaAcls());

            this.withGrantsRefreshPeriodSeconds(instance.getGrantsRefreshPeriodSeconds());

            this.withGrantsRefreshPoolSize(instance.getGrantsRefreshPoolSize());

            this.withSuperUsers(instance.getSuperUsers());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaAuthorizationKeycloak build(){
            KafkaAuthorizationKeycloak buildable = new KafkaAuthorizationKeycloak();
            buildable.setClientId(fluent.getClientId());
            buildable.setTokenEndpointUri(fluent.getTokenEndpointUri());
            buildable.setTlsTrustedCertificates(fluent.getTlsTrustedCertificates());
            buildable.setDisableTlsHostnameVerification(fluent.isDisableTlsHostnameVerification());
            buildable.setDelegateToKafkaAcls(fluent.isDelegateToKafkaAcls());
            buildable.setGrantsRefreshPeriodSeconds(fluent.getGrantsRefreshPeriodSeconds());
            buildable.setGrantsRefreshPoolSize(fluent.getGrantsRefreshPoolSize());
            buildable.setSuperUsers(fluent.getSuperUsers());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaAuthorizationKeycloakBuilder that = (KafkaAuthorizationKeycloakBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
