package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface KafkaAuthorizationKeycloakFluent<A extends KafkaAuthorizationKeycloakFluent<A>> extends Fluent<A>{


    public String getClientId();
    public A withClientId(String clientId);
    public Boolean hasClientId();
    public A withNewClientId(String arg1);
    public A withNewClientId(StringBuilder arg1);
    public A withNewClientId(StringBuffer arg1);
    public String getTokenEndpointUri();
    public A withTokenEndpointUri(String tokenEndpointUri);
    public Boolean hasTokenEndpointUri();
    public A withNewTokenEndpointUri(String arg1);
    public A withNewTokenEndpointUri(StringBuilder arg1);
    public A withNewTokenEndpointUri(StringBuffer arg1);
    public A addToTlsTrustedCertificates(int index,CertSecretSource item);
    public A setToTlsTrustedCertificates(int index,CertSecretSource item);
    public A addToTlsTrustedCertificates(CertSecretSource... items);
    public A addAllToTlsTrustedCertificates(Collection<CertSecretSource> items);
    public A removeFromTlsTrustedCertificates(CertSecretSource... items);
    public A removeAllFromTlsTrustedCertificates(Collection<CertSecretSource> items);
    public A removeMatchingFromTlsTrustedCertificates(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTlsTrustedCertificates instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<CertSecretSource> getTlsTrustedCertificates();
    public java.util.List<CertSecretSource> buildTlsTrustedCertificates();
    public CertSecretSource buildTlsTrustedCertificate(int index);
    public CertSecretSource buildFirstTlsTrustedCertificate();
    public CertSecretSource buildLastTlsTrustedCertificate();
    public CertSecretSource buildMatchingTlsTrustedCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate);
    public Boolean hasMatchingTlsTrustedCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate);
    public A withTlsTrustedCertificates(java.util.List<CertSecretSource> tlsTrustedCertificates);
    public A withTlsTrustedCertificates(CertSecretSource... tlsTrustedCertificates);
    public Boolean hasTlsTrustedCertificates();
    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate();
    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(CertSecretSource item);
    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index,CertSecretSource item);
    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index);
    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate();
    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate();
    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate);
    public boolean isDisableTlsHostnameVerification();
    public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification);
    public Boolean hasDisableTlsHostnameVerification();
    public boolean isDelegateToKafkaAcls();
    public A withDelegateToKafkaAcls(boolean delegateToKafkaAcls);
    public Boolean hasDelegateToKafkaAcls();
    public Integer getGrantsRefreshPeriodSeconds();
    public A withGrantsRefreshPeriodSeconds(Integer grantsRefreshPeriodSeconds);
    public Boolean hasGrantsRefreshPeriodSeconds();
    public Integer getGrantsRefreshPoolSize();
    public A withGrantsRefreshPoolSize(Integer grantsRefreshPoolSize);
    public Boolean hasGrantsRefreshPoolSize();
    public A addToSuperUsers(int index,String item);
    public A setToSuperUsers(int index,String item);
    public A addToSuperUsers(String... items);
    public A addAllToSuperUsers(Collection<String> items);
    public A removeFromSuperUsers(String... items);
    public A removeAllFromSuperUsers(Collection<String> items);
    public java.util.List<String> getSuperUsers();
    public String getSuperUser(int index);
    public String getFirstSuperUser();
    public String getLastSuperUser();
    public String getMatchingSuperUser(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingSuperUser(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withSuperUsers(java.util.List<String> superUsers);
    public A withSuperUsers(String... superUsers);
    public Boolean hasSuperUsers();
    public A addNewSuperUser(String arg1);
    public A addNewSuperUser(StringBuilder arg1);
    public A addNewSuperUser(StringBuffer arg1);

    public interface TlsTrustedCertificatesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CertSecretSourceFluent<KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<N>>{

        
    public N and();    public N endTlsTrustedCertificate();
}


}
