package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class KafkaAuthorizationKeycloakFluentImpl<A extends KafkaAuthorizationKeycloakFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaAuthorizationKeycloakFluent<A>{

    private String clientId;
    private String tokenEndpointUri;
    private java.util.List<CertSecretSourceBuilder> tlsTrustedCertificates;
    private boolean disableTlsHostnameVerification;
    private boolean delegateToKafkaAcls;
    private Integer grantsRefreshPeriodSeconds;
    private Integer grantsRefreshPoolSize;
    private java.util.List<String> superUsers;

    public KafkaAuthorizationKeycloakFluentImpl(){
    }
    public KafkaAuthorizationKeycloakFluentImpl(KafkaAuthorizationKeycloak instance){
            this.withClientId(instance.getClientId());

            this.withTokenEndpointUri(instance.getTokenEndpointUri());

            this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());

            this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());

            this.withDelegateToKafkaAcls(instance.isDelegateToKafkaAcls());

            this.withGrantsRefreshPeriodSeconds(instance.getGrantsRefreshPeriodSeconds());

            this.withGrantsRefreshPoolSize(instance.getGrantsRefreshPoolSize());

            this.withSuperUsers(instance.getSuperUsers());

    }

    public String getClientId(){
            return this.clientId;
    }

    public A withClientId(String clientId){
            this.clientId=clientId; return (A) this;
    }

    public Boolean hasClientId(){
            return this.clientId != null;
    }

    public A withNewClientId(String arg1){
            return (A)withClientId(new String(arg1));
    }

    public A withNewClientId(StringBuilder arg1){
            return (A)withClientId(new String(arg1));
    }

    public A withNewClientId(StringBuffer arg1){
            return (A)withClientId(new String(arg1));
    }

    public String getTokenEndpointUri(){
            return this.tokenEndpointUri;
    }

    public A withTokenEndpointUri(String tokenEndpointUri){
            this.tokenEndpointUri=tokenEndpointUri; return (A) this;
    }

    public Boolean hasTokenEndpointUri(){
            return this.tokenEndpointUri != null;
    }

    public A withNewTokenEndpointUri(String arg1){
            return (A)withTokenEndpointUri(new String(arg1));
    }

    public A withNewTokenEndpointUri(StringBuilder arg1){
            return (A)withTokenEndpointUri(new String(arg1));
    }

    public A withNewTokenEndpointUri(StringBuffer arg1){
            return (A)withTokenEndpointUri(new String(arg1));
    }

    public A addToTlsTrustedCertificates(int index,CertSecretSource item){
            if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(index >= 0 ? index : _visitables.get("tlsTrustedCertificates").size(), builder);this.tlsTrustedCertificates.add(index >= 0 ? index : tlsTrustedCertificates.size(), builder); return (A)this;
    }

    public A setToTlsTrustedCertificates(int index,CertSecretSource item){
            if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            if (index < 0 || index >= _visitables.get("tlsTrustedCertificates").size()) { _visitables.get("tlsTrustedCertificates").add(builder); } else { _visitables.get("tlsTrustedCertificates").set(index, builder);}
            if (index < 0 || index >= tlsTrustedCertificates.size()) { tlsTrustedCertificates.add(builder); } else { tlsTrustedCertificates.set(index, builder);}
             return (A)this;
    }

    public A addToTlsTrustedCertificates(CertSecretSource... items){
            if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
            for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
    }

    public A addAllToTlsTrustedCertificates(Collection<CertSecretSource> items){
            if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
            for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
    }

    public A removeFromTlsTrustedCertificates(CertSecretSource... items){
            for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder);if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.remove(builder);}} return (A)this;
    }

    public A removeAllFromTlsTrustedCertificates(Collection<CertSecretSource> items){
            for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder);if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTlsTrustedCertificates(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate){
            if (tlsTrustedCertificates == null) return (A) this;
            final Iterator<CertSecretSourceBuilder> each = tlsTrustedCertificates.iterator();
            final List visitables = _visitables.get("tlsTrustedCertificates");
            while (each.hasNext()) {
              CertSecretSourceBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTlsTrustedCertificates instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<CertSecretSource> getTlsTrustedCertificates(){
            return build(tlsTrustedCertificates);
    }

    public java.util.List<CertSecretSource> buildTlsTrustedCertificates(){
            return build(tlsTrustedCertificates);
    }

    public CertSecretSource buildTlsTrustedCertificate(int index){
            return this.tlsTrustedCertificates.get(index).build();
    }

    public CertSecretSource buildFirstTlsTrustedCertificate(){
            return this.tlsTrustedCertificates.get(0).build();
    }

    public CertSecretSource buildLastTlsTrustedCertificate(){
            return this.tlsTrustedCertificates.get(tlsTrustedCertificates.size() - 1).build();
    }

    public CertSecretSource buildMatchingTlsTrustedCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate){
            for (CertSecretSourceBuilder item: tlsTrustedCertificates) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTlsTrustedCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate){
            for (CertSecretSourceBuilder item: tlsTrustedCertificates) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTlsTrustedCertificates(java.util.List<CertSecretSource> tlsTrustedCertificates){
            if (this.tlsTrustedCertificates != null) { _visitables.get("tlsTrustedCertificates").removeAll(this.tlsTrustedCertificates);}
            if (tlsTrustedCertificates != null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>(); for (CertSecretSource item : tlsTrustedCertificates){this.addToTlsTrustedCertificates(item);}} else { this.tlsTrustedCertificates = null;} return (A) this;
    }

    public A withTlsTrustedCertificates(CertSecretSource... tlsTrustedCertificates){
            if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.clear();}
            if (tlsTrustedCertificates != null) {for (CertSecretSource item :tlsTrustedCertificates){ this.addToTlsTrustedCertificates(item);}} return (A) this;
    }

    public Boolean hasTlsTrustedCertificates(){
            return tlsTrustedCertificates != null && !tlsTrustedCertificates.isEmpty();
    }

    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate(){
            return new TlsTrustedCertificatesNestedImpl();
    }

    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(CertSecretSource item){
            return new TlsTrustedCertificatesNestedImpl(-1, item);
    }

    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index,CertSecretSource item){
            return new TlsTrustedCertificatesNestedImpl(index, item);
    }

    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index){
            if (tlsTrustedCertificates.size() <= index) throw new RuntimeException("Can't edit tlsTrustedCertificates. Index exceeds size.");
            return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate(){
            if (tlsTrustedCertificates.size() == 0) throw new RuntimeException("Can't edit first tlsTrustedCertificates. The list is empty.");
            return setNewTlsTrustedCertificateLike(0, buildTlsTrustedCertificate(0));
    }

    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate(){
            int index = tlsTrustedCertificates.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last tlsTrustedCertificates. The list is empty.");
            return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate){
            int index = -1;
            for (int i=0;i<tlsTrustedCertificates.size();i++) { 
            if (predicate.apply(tlsTrustedCertificates.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching tlsTrustedCertificates. No match found.");
            return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public boolean isDisableTlsHostnameVerification(){
            return this.disableTlsHostnameVerification;
    }

    public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification){
            this.disableTlsHostnameVerification=disableTlsHostnameVerification; return (A) this;
    }

    public Boolean hasDisableTlsHostnameVerification(){
            return true;
    }

    public boolean isDelegateToKafkaAcls(){
            return this.delegateToKafkaAcls;
    }

    public A withDelegateToKafkaAcls(boolean delegateToKafkaAcls){
            this.delegateToKafkaAcls=delegateToKafkaAcls; return (A) this;
    }

    public Boolean hasDelegateToKafkaAcls(){
            return true;
    }

    public Integer getGrantsRefreshPeriodSeconds(){
            return this.grantsRefreshPeriodSeconds;
    }

    public A withGrantsRefreshPeriodSeconds(Integer grantsRefreshPeriodSeconds){
            this.grantsRefreshPeriodSeconds=grantsRefreshPeriodSeconds; return (A) this;
    }

    public Boolean hasGrantsRefreshPeriodSeconds(){
            return this.grantsRefreshPeriodSeconds != null;
    }

    public Integer getGrantsRefreshPoolSize(){
            return this.grantsRefreshPoolSize;
    }

    public A withGrantsRefreshPoolSize(Integer grantsRefreshPoolSize){
            this.grantsRefreshPoolSize=grantsRefreshPoolSize; return (A) this;
    }

    public Boolean hasGrantsRefreshPoolSize(){
            return this.grantsRefreshPoolSize != null;
    }

    public A addToSuperUsers(int index,String item){
            if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
            this.superUsers.add(index, item);
            return (A)this;
    }

    public A setToSuperUsers(int index,String item){
            if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
            this.superUsers.set(index, item); return (A)this;
    }

    public A addToSuperUsers(String... items){
            if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
            for (String item : items) {this.superUsers.add(item);} return (A)this;
    }

    public A addAllToSuperUsers(Collection<String> items){
            if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
            for (String item : items) {this.superUsers.add(item);} return (A)this;
    }

    public A removeFromSuperUsers(String... items){
            for (String item : items) {if (this.superUsers!= null){ this.superUsers.remove(item);}} return (A)this;
    }

    public A removeAllFromSuperUsers(Collection<String> items){
            for (String item : items) {if (this.superUsers!= null){ this.superUsers.remove(item);}} return (A)this;
    }

    public java.util.List<String> getSuperUsers(){
            return this.superUsers;
    }

    public String getSuperUser(int index){
            return this.superUsers.get(index);
    }

    public String getFirstSuperUser(){
            return this.superUsers.get(0);
    }

    public String getLastSuperUser(){
            return this.superUsers.get(superUsers.size() - 1);
    }

    public String getMatchingSuperUser(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: superUsers) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingSuperUser(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: superUsers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withSuperUsers(java.util.List<String> superUsers){
            if (this.superUsers != null) { _visitables.get("superUsers").removeAll(this.superUsers);}
            if (superUsers != null) {this.superUsers = new ArrayList<String>(); for (String item : superUsers){this.addToSuperUsers(item);}} else { this.superUsers = null;} return (A) this;
    }

    public A withSuperUsers(String... superUsers){
            if (this.superUsers != null) {this.superUsers.clear();}
            if (superUsers != null) {for (String item :superUsers){ this.addToSuperUsers(item);}} return (A) this;
    }

    public Boolean hasSuperUsers(){
            return superUsers != null && !superUsers.isEmpty();
    }

    public A addNewSuperUser(String arg1){
            return (A)addToSuperUsers(new String(arg1));
    }

    public A addNewSuperUser(StringBuilder arg1){
            return (A)addToSuperUsers(new String(arg1));
    }

    public A addNewSuperUser(StringBuffer arg1){
            return (A)addToSuperUsers(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KafkaAuthorizationKeycloakFluentImpl that = (KafkaAuthorizationKeycloakFluentImpl) o;
            if (clientId != null ? !clientId.equals(that.clientId) :that.clientId != null) return false;
            if (tokenEndpointUri != null ? !tokenEndpointUri.equals(that.tokenEndpointUri) :that.tokenEndpointUri != null) return false;
            if (tlsTrustedCertificates != null ? !tlsTrustedCertificates.equals(that.tlsTrustedCertificates) :that.tlsTrustedCertificates != null) return false;
            if (disableTlsHostnameVerification != that.disableTlsHostnameVerification) return false;
            if (delegateToKafkaAcls != that.delegateToKafkaAcls) return false;
            if (grantsRefreshPeriodSeconds != null ? !grantsRefreshPeriodSeconds.equals(that.grantsRefreshPeriodSeconds) :that.grantsRefreshPeriodSeconds != null) return false;
            if (grantsRefreshPoolSize != null ? !grantsRefreshPoolSize.equals(that.grantsRefreshPoolSize) :that.grantsRefreshPoolSize != null) return false;
            if (superUsers != null ? !superUsers.equals(that.superUsers) :that.superUsers != null) return false;
            return true;
    }


    public class TlsTrustedCertificatesNestedImpl<N> extends CertSecretSourceFluentImpl<KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<N>> implements KafkaAuthorizationKeycloakFluent.TlsTrustedCertificatesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CertSecretSourceBuilder builder;
        private final int index;
    
            TlsTrustedCertificatesNestedImpl(int index,CertSecretSource item){
                    this.index = index;
                    this.builder = new CertSecretSourceBuilder(this, item);
            }
            TlsTrustedCertificatesNestedImpl(){
                    this.index = -1;
                    this.builder = new CertSecretSourceBuilder(this);
            }
    
    public N and(){
            return (N) KafkaAuthorizationKeycloakFluentImpl.this.setToTlsTrustedCertificates(index, builder.build());
    }
    public N endTlsTrustedCertificate(){
            return and();
    }

}


}
