package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaAuthorizationSimpleBuilder extends KafkaAuthorizationSimpleFluentImpl<KafkaAuthorizationSimpleBuilder> implements VisitableBuilder<KafkaAuthorizationSimple,KafkaAuthorizationSimpleBuilder>{

    KafkaAuthorizationSimpleFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaAuthorizationSimpleBuilder(){
            this(true);
    }
    public KafkaAuthorizationSimpleBuilder(Boolean validationEnabled){
            this(new KafkaAuthorizationSimple(), validationEnabled);
    }
    public KafkaAuthorizationSimpleBuilder(KafkaAuthorizationSimpleFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaAuthorizationSimpleBuilder(KafkaAuthorizationSimpleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaAuthorizationSimple(), validationEnabled);
    }
    public KafkaAuthorizationSimpleBuilder(KafkaAuthorizationSimpleFluent<?> fluent,KafkaAuthorizationSimple instance){
            this(fluent, instance, true);
    }
    public KafkaAuthorizationSimpleBuilder(KafkaAuthorizationSimpleFluent<?> fluent,KafkaAuthorizationSimple instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSuperUsers(instance.getSuperUsers());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaAuthorizationSimpleBuilder(KafkaAuthorizationSimple instance){
            this(instance,true);
    }
    public KafkaAuthorizationSimpleBuilder(KafkaAuthorizationSimple instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSuperUsers(instance.getSuperUsers());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaAuthorizationSimple build(){
            KafkaAuthorizationSimple buildable = new KafkaAuthorizationSimple();
            buildable.setSuperUsers(fluent.getSuperUsers());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaAuthorizationSimpleBuilder that = (KafkaAuthorizationSimpleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
