package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.status.KafkaBridgeStatusFluentImpl;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.strimzi.api.kafka.model.status.KafkaBridgeStatus;
import java.lang.StringBuffer;
import io.strimzi.api.kafka.model.status.KafkaBridgeStatusBuilder;
import java.lang.Object;

public class KafkaBridgeFluentImpl<A extends KafkaBridgeFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaBridgeFluent<A>{

    private String apiVersion;
    private ObjectMetaBuilder metadata;
    private KafkaBridgeSpecBuilder spec;
    private KafkaBridgeStatusBuilder status;

    public KafkaBridgeFluentImpl(){
    }
    public KafkaBridgeFluentImpl(KafkaBridge instance){
            this.withApiVersion(instance.getApiVersion());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public KafkaBridgeFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public KafkaBridgeFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public KafkaBridgeFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public KafkaBridgeFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public KafkaBridgeFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public KafkaBridgeSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public KafkaBridgeSpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(KafkaBridgeSpec spec){
            _visitables.get("spec").remove(this.spec);
            if (spec!=null){ this.spec= new KafkaBridgeSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public KafkaBridgeFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public KafkaBridgeFluent.SpecNested<A> withNewSpecLike(KafkaBridgeSpec item){
            return new SpecNestedImpl(item);
    }

    public KafkaBridgeFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public KafkaBridgeFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new KafkaBridgeSpecBuilder().build());
    }

    public KafkaBridgeFluent.SpecNested<A> editOrNewSpecLike(KafkaBridgeSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public KafkaBridgeStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public KafkaBridgeStatus buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(KafkaBridgeStatus status){
            _visitables.get("status").remove(this.status);
            if (status!=null){ this.status= new KafkaBridgeStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public KafkaBridgeFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public KafkaBridgeFluent.StatusNested<A> withNewStatusLike(KafkaBridgeStatus item){
            return new StatusNestedImpl(item);
    }

    public KafkaBridgeFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public KafkaBridgeFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new KafkaBridgeStatusBuilder().build());
    }

    public KafkaBridgeFluent.StatusNested<A> editOrNewStatusLike(KafkaBridgeStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KafkaBridgeFluentImpl that = (KafkaBridgeFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<KafkaBridgeFluent.MetadataNested<N>> implements KafkaBridgeFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends KafkaBridgeSpecFluentImpl<KafkaBridgeFluent.SpecNested<N>> implements KafkaBridgeFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaBridgeSpecBuilder builder;
    
            SpecNestedImpl(KafkaBridgeSpec item){
                    this.builder = new KafkaBridgeSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new KafkaBridgeSpecBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends KafkaBridgeStatusFluentImpl<KafkaBridgeFluent.StatusNested<N>> implements KafkaBridgeFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaBridgeStatusBuilder builder;
    
            StatusNestedImpl(KafkaBridgeStatus item){
                    this.builder = new KafkaBridgeStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new KafkaBridgeStatusBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
