package io.strimzi.api.kafka.model;

import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class KafkaBridgeHttpCorsFluentImpl<A extends KafkaBridgeHttpCorsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaBridgeHttpCorsFluent<A>{

    private java.util.List<String> allowedOrigins;
    private java.util.List<String> allowedMethods;

    public KafkaBridgeHttpCorsFluentImpl(){
    }
    public KafkaBridgeHttpCorsFluentImpl(KafkaBridgeHttpCors instance){
            this.withAllowedOrigins(instance.getAllowedOrigins());

            this.withAllowedMethods(instance.getAllowedMethods());

    }

    public A addToAllowedOrigins(int index,String item){
            if (this.allowedOrigins == null) {this.allowedOrigins = new ArrayList<String>();}
            this.allowedOrigins.add(index, item);
            return (A)this;
    }

    public A setToAllowedOrigins(int index,String item){
            if (this.allowedOrigins == null) {this.allowedOrigins = new ArrayList<String>();}
            this.allowedOrigins.set(index, item); return (A)this;
    }

    public A addToAllowedOrigins(String... items){
            if (this.allowedOrigins == null) {this.allowedOrigins = new ArrayList<String>();}
            for (String item : items) {this.allowedOrigins.add(item);} return (A)this;
    }

    public A addAllToAllowedOrigins(Collection<String> items){
            if (this.allowedOrigins == null) {this.allowedOrigins = new ArrayList<String>();}
            for (String item : items) {this.allowedOrigins.add(item);} return (A)this;
    }

    public A removeFromAllowedOrigins(String... items){
            for (String item : items) {if (this.allowedOrigins!= null){ this.allowedOrigins.remove(item);}} return (A)this;
    }

    public A removeAllFromAllowedOrigins(Collection<String> items){
            for (String item : items) {if (this.allowedOrigins!= null){ this.allowedOrigins.remove(item);}} return (A)this;
    }

    public java.util.List<String> getAllowedOrigins(){
            return this.allowedOrigins;
    }

    public String getAllowedOrigin(int index){
            return this.allowedOrigins.get(index);
    }

    public String getFirstAllowedOrigin(){
            return this.allowedOrigins.get(0);
    }

    public String getLastAllowedOrigin(){
            return this.allowedOrigins.get(allowedOrigins.size() - 1);
    }

    public String getMatchingAllowedOrigin(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: allowedOrigins) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAllowedOrigin(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: allowedOrigins) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAllowedOrigins(java.util.List<String> allowedOrigins){
            if (this.allowedOrigins != null) { _visitables.get("allowedOrigins").removeAll(this.allowedOrigins);}
            if (allowedOrigins != null) {this.allowedOrigins = new ArrayList<String>(); for (String item : allowedOrigins){this.addToAllowedOrigins(item);}} else { this.allowedOrigins = null;} return (A) this;
    }

    public A withAllowedOrigins(String... allowedOrigins){
            if (this.allowedOrigins != null) {this.allowedOrigins.clear();}
            if (allowedOrigins != null) {for (String item :allowedOrigins){ this.addToAllowedOrigins(item);}} return (A) this;
    }

    public Boolean hasAllowedOrigins(){
            return allowedOrigins != null && !allowedOrigins.isEmpty();
    }

    public A addNewAllowedOrigin(String arg1){
            return (A)addToAllowedOrigins(new String(arg1));
    }

    public A addNewAllowedOrigin(StringBuilder arg1){
            return (A)addToAllowedOrigins(new String(arg1));
    }

    public A addNewAllowedOrigin(StringBuffer arg1){
            return (A)addToAllowedOrigins(new String(arg1));
    }

    public A addToAllowedMethods(int index,String item){
            if (this.allowedMethods == null) {this.allowedMethods = new ArrayList<String>();}
            this.allowedMethods.add(index, item);
            return (A)this;
    }

    public A setToAllowedMethods(int index,String item){
            if (this.allowedMethods == null) {this.allowedMethods = new ArrayList<String>();}
            this.allowedMethods.set(index, item); return (A)this;
    }

    public A addToAllowedMethods(String... items){
            if (this.allowedMethods == null) {this.allowedMethods = new ArrayList<String>();}
            for (String item : items) {this.allowedMethods.add(item);} return (A)this;
    }

    public A addAllToAllowedMethods(Collection<String> items){
            if (this.allowedMethods == null) {this.allowedMethods = new ArrayList<String>();}
            for (String item : items) {this.allowedMethods.add(item);} return (A)this;
    }

    public A removeFromAllowedMethods(String... items){
            for (String item : items) {if (this.allowedMethods!= null){ this.allowedMethods.remove(item);}} return (A)this;
    }

    public A removeAllFromAllowedMethods(Collection<String> items){
            for (String item : items) {if (this.allowedMethods!= null){ this.allowedMethods.remove(item);}} return (A)this;
    }

    public java.util.List<String> getAllowedMethods(){
            return this.allowedMethods;
    }

    public String getAllowedMethod(int index){
            return this.allowedMethods.get(index);
    }

    public String getFirstAllowedMethod(){
            return this.allowedMethods.get(0);
    }

    public String getLastAllowedMethod(){
            return this.allowedMethods.get(allowedMethods.size() - 1);
    }

    public String getMatchingAllowedMethod(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: allowedMethods) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAllowedMethod(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: allowedMethods) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAllowedMethods(java.util.List<String> allowedMethods){
            if (this.allowedMethods != null) { _visitables.get("allowedMethods").removeAll(this.allowedMethods);}
            if (allowedMethods != null) {this.allowedMethods = new ArrayList<String>(); for (String item : allowedMethods){this.addToAllowedMethods(item);}} else { this.allowedMethods = null;} return (A) this;
    }

    public A withAllowedMethods(String... allowedMethods){
            if (this.allowedMethods != null) {this.allowedMethods.clear();}
            if (allowedMethods != null) {for (String item :allowedMethods){ this.addToAllowedMethods(item);}} return (A) this;
    }

    public Boolean hasAllowedMethods(){
            return allowedMethods != null && !allowedMethods.isEmpty();
    }

    public A addNewAllowedMethod(String arg1){
            return (A)addToAllowedMethods(new String(arg1));
    }

    public A addNewAllowedMethod(StringBuilder arg1){
            return (A)addToAllowedMethods(new String(arg1));
    }

    public A addNewAllowedMethod(StringBuffer arg1){
            return (A)addToAllowedMethods(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KafkaBridgeHttpCorsFluentImpl that = (KafkaBridgeHttpCorsFluentImpl) o;
            if (allowedOrigins != null ? !allowedOrigins.equals(that.allowedOrigins) :that.allowedOrigins != null) return false;
            if (allowedMethods != null ? !allowedMethods.equals(that.allowedMethods) :that.allowedMethods != null) return false;
            return true;
    }




}
