package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaBridgeTlsBuilder extends KafkaBridgeTlsFluentImpl<KafkaBridgeTlsBuilder> implements VisitableBuilder<KafkaBridgeTls,KafkaBridgeTlsBuilder>{

    KafkaBridgeTlsFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaBridgeTlsBuilder(){
            this(true);
    }
    public KafkaBridgeTlsBuilder(Boolean validationEnabled){
            this(new KafkaBridgeTls(), validationEnabled);
    }
    public KafkaBridgeTlsBuilder(KafkaBridgeTlsFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaBridgeTlsBuilder(KafkaBridgeTlsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaBridgeTls(), validationEnabled);
    }
    public KafkaBridgeTlsBuilder(KafkaBridgeTlsFluent<?> fluent,KafkaBridgeTls instance){
            this(fluent, instance, true);
    }
    public KafkaBridgeTlsBuilder(KafkaBridgeTlsFluent<?> fluent,KafkaBridgeTls instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withTrustedCertificates(instance.getTrustedCertificates());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaBridgeTlsBuilder(KafkaBridgeTls instance){
            this(instance,true);
    }
    public KafkaBridgeTlsBuilder(KafkaBridgeTls instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withTrustedCertificates(instance.getTrustedCertificates());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaBridgeTls build(){
            KafkaBridgeTls buildable = new KafkaBridgeTls();
            buildable.setTrustedCertificates(fluent.getTrustedCertificates());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaBridgeTlsBuilder that = (KafkaBridgeTlsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
