package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaBuilder extends KafkaFluentImpl<KafkaBuilder> implements VisitableBuilder<Kafka,KafkaBuilder>{

    KafkaFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaBuilder(){
            this(true);
    }
    public KafkaBuilder(Boolean validationEnabled){
            this(new Kafka(), validationEnabled);
    }
    public KafkaBuilder(KafkaFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaBuilder(KafkaFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Kafka(), validationEnabled);
    }
    public KafkaBuilder(KafkaFluent<?> fluent,Kafka instance){
            this(fluent, instance, true);
    }
    public KafkaBuilder(KafkaFluent<?> fluent,Kafka instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaBuilder(Kafka instance){
            this(instance,true);
    }
    public KafkaBuilder(Kafka instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public Kafka build(){
            Kafka buildable = new Kafka();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaBuilder that = (KafkaBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
