package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.template.KafkaClusterTemplateBuilder;
import java.util.ArrayList;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorage;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluentImpl;
import io.strimzi.api.kafka.model.storage.JbodStorage;
import io.strimzi.api.kafka.model.storage.JbodStorageBuilder;
import java.lang.Deprecated;
import com.fasterxml.jackson.core.JsonGenerator;
import io.strimzi.api.kafka.model.listener.arraylistener.ArrayOrObjectKafkaListenersBuilder;
import io.strimzi.api.kafka.model.listener.arraylistener.ArrayOrObjectKafkaListenersFluentImpl;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.storage.EphemeralStorageFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import io.strimzi.api.kafka.model.template.KafkaClusterTemplate;
import java.util.List;
import java.lang.Override;
import io.strimzi.api.kafka.model.listener.arraylistener.ArrayOrObjectKafkaListeners;
import io.strimzi.api.kafka.model.storage.Storage;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder;
import io.strimzi.api.kafka.model.storage.EphemeralStorage;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.core.JsonParser;
import io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl;
import io.strimzi.api.kafka.model.storage.JbodStorageFluentImpl;

public class KafkaClusterSpecFluentImpl<A extends KafkaClusterSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaClusterSpecFluent<A>{

    private VisitableBuilder<? extends Storage,?> storage;
    private String version;
    private Map<String,Object> config;
    private String brokerRackInitImage;
    private RackBuilder rack;
    private VisitableBuilder<? extends Logging,?> logging;
    private TlsSidecarBuilder tlsSidecar;
    private int replicas;
    private String image;
    private ResourceRequirements resources;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private JvmOptionsBuilder jvmOptions;
    private KafkaJmxOptionsBuilder jmxOptions;
    private VisitableBuilder<? extends MetricsConfig,?> metricsConfig;
    private Map<String,Object> metrics;
    private Affinity affinity;
    private java.util.List<Toleration> tolerations;
    private ArrayOrObjectKafkaListenersBuilder listeners;
    private VisitableBuilder<? extends KafkaAuthorization,?> authorization;
    private KafkaClusterTemplateBuilder template;

    public KafkaClusterSpecFluentImpl(){
    }
    public KafkaClusterSpecFluentImpl(KafkaClusterSpec instance){
            this.withStorage(instance.getStorage());

            this.withVersion(instance.getVersion());

            this.withConfig(instance.getConfig());

            this.withBrokerRackInitImage(instance.getBrokerRackInitImage());

            this.withRack(instance.getRack());

            this.withLogging(instance.getLogging());

            this.withTlsSidecar(instance.getTlsSidecar());

            this.withReplicas(instance.getReplicas());

            this.withImage(instance.getImage());

            this.withResources(instance.getResources());

            this.withLivenessProbe(instance.getLivenessProbe());

            this.withReadinessProbe(instance.getReadinessProbe());

            this.withJvmOptions(instance.getJvmOptions());

            this.withJmxOptions(instance.getJmxOptions());

            this.withMetricsConfig(instance.getMetricsConfig());

            this.withMetrics(instance.getMetrics());

            this.withAffinity(instance.getAffinity());

            this.withTolerations(instance.getTolerations());

            this.withListeners(instance.getListeners());

            this.withAuthorization(instance.getAuthorization());

            this.withTemplate(instance.getTemplate());

    }

    
/**
 * This method has been deprecated, please use method buildStorage instead.
 * @return The buildable object.
 */
@Deprecated public Storage getStorage(){
            return this.storage!=null?this.storage.build():null;
    }

    public Storage buildStorage(){
            return this.storage!=null?this.storage.build():null;
    }

    public A withStorage(Storage storage){
            if (storage instanceof PersistentClaimStorage){ this.storage= new PersistentClaimStorageBuilder((PersistentClaimStorage)storage); _visitables.get("storage").add(this.storage);}
            if (storage instanceof EphemeralStorage){ this.storage= new EphemeralStorageBuilder((EphemeralStorage)storage); _visitables.get("storage").add(this.storage);}
            if (storage instanceof JbodStorage){ this.storage= new JbodStorageBuilder((JbodStorage)storage); _visitables.get("storage").add(this.storage);}
            return (A) this;
    }

    public Boolean hasStorage(){
            return this.storage != null;
    }

    public A withPersistentClaimStorage(PersistentClaimStorage persistentClaimStorage){
            _visitables.get("storage").remove(this.storage);
            if (persistentClaimStorage!=null){ this.storage= new PersistentClaimStorageBuilder(persistentClaimStorage); _visitables.get("storage").add(this.storage);} return (A) this;
    }

    public KafkaClusterSpecFluent.PersistentClaimStorageNested<A> withNewPersistentClaimStorage(){
            return new PersistentClaimStorageNestedImpl();
    }

    public KafkaClusterSpecFluent.PersistentClaimStorageNested<A> withNewPersistentClaimStorageLike(PersistentClaimStorage item){
            return new PersistentClaimStorageNestedImpl(item);
    }

    public A withEphemeralStorage(EphemeralStorage ephemeralStorage){
            _visitables.get("storage").remove(this.storage);
            if (ephemeralStorage!=null){ this.storage= new EphemeralStorageBuilder(ephemeralStorage); _visitables.get("storage").add(this.storage);} return (A) this;
    }

    public KafkaClusterSpecFluent.EphemeralStorageNested<A> withNewEphemeralStorage(){
            return new EphemeralStorageNestedImpl();
    }

    public KafkaClusterSpecFluent.EphemeralStorageNested<A> withNewEphemeralStorageLike(EphemeralStorage item){
            return new EphemeralStorageNestedImpl(item);
    }

    public A withJbodStorage(JbodStorage jbodStorage){
            _visitables.get("storage").remove(this.storage);
            if (jbodStorage!=null){ this.storage= new JbodStorageBuilder(jbodStorage); _visitables.get("storage").add(this.storage);} return (A) this;
    }

    public KafkaClusterSpecFluent.JbodStorageNested<A> withNewJbodStorage(){
            return new JbodStorageNestedImpl();
    }

    public KafkaClusterSpecFluent.JbodStorageNested<A> withNewJbodStorageLike(JbodStorage item){
            return new JbodStorageNestedImpl(item);
    }

    public String getVersion(){
            return this.version;
    }

    public A withVersion(String version){
            this.version=version; return (A) this;
    }

    public Boolean hasVersion(){
            return this.version != null;
    }

    public A withNewVersion(String arg1){
            return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuilder arg1){
            return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1){
            return (A)withVersion(new String(arg1));
    }

    public A addToConfig(String key,Object value){
            if(this.config == null && key != null && value != null) { this.config = new LinkedHashMap<String,Object>(); }
            if(key != null && value != null) {this.config.put(key, value);} return (A)this;
    }

    public A addToConfig(Map<String,Object> map){
            if(this.config == null && map != null) { this.config = new LinkedHashMap<String,Object>(); }
            if(map != null) { this.config.putAll(map);} return (A)this;
    }

    public A removeFromConfig(String key){
            if(this.config == null) { return (A) this; }
            if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
    }

    public A removeFromConfig(Map<String,Object> map){
            if(this.config == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getConfig(){
            return this.config;
    }

    public A withConfig(Map<String,Object> config){
            if (config == null) { this.config =  null;} else {this.config = new LinkedHashMap<String,Object>(config);} return (A) this;
    }

    public Boolean hasConfig(){
            return this.config != null;
    }

    public String getBrokerRackInitImage(){
            return this.brokerRackInitImage;
    }

    public A withBrokerRackInitImage(String brokerRackInitImage){
            this.brokerRackInitImage=brokerRackInitImage; return (A) this;
    }

    public Boolean hasBrokerRackInitImage(){
            return this.brokerRackInitImage != null;
    }

    public A withNewBrokerRackInitImage(String arg1){
            return (A)withBrokerRackInitImage(new String(arg1));
    }

    public A withNewBrokerRackInitImage(StringBuilder arg1){
            return (A)withBrokerRackInitImage(new String(arg1));
    }

    public A withNewBrokerRackInitImage(StringBuffer arg1){
            return (A)withBrokerRackInitImage(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildRack instead.
 * @return The buildable object.
 */
@Deprecated public Rack getRack(){
            return this.rack!=null?this.rack.build():null;
    }

    public Rack buildRack(){
            return this.rack!=null?this.rack.build():null;
    }

    public A withRack(Rack rack){
            _visitables.get("rack").remove(this.rack);
            if (rack!=null){ this.rack= new RackBuilder(rack); _visitables.get("rack").add(this.rack);} return (A) this;
    }

    public Boolean hasRack(){
            return this.rack != null;
    }

    public A withNewRack(String topologyKey){
            return (A)withRack(new Rack(topologyKey));
    }

    public KafkaClusterSpecFluent.RackNested<A> withNewRack(){
            return new RackNestedImpl();
    }

    public KafkaClusterSpecFluent.RackNested<A> withNewRackLike(Rack item){
            return new RackNestedImpl(item);
    }

    public KafkaClusterSpecFluent.RackNested<A> editRack(){
            return withNewRackLike(getRack());
    }

    public KafkaClusterSpecFluent.RackNested<A> editOrNewRack(){
            return withNewRackLike(getRack() != null ? getRack(): new RackBuilder().build());
    }

    public KafkaClusterSpecFluent.RackNested<A> editOrNewRackLike(Rack item){
            return withNewRackLike(getRack() != null ? getRack(): item);
    }

    
/**
 * This method has been deprecated, please use method buildLogging instead.
 * @return The buildable object.
 */
@Deprecated public Logging getLogging(){
            return this.logging!=null?this.logging.build():null;
    }

    public Logging buildLogging(){
            return this.logging!=null?this.logging.build():null;
    }

    public A withLogging(Logging logging){
            if (logging instanceof ExternalLogging){ this.logging= new ExternalLoggingBuilder((ExternalLogging)logging); _visitables.get("logging").add(this.logging);}
            if (logging instanceof InlineLogging){ this.logging= new InlineLoggingBuilder((InlineLogging)logging); _visitables.get("logging").add(this.logging);}
            return (A) this;
    }

    public Boolean hasLogging(){
            return this.logging != null;
    }

    public A withExternalLogging(ExternalLogging externalLogging){
            _visitables.get("logging").remove(this.logging);
            if (externalLogging!=null){ this.logging= new ExternalLoggingBuilder(externalLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public KafkaClusterSpecFluent.ExternalLoggingNested<A> withNewExternalLogging(){
            return new ExternalLoggingNestedImpl();
    }

    public KafkaClusterSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item){
            return new ExternalLoggingNestedImpl(item);
    }

    public A withInlineLogging(InlineLogging inlineLogging){
            _visitables.get("logging").remove(this.logging);
            if (inlineLogging!=null){ this.logging= new InlineLoggingBuilder(inlineLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public KafkaClusterSpecFluent.InlineLoggingNested<A> withNewInlineLogging(){
            return new InlineLoggingNestedImpl();
    }

    public KafkaClusterSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item){
            return new InlineLoggingNestedImpl(item);
    }

    
/**
 * This method has been deprecated, please use method buildTlsSidecar instead.
 * @return The buildable object.
 */
@Deprecated public TlsSidecar getTlsSidecar(){
            return this.tlsSidecar!=null?this.tlsSidecar.build():null;
    }

    public TlsSidecar buildTlsSidecar(){
            return this.tlsSidecar!=null?this.tlsSidecar.build():null;
    }

    public A withTlsSidecar(TlsSidecar tlsSidecar){
            _visitables.get("tlsSidecar").remove(this.tlsSidecar);
            if (tlsSidecar!=null){ this.tlsSidecar= new TlsSidecarBuilder(tlsSidecar); _visitables.get("tlsSidecar").add(this.tlsSidecar);} return (A) this;
    }

    public Boolean hasTlsSidecar(){
            return this.tlsSidecar != null;
    }

    public KafkaClusterSpecFluent.TlsSidecarNested<A> withNewTlsSidecar(){
            return new TlsSidecarNestedImpl();
    }

    public KafkaClusterSpecFluent.TlsSidecarNested<A> withNewTlsSidecarLike(TlsSidecar item){
            return new TlsSidecarNestedImpl(item);
    }

    public KafkaClusterSpecFluent.TlsSidecarNested<A> editTlsSidecar(){
            return withNewTlsSidecarLike(getTlsSidecar());
    }

    public KafkaClusterSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecar(){
            return withNewTlsSidecarLike(getTlsSidecar() != null ? getTlsSidecar(): new TlsSidecarBuilder().build());
    }

    public KafkaClusterSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecarLike(TlsSidecar item){
            return withNewTlsSidecarLike(getTlsSidecar() != null ? getTlsSidecar(): item);
    }

    public int getReplicas(){
            return this.replicas;
    }

    public A withReplicas(int replicas){
            this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas(){
            return true;
    }

    public String getImage(){
            return this.image;
    }

    public A withImage(String image){
            this.image=image; return (A) this;
    }

    public Boolean hasImage(){
            return this.image != null;
    }

    public A withNewImage(String arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuilder arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1){
            return (A)withImage(new String(arg1));
    }

    public ResourceRequirements getResources(){
            return this.resources;
    }

    public A withResources(ResourceRequirements resources){
            this.resources=resources; return (A) this;
    }

    public Boolean hasResources(){
            return this.resources != null;
    }

    
/**
 * This method has been deprecated, please use method buildLivenessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getLivenessProbe(){
            return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public Probe buildLivenessProbe(){
            return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public A withLivenessProbe(Probe livenessProbe){
            _visitables.get("livenessProbe").remove(this.livenessProbe);
            if (livenessProbe!=null){ this.livenessProbe= new ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} return (A) this;
    }

    public Boolean hasLivenessProbe(){
            return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds){
            return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public KafkaClusterSpecFluent.LivenessProbeNested<A> withNewLivenessProbe(){
            return new LivenessProbeNestedImpl();
    }

    public KafkaClusterSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item){
            return new LivenessProbeNestedImpl(item);
    }

    public KafkaClusterSpecFluent.LivenessProbeNested<A> editLivenessProbe(){
            return withNewLivenessProbeLike(getLivenessProbe());
    }

    public KafkaClusterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe(){
            return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): new ProbeBuilder().build());
    }

    public KafkaClusterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item){
            return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): item);
    }

    
/**
 * This method has been deprecated, please use method buildReadinessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getReadinessProbe(){
            return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public Probe buildReadinessProbe(){
            return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public A withReadinessProbe(Probe readinessProbe){
            _visitables.get("readinessProbe").remove(this.readinessProbe);
            if (readinessProbe!=null){ this.readinessProbe= new ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} return (A) this;
    }

    public Boolean hasReadinessProbe(){
            return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds){
            return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public KafkaClusterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe(){
            return new ReadinessProbeNestedImpl();
    }

    public KafkaClusterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item){
            return new ReadinessProbeNestedImpl(item);
    }

    public KafkaClusterSpecFluent.ReadinessProbeNested<A> editReadinessProbe(){
            return withNewReadinessProbeLike(getReadinessProbe());
    }

    public KafkaClusterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe(){
            return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): new ProbeBuilder().build());
    }

    public KafkaClusterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item){
            return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): item);
    }

    
/**
 * This method has been deprecated, please use method buildJvmOptions instead.
 * @return The buildable object.
 */
@Deprecated public JvmOptions getJvmOptions(){
            return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public JvmOptions buildJvmOptions(){
            return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public A withJvmOptions(JvmOptions jvmOptions){
            _visitables.get("jvmOptions").remove(this.jvmOptions);
            if (jvmOptions!=null){ this.jvmOptions= new JvmOptionsBuilder(jvmOptions); _visitables.get("jvmOptions").add(this.jvmOptions);} return (A) this;
    }

    public Boolean hasJvmOptions(){
            return this.jvmOptions != null;
    }

    public KafkaClusterSpecFluent.JvmOptionsNested<A> withNewJvmOptions(){
            return new JvmOptionsNestedImpl();
    }

    public KafkaClusterSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item){
            return new JvmOptionsNestedImpl(item);
    }

    public KafkaClusterSpecFluent.JvmOptionsNested<A> editJvmOptions(){
            return withNewJvmOptionsLike(getJvmOptions());
    }

    public KafkaClusterSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions(){
            return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): new JvmOptionsBuilder().build());
    }

    public KafkaClusterSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item){
            return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): item);
    }

    
/**
 * This method has been deprecated, please use method buildJmxOptions instead.
 * @return The buildable object.
 */
@Deprecated public KafkaJmxOptions getJmxOptions(){
            return this.jmxOptions!=null?this.jmxOptions.build():null;
    }

    public KafkaJmxOptions buildJmxOptions(){
            return this.jmxOptions!=null?this.jmxOptions.build():null;
    }

    public A withJmxOptions(KafkaJmxOptions jmxOptions){
            _visitables.get("jmxOptions").remove(this.jmxOptions);
            if (jmxOptions!=null){ this.jmxOptions= new KafkaJmxOptionsBuilder(jmxOptions); _visitables.get("jmxOptions").add(this.jmxOptions);} return (A) this;
    }

    public Boolean hasJmxOptions(){
            return this.jmxOptions != null;
    }

    public KafkaClusterSpecFluent.JmxOptionsNested<A> withNewJmxOptions(){
            return new JmxOptionsNestedImpl();
    }

    public KafkaClusterSpecFluent.JmxOptionsNested<A> withNewJmxOptionsLike(KafkaJmxOptions item){
            return new JmxOptionsNestedImpl(item);
    }

    public KafkaClusterSpecFluent.JmxOptionsNested<A> editJmxOptions(){
            return withNewJmxOptionsLike(getJmxOptions());
    }

    public KafkaClusterSpecFluent.JmxOptionsNested<A> editOrNewJmxOptions(){
            return withNewJmxOptionsLike(getJmxOptions() != null ? getJmxOptions(): new KafkaJmxOptionsBuilder().build());
    }

    public KafkaClusterSpecFluent.JmxOptionsNested<A> editOrNewJmxOptionsLike(KafkaJmxOptions item){
            return withNewJmxOptionsLike(getJmxOptions() != null ? getJmxOptions(): item);
    }

    
/**
 * This method has been deprecated, please use method buildMetricsConfig instead.
 * @return The buildable object.
 */
@Deprecated public MetricsConfig getMetricsConfig(){
            return this.metricsConfig!=null?this.metricsConfig.build():null;
    }

    public MetricsConfig buildMetricsConfig(){
            return this.metricsConfig!=null?this.metricsConfig.build():null;
    }

    public A withMetricsConfig(MetricsConfig metricsConfig){
            if (metricsConfig instanceof JmxPrometheusExporterMetrics){ this.metricsConfig= new JmxPrometheusExporterMetricsBuilder((JmxPrometheusExporterMetrics)metricsConfig); _visitables.get("metricsConfig").add(this.metricsConfig);}
            return (A) this;
    }

    public Boolean hasMetricsConfig(){
            return this.metricsConfig != null;
    }

    public A withJmxPrometheusExporterMetricsConfig(JmxPrometheusExporterMetrics jmxPrometheusExporterMetricsConfig){
            _visitables.get("metricsConfig").remove(this.metricsConfig);
            if (jmxPrometheusExporterMetricsConfig!=null){ this.metricsConfig= new JmxPrometheusExporterMetricsBuilder(jmxPrometheusExporterMetricsConfig); _visitables.get("metricsConfig").add(this.metricsConfig);} return (A) this;
    }

    public KafkaClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig(){
            return new JmxPrometheusExporterMetricsConfigNestedImpl();
    }

    public KafkaClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(JmxPrometheusExporterMetrics item){
            return new JmxPrometheusExporterMetricsConfigNestedImpl(item);
    }

    public A addToMetrics(String key,Object value){
            if(this.metrics == null && key != null && value != null) { this.metrics = new LinkedHashMap<String,Object>(); }
            if(key != null && value != null) {this.metrics.put(key, value);} return (A)this;
    }

    public A addToMetrics(Map<String,Object> map){
            if(this.metrics == null && map != null) { this.metrics = new LinkedHashMap<String,Object>(); }
            if(map != null) { this.metrics.putAll(map);} return (A)this;
    }

    public A removeFromMetrics(String key){
            if(this.metrics == null) { return (A) this; }
            if(key != null && this.metrics != null) {this.metrics.remove(key);} return (A)this;
    }

    public A removeFromMetrics(Map<String,Object> map){
            if(this.metrics == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.metrics != null){this.metrics.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getMetrics(){
            return this.metrics;
    }

    public A withMetrics(Map<String,Object> metrics){
            if (metrics == null) { this.metrics =  null;} else {this.metrics = new LinkedHashMap<String,Object>(metrics);} return (A) this;
    }

    public Boolean hasMetrics(){
            return this.metrics != null;
    }

    public Affinity getAffinity(){
            return this.affinity;
    }

    public A withAffinity(Affinity affinity){
            this.affinity=affinity; return (A) this;
    }

    public Boolean hasAffinity(){
            return this.affinity != null;
    }

    public A addToTolerations(int index,Toleration item){
            if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
            this.tolerations.add(index, item);
            return (A)this;
    }

    public A setToTolerations(int index,Toleration item){
            if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
            this.tolerations.set(index, item); return (A)this;
    }

    public A addToTolerations(Toleration... items){
            if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
            for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A addAllToTolerations(Collection<Toleration> items){
            if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
            for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A removeFromTolerations(Toleration... items){
            for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public A removeAllFromTolerations(Collection<Toleration> items){
            for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public java.util.List<Toleration> getTolerations(){
            return this.tolerations;
    }

    public Toleration getToleration(int index){
            return this.tolerations.get(index);
    }

    public Toleration getFirstToleration(){
            return this.tolerations.get(0);
    }

    public Toleration getLastToleration(){
            return this.tolerations.get(tolerations.size() - 1);
    }

    public Toleration getMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate){
            for (Toleration item: tolerations) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate){
            for (Toleration item: tolerations) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTolerations(java.util.List<Toleration> tolerations){
            if (this.tolerations != null) { _visitables.get("tolerations").removeAll(this.tolerations);}
            if (tolerations != null) {this.tolerations = new ArrayList<Toleration>(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
    }

    public A withTolerations(Toleration... tolerations){
            if (this.tolerations != null) {this.tolerations.clear();}
            if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
    }

    public Boolean hasTolerations(){
            return tolerations != null && !tolerations.isEmpty();
    }

    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value){
            return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    
/**
 * This method has been deprecated, please use method buildListeners instead.
 * @return The buildable object.
 */
@Deprecated public ArrayOrObjectKafkaListeners getListeners(){
            return this.listeners!=null?this.listeners.build():null;
    }

    public ArrayOrObjectKafkaListeners buildListeners(){
            return this.listeners!=null?this.listeners.build():null;
    }

    public A withListeners(ArrayOrObjectKafkaListeners listeners){
            _visitables.get("listeners").remove(this.listeners);
            if (listeners!=null){ this.listeners= new ArrayOrObjectKafkaListenersBuilder(listeners); _visitables.get("listeners").add(this.listeners);} return (A) this;
    }

    public Boolean hasListeners(){
            return this.listeners != null;
    }

    public KafkaClusterSpecFluent.ListenersNested<A> withNewListeners(){
            return new ListenersNestedImpl();
    }

    public KafkaClusterSpecFluent.ListenersNested<A> withNewListenersLike(ArrayOrObjectKafkaListeners item){
            return new ListenersNestedImpl(item);
    }

    public KafkaClusterSpecFluent.ListenersNested<A> editListeners(){
            return withNewListenersLike(getListeners());
    }

    public KafkaClusterSpecFluent.ListenersNested<A> editOrNewListeners(){
            return withNewListenersLike(getListeners() != null ? getListeners(): new ArrayOrObjectKafkaListenersBuilder().build());
    }

    public KafkaClusterSpecFluent.ListenersNested<A> editOrNewListenersLike(ArrayOrObjectKafkaListeners item){
            return withNewListenersLike(getListeners() != null ? getListeners(): item);
    }

    
/**
 * This method has been deprecated, please use method buildAuthorization instead.
 * @return The buildable object.
 */
@Deprecated public KafkaAuthorization getAuthorization(){
            return this.authorization!=null?this.authorization.build():null;
    }

    public KafkaAuthorization buildAuthorization(){
            return this.authorization!=null?this.authorization.build():null;
    }

    public A withAuthorization(KafkaAuthorization authorization){
            if (authorization instanceof KafkaAuthorizationOpa){ this.authorization= new KafkaAuthorizationOpaBuilder((KafkaAuthorizationOpa)authorization); _visitables.get("authorization").add(this.authorization);}
            if (authorization instanceof KafkaAuthorizationKeycloak){ this.authorization= new KafkaAuthorizationKeycloakBuilder((KafkaAuthorizationKeycloak)authorization); _visitables.get("authorization").add(this.authorization);}
            if (authorization instanceof KafkaAuthorizationSimple){ this.authorization= new KafkaAuthorizationSimpleBuilder((KafkaAuthorizationSimple)authorization); _visitables.get("authorization").add(this.authorization);}
            return (A) this;
    }

    public Boolean hasAuthorization(){
            return this.authorization != null;
    }

    public A withKafkaAuthorizationOpa(KafkaAuthorizationOpa kafkaAuthorizationOpa){
            _visitables.get("authorization").remove(this.authorization);
            if (kafkaAuthorizationOpa!=null){ this.authorization= new KafkaAuthorizationOpaBuilder(kafkaAuthorizationOpa); _visitables.get("authorization").add(this.authorization);} return (A) this;
    }

    public KafkaClusterSpecFluent.KafkaAuthorizationOpaNested<A> withNewKafkaAuthorizationOpa(){
            return new KafkaAuthorizationOpaNestedImpl();
    }

    public KafkaClusterSpecFluent.KafkaAuthorizationOpaNested<A> withNewKafkaAuthorizationOpaLike(KafkaAuthorizationOpa item){
            return new KafkaAuthorizationOpaNestedImpl(item);
    }

    public A withKafkaAuthorizationKeycloak(KafkaAuthorizationKeycloak kafkaAuthorizationKeycloak){
            _visitables.get("authorization").remove(this.authorization);
            if (kafkaAuthorizationKeycloak!=null){ this.authorization= new KafkaAuthorizationKeycloakBuilder(kafkaAuthorizationKeycloak); _visitables.get("authorization").add(this.authorization);} return (A) this;
    }

    public KafkaClusterSpecFluent.KafkaAuthorizationKeycloakNested<A> withNewKafkaAuthorizationKeycloak(){
            return new KafkaAuthorizationKeycloakNestedImpl();
    }

    public KafkaClusterSpecFluent.KafkaAuthorizationKeycloakNested<A> withNewKafkaAuthorizationKeycloakLike(KafkaAuthorizationKeycloak item){
            return new KafkaAuthorizationKeycloakNestedImpl(item);
    }

    public A withKafkaAuthorizationSimple(KafkaAuthorizationSimple kafkaAuthorizationSimple){
            _visitables.get("authorization").remove(this.authorization);
            if (kafkaAuthorizationSimple!=null){ this.authorization= new KafkaAuthorizationSimpleBuilder(kafkaAuthorizationSimple); _visitables.get("authorization").add(this.authorization);} return (A) this;
    }

    public KafkaClusterSpecFluent.KafkaAuthorizationSimpleNested<A> withNewKafkaAuthorizationSimple(){
            return new KafkaAuthorizationSimpleNestedImpl();
    }

    public KafkaClusterSpecFluent.KafkaAuthorizationSimpleNested<A> withNewKafkaAuthorizationSimpleLike(KafkaAuthorizationSimple item){
            return new KafkaAuthorizationSimpleNestedImpl(item);
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public KafkaClusterTemplate getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public KafkaClusterTemplate buildTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(KafkaClusterTemplate template){
            _visitables.get("template").remove(this.template);
            if (template!=null){ this.template= new KafkaClusterTemplateBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template != null;
    }

    public KafkaClusterSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public KafkaClusterSpecFluent.TemplateNested<A> withNewTemplateLike(KafkaClusterTemplate item){
            return new TemplateNestedImpl(item);
    }

    public KafkaClusterSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public KafkaClusterSpecFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new KafkaClusterTemplateBuilder().build());
    }

    public KafkaClusterSpecFluent.TemplateNested<A> editOrNewTemplateLike(KafkaClusterTemplate item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KafkaClusterSpecFluentImpl that = (KafkaClusterSpecFluentImpl) o;
            if (storage != null ? !storage.equals(that.storage) :that.storage != null) return false;
            if (version != null ? !version.equals(that.version) :that.version != null) return false;
            if (config != null ? !config.equals(that.config) :that.config != null) return false;
            if (brokerRackInitImage != null ? !brokerRackInitImage.equals(that.brokerRackInitImage) :that.brokerRackInitImage != null) return false;
            if (rack != null ? !rack.equals(that.rack) :that.rack != null) return false;
            if (logging != null ? !logging.equals(that.logging) :that.logging != null) return false;
            if (tlsSidecar != null ? !tlsSidecar.equals(that.tlsSidecar) :that.tlsSidecar != null) return false;
            if (replicas != that.replicas) return false;
            if (image != null ? !image.equals(that.image) :that.image != null) return false;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            if (livenessProbe != null ? !livenessProbe.equals(that.livenessProbe) :that.livenessProbe != null) return false;
            if (readinessProbe != null ? !readinessProbe.equals(that.readinessProbe) :that.readinessProbe != null) return false;
            if (jvmOptions != null ? !jvmOptions.equals(that.jvmOptions) :that.jvmOptions != null) return false;
            if (jmxOptions != null ? !jmxOptions.equals(that.jmxOptions) :that.jmxOptions != null) return false;
            if (metricsConfig != null ? !metricsConfig.equals(that.metricsConfig) :that.metricsConfig != null) return false;
            if (metrics != null ? !metrics.equals(that.metrics) :that.metrics != null) return false;
            if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
            if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
            if (listeners != null ? !listeners.equals(that.listeners) :that.listeners != null) return false;
            if (authorization != null ? !authorization.equals(that.authorization) :that.authorization != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            return true;
    }


    public class PersistentClaimStorageNestedImpl<N> extends PersistentClaimStorageFluentImpl<KafkaClusterSpecFluent.PersistentClaimStorageNested<N>> implements KafkaClusterSpecFluent.PersistentClaimStorageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PersistentClaimStorageBuilder builder;
    
            PersistentClaimStorageNestedImpl(PersistentClaimStorage item){
                    this.builder = new PersistentClaimStorageBuilder(this, item);
            }
            PersistentClaimStorageNestedImpl(){
                    this.builder = new PersistentClaimStorageBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClusterSpecFluentImpl.this.withPersistentClaimStorage(builder.build());
    }
    public N endPersistentClaimStorage(){
            return and();
    }

}
    public class EphemeralStorageNestedImpl<N> extends EphemeralStorageFluentImpl<KafkaClusterSpecFluent.EphemeralStorageNested<N>> implements KafkaClusterSpecFluent.EphemeralStorageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EphemeralStorageBuilder builder;
    
            EphemeralStorageNestedImpl(EphemeralStorage item){
                    this.builder = new EphemeralStorageBuilder(this, item);
            }
            EphemeralStorageNestedImpl(){
                    this.builder = new EphemeralStorageBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClusterSpecFluentImpl.this.withEphemeralStorage(builder.build());
    }
    public N endEphemeralStorage(){
            return and();
    }

}
    public class JbodStorageNestedImpl<N> extends JbodStorageFluentImpl<KafkaClusterSpecFluent.JbodStorageNested<N>> implements KafkaClusterSpecFluent.JbodStorageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final JbodStorageBuilder builder;
    
            JbodStorageNestedImpl(JbodStorage item){
                    this.builder = new JbodStorageBuilder(this, item);
            }
            JbodStorageNestedImpl(){
                    this.builder = new JbodStorageBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClusterSpecFluentImpl.this.withJbodStorage(builder.build());
    }
    public N endJbodStorage(){
            return and();
    }

}
    public class RackNestedImpl<N> extends RackFluentImpl<KafkaClusterSpecFluent.RackNested<N>> implements KafkaClusterSpecFluent.RackNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RackBuilder builder;
    
            RackNestedImpl(Rack item){
                    this.builder = new RackBuilder(this, item);
            }
            RackNestedImpl(){
                    this.builder = new RackBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClusterSpecFluentImpl.this.withRack(builder.build());
    }
    public N endRack(){
            return and();
    }

}
    public class ExternalLoggingNestedImpl<N> extends ExternalLoggingFluentImpl<KafkaClusterSpecFluent.ExternalLoggingNested<N>> implements KafkaClusterSpecFluent.ExternalLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ExternalLoggingBuilder builder;
    
            ExternalLoggingNestedImpl(ExternalLogging item){
                    this.builder = new ExternalLoggingBuilder(this, item);
            }
            ExternalLoggingNestedImpl(){
                    this.builder = new ExternalLoggingBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClusterSpecFluentImpl.this.withExternalLogging(builder.build());
    }
    public N endExternalLogging(){
            return and();
    }

}
    public class InlineLoggingNestedImpl<N> extends InlineLoggingFluentImpl<KafkaClusterSpecFluent.InlineLoggingNested<N>> implements KafkaClusterSpecFluent.InlineLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final InlineLoggingBuilder builder;
    
            InlineLoggingNestedImpl(InlineLogging item){
                    this.builder = new InlineLoggingBuilder(this, item);
            }
            InlineLoggingNestedImpl(){
                    this.builder = new InlineLoggingBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClusterSpecFluentImpl.this.withInlineLogging(builder.build());
    }
    public N endInlineLogging(){
            return and();
    }

}
    public class TlsSidecarNestedImpl<N> extends TlsSidecarFluentImpl<KafkaClusterSpecFluent.TlsSidecarNested<N>> implements KafkaClusterSpecFluent.TlsSidecarNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TlsSidecarBuilder builder;
    
            TlsSidecarNestedImpl(TlsSidecar item){
                    this.builder = new TlsSidecarBuilder(this, item);
            }
            TlsSidecarNestedImpl(){
                    this.builder = new TlsSidecarBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClusterSpecFluentImpl.this.withTlsSidecar(builder.build());
    }
    public N endTlsSidecar(){
            return and();
    }

}
    public class LivenessProbeNestedImpl<N> extends ProbeFluentImpl<KafkaClusterSpecFluent.LivenessProbeNested<N>> implements KafkaClusterSpecFluent.LivenessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProbeBuilder builder;
    
            LivenessProbeNestedImpl(Probe item){
                    this.builder = new ProbeBuilder(this, item);
            }
            LivenessProbeNestedImpl(){
                    this.builder = new ProbeBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClusterSpecFluentImpl.this.withLivenessProbe(builder.build());
    }
    public N endLivenessProbe(){
            return and();
    }

}
    public class ReadinessProbeNestedImpl<N> extends ProbeFluentImpl<KafkaClusterSpecFluent.ReadinessProbeNested<N>> implements KafkaClusterSpecFluent.ReadinessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProbeBuilder builder;
    
            ReadinessProbeNestedImpl(Probe item){
                    this.builder = new ProbeBuilder(this, item);
            }
            ReadinessProbeNestedImpl(){
                    this.builder = new ProbeBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClusterSpecFluentImpl.this.withReadinessProbe(builder.build());
    }
    public N endReadinessProbe(){
            return and();
    }

}
    public class JvmOptionsNestedImpl<N> extends JvmOptionsFluentImpl<KafkaClusterSpecFluent.JvmOptionsNested<N>> implements KafkaClusterSpecFluent.JvmOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final JvmOptionsBuilder builder;
    
            JvmOptionsNestedImpl(JvmOptions item){
                    this.builder = new JvmOptionsBuilder(this, item);
            }
            JvmOptionsNestedImpl(){
                    this.builder = new JvmOptionsBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClusterSpecFluentImpl.this.withJvmOptions(builder.build());
    }
    public N endJvmOptions(){
            return and();
    }

}
    public class JmxOptionsNestedImpl<N> extends KafkaJmxOptionsFluentImpl<KafkaClusterSpecFluent.JmxOptionsNested<N>> implements KafkaClusterSpecFluent.JmxOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaJmxOptionsBuilder builder;
    
            JmxOptionsNestedImpl(KafkaJmxOptions item){
                    this.builder = new KafkaJmxOptionsBuilder(this, item);
            }
            JmxOptionsNestedImpl(){
                    this.builder = new KafkaJmxOptionsBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClusterSpecFluentImpl.this.withJmxOptions(builder.build());
    }
    public N endJmxOptions(){
            return and();
    }

}
    public class JmxPrometheusExporterMetricsConfigNestedImpl<N> extends JmxPrometheusExporterMetricsFluentImpl<KafkaClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>> implements KafkaClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final JmxPrometheusExporterMetricsBuilder builder;
    
            JmxPrometheusExporterMetricsConfigNestedImpl(JmxPrometheusExporterMetrics item){
                    this.builder = new JmxPrometheusExporterMetricsBuilder(this, item);
            }
            JmxPrometheusExporterMetricsConfigNestedImpl(){
                    this.builder = new JmxPrometheusExporterMetricsBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClusterSpecFluentImpl.this.withJmxPrometheusExporterMetricsConfig(builder.build());
    }
    public N endJmxPrometheusExporterMetricsConfig(){
            return and();
    }

}
    public class ListenersNestedImpl<N> extends ArrayOrObjectKafkaListenersFluentImpl<KafkaClusterSpecFluent.ListenersNested<N>> implements KafkaClusterSpecFluent.ListenersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ArrayOrObjectKafkaListenersBuilder builder;
    
            ListenersNestedImpl(ArrayOrObjectKafkaListeners item){
                    this.builder = new ArrayOrObjectKafkaListenersBuilder(this, item);
            }
            ListenersNestedImpl(){
                    this.builder = new ArrayOrObjectKafkaListenersBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClusterSpecFluentImpl.this.withListeners(builder.build());
    }
    public N endListeners(){
            return and();
    }

}
    public class KafkaAuthorizationOpaNestedImpl<N> extends KafkaAuthorizationOpaFluentImpl<KafkaClusterSpecFluent.KafkaAuthorizationOpaNested<N>> implements KafkaClusterSpecFluent.KafkaAuthorizationOpaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaAuthorizationOpaBuilder builder;
    
            KafkaAuthorizationOpaNestedImpl(KafkaAuthorizationOpa item){
                    this.builder = new KafkaAuthorizationOpaBuilder(this, item);
            }
            KafkaAuthorizationOpaNestedImpl(){
                    this.builder = new KafkaAuthorizationOpaBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClusterSpecFluentImpl.this.withKafkaAuthorizationOpa(builder.build());
    }
    public N endKafkaAuthorizationOpa(){
            return and();
    }

}
    public class KafkaAuthorizationKeycloakNestedImpl<N> extends KafkaAuthorizationKeycloakFluentImpl<KafkaClusterSpecFluent.KafkaAuthorizationKeycloakNested<N>> implements KafkaClusterSpecFluent.KafkaAuthorizationKeycloakNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaAuthorizationKeycloakBuilder builder;
    
            KafkaAuthorizationKeycloakNestedImpl(KafkaAuthorizationKeycloak item){
                    this.builder = new KafkaAuthorizationKeycloakBuilder(this, item);
            }
            KafkaAuthorizationKeycloakNestedImpl(){
                    this.builder = new KafkaAuthorizationKeycloakBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClusterSpecFluentImpl.this.withKafkaAuthorizationKeycloak(builder.build());
    }
    public N endKafkaAuthorizationKeycloak(){
            return and();
    }

}
    public class KafkaAuthorizationSimpleNestedImpl<N> extends KafkaAuthorizationSimpleFluentImpl<KafkaClusterSpecFluent.KafkaAuthorizationSimpleNested<N>> implements KafkaClusterSpecFluent.KafkaAuthorizationSimpleNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaAuthorizationSimpleBuilder builder;
    
            KafkaAuthorizationSimpleNestedImpl(KafkaAuthorizationSimple item){
                    this.builder = new KafkaAuthorizationSimpleBuilder(this, item);
            }
            KafkaAuthorizationSimpleNestedImpl(){
                    this.builder = new KafkaAuthorizationSimpleBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClusterSpecFluentImpl.this.withKafkaAuthorizationSimple(builder.build());
    }
    public N endKafkaAuthorizationSimple(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends KafkaClusterTemplateFluentImpl<KafkaClusterSpecFluent.TemplateNested<N>> implements KafkaClusterSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaClusterTemplateBuilder builder;
    
            TemplateNestedImpl(KafkaClusterTemplate item){
                    this.builder = new KafkaClusterTemplateBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new KafkaClusterTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaClusterSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}


}
