package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaConnectBuilder extends KafkaConnectFluentImpl<KafkaConnectBuilder> implements VisitableBuilder<KafkaConnect,KafkaConnectBuilder>{

    KafkaConnectFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaConnectBuilder(){
            this(true);
    }
    public KafkaConnectBuilder(Boolean validationEnabled){
            this(new KafkaConnect(), validationEnabled);
    }
    public KafkaConnectBuilder(KafkaConnectFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaConnectBuilder(KafkaConnectFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaConnect(), validationEnabled);
    }
    public KafkaConnectBuilder(KafkaConnectFluent<?> fluent,KafkaConnect instance){
            this(fluent, instance, true);
    }
    public KafkaConnectBuilder(KafkaConnectFluent<?> fluent,KafkaConnect instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withSpec(instance.getSpec());

            fluent.withMetadata(instance.getMetadata());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaConnectBuilder(KafkaConnect instance){
            this(instance,true);
    }
    public KafkaConnectBuilder(KafkaConnect instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withSpec(instance.getSpec());

            this.withMetadata(instance.getMetadata());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaConnect build(){
            KafkaConnect buildable = new KafkaConnect();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setSpec(fluent.getSpec());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaConnectBuilder that = (KafkaConnectBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
