package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.status.KafkaConnectStatus;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.status.KafkaConnectStatusBuilder;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface KafkaConnectFluent<A extends KafkaConnectFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public KafkaConnectSpec getSpec();
    public KafkaConnectSpec buildSpec();
    public A withSpec(KafkaConnectSpec spec);
    public Boolean hasSpec();
    public KafkaConnectFluent.SpecNested<A> withNewSpec();
    public KafkaConnectFluent.SpecNested<A> withNewSpecLike(KafkaConnectSpec item);
    public KafkaConnectFluent.SpecNested<A> editSpec();
    public KafkaConnectFluent.SpecNested<A> editOrNewSpec();
    public KafkaConnectFluent.SpecNested<A> editOrNewSpecLike(KafkaConnectSpec item);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public KafkaConnectFluent.MetadataNested<A> withNewMetadata();
    public KafkaConnectFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public KafkaConnectFluent.MetadataNested<A> editMetadata();
    public KafkaConnectFluent.MetadataNested<A> editOrNewMetadata();
    public KafkaConnectFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public KafkaConnectStatus getStatus();
    public KafkaConnectStatus buildStatus();
    public A withStatus(KafkaConnectStatus status);
    public Boolean hasStatus();
    public KafkaConnectFluent.StatusNested<A> withNewStatus();
    public KafkaConnectFluent.StatusNested<A> withNewStatusLike(KafkaConnectStatus item);
    public KafkaConnectFluent.StatusNested<A> editStatus();
    public KafkaConnectFluent.StatusNested<A> editOrNewStatus();
    public KafkaConnectFluent.StatusNested<A> editOrNewStatusLike(KafkaConnectStatus item);

    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaConnectSpecFluent<KafkaConnectFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<KafkaConnectFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaConnectStatusFluent<KafkaConnectFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
