package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaConnectS2ISpecBuilder extends KafkaConnectS2ISpecFluentImpl<KafkaConnectS2ISpecBuilder> implements VisitableBuilder<KafkaConnectS2ISpec,KafkaConnectS2ISpecBuilder>{

    KafkaConnectS2ISpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaConnectS2ISpecBuilder(){
            this(true);
    }
    public KafkaConnectS2ISpecBuilder(Boolean validationEnabled){
            this(new KafkaConnectS2ISpec(), validationEnabled);
    }
    public KafkaConnectS2ISpecBuilder(KafkaConnectS2ISpecFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaConnectS2ISpecBuilder(KafkaConnectS2ISpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaConnectS2ISpec(), validationEnabled);
    }
    public KafkaConnectS2ISpecBuilder(KafkaConnectS2ISpecFluent<?> fluent,KafkaConnectS2ISpec instance){
            this(fluent, instance, true);
    }
    public KafkaConnectS2ISpecBuilder(KafkaConnectS2ISpecFluent<?> fluent,KafkaConnectS2ISpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBuildResources(instance.getBuildResources());

            fluent.withInsecureSourceRepository(instance.isInsecureSourceRepository());

            fluent.withConfig(instance.getConfig());

            fluent.withClientRackInitImage(instance.getClientRackInitImage());

            fluent.withRack(instance.getRack());

            fluent.withBootstrapServers(instance.getBootstrapServers());

            fluent.withTls(instance.getTls());

            fluent.withAuthentication(instance.getAuthentication());

            fluent.withBuild(instance.getBuild());

            fluent.withLogging(instance.getLogging());

            fluent.withReplicas(instance.getReplicas());

            fluent.withVersion(instance.getVersion());

            fluent.withImage(instance.getImage());

            fluent.withResources(instance.getResources());

            fluent.withLivenessProbe(instance.getLivenessProbe());

            fluent.withReadinessProbe(instance.getReadinessProbe());

            fluent.withJvmOptions(instance.getJvmOptions());

            fluent.withMetricsConfig(instance.getMetricsConfig());

            fluent.withMetrics(instance.getMetrics());

            fluent.withTracing(instance.getTracing());

            fluent.withAffinity(instance.getAffinity());

            fluent.withTolerations(instance.getTolerations());

            fluent.withTemplate(instance.getTemplate());

            fluent.withExternalConfiguration(instance.getExternalConfiguration());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaConnectS2ISpecBuilder(KafkaConnectS2ISpec instance){
            this(instance,true);
    }
    public KafkaConnectS2ISpecBuilder(KafkaConnectS2ISpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBuildResources(instance.getBuildResources());

            this.withInsecureSourceRepository(instance.isInsecureSourceRepository());

            this.withConfig(instance.getConfig());

            this.withClientRackInitImage(instance.getClientRackInitImage());

            this.withRack(instance.getRack());

            this.withBootstrapServers(instance.getBootstrapServers());

            this.withTls(instance.getTls());

            this.withAuthentication(instance.getAuthentication());

            this.withBuild(instance.getBuild());

            this.withLogging(instance.getLogging());

            this.withReplicas(instance.getReplicas());

            this.withVersion(instance.getVersion());

            this.withImage(instance.getImage());

            this.withResources(instance.getResources());

            this.withLivenessProbe(instance.getLivenessProbe());

            this.withReadinessProbe(instance.getReadinessProbe());

            this.withJvmOptions(instance.getJvmOptions());

            this.withMetricsConfig(instance.getMetricsConfig());

            this.withMetrics(instance.getMetrics());

            this.withTracing(instance.getTracing());

            this.withAffinity(instance.getAffinity());

            this.withTolerations(instance.getTolerations());

            this.withTemplate(instance.getTemplate());

            this.withExternalConfiguration(instance.getExternalConfiguration());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaConnectS2ISpec build(){
            KafkaConnectS2ISpec buildable = new KafkaConnectS2ISpec();
            buildable.setLogging(fluent.getLogging());
            buildable.setReplicas(fluent.getReplicas());
            buildable.setVersion(fluent.getVersion());
            buildable.setImage(fluent.getImage());
            buildable.setResources(fluent.getResources());
            buildable.setLivenessProbe(fluent.getLivenessProbe());
            buildable.setReadinessProbe(fluent.getReadinessProbe());
            buildable.setJvmOptions(fluent.getJvmOptions());
            buildable.setMetricsConfig(fluent.getMetricsConfig());
            buildable.setMetrics(fluent.getMetrics());
            buildable.setTracing(fluent.getTracing());
            buildable.setAffinity(fluent.getAffinity());
            buildable.setTolerations(fluent.getTolerations());
            buildable.setTemplate(fluent.getTemplate());
            buildable.setExternalConfiguration(fluent.getExternalConfiguration());
            buildable.setConfig(fluent.getConfig());
            buildable.setClientRackInitImage(fluent.getClientRackInitImage());
            buildable.setRack(fluent.getRack());
            buildable.setBootstrapServers(fluent.getBootstrapServers());
            buildable.setTls(fluent.getTls());
            buildable.setAuthentication(fluent.getAuthentication());
            buildable.setBuild(fluent.getBuild());
            buildable.setBuildResources(fluent.getBuildResources());
            buildable.setInsecureSourceRepository(fluent.isInsecureSourceRepository());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaConnectS2ISpecBuilder that = (KafkaConnectS2ISpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
