package io.strimzi.api.kafka.model;

import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirements;

public class KafkaConnectS2ISpecFluentImpl<A extends KafkaConnectS2ISpecFluent<A>> extends KafkaConnectSpecFluentImpl<A> implements KafkaConnectS2ISpecFluent<A>{

    private ResourceRequirements buildResources;
    private boolean insecureSourceRepository;

    public KafkaConnectS2ISpecFluentImpl(){
    }
    public KafkaConnectS2ISpecFluentImpl(KafkaConnectS2ISpec instance){
            this.withBuildResources(instance.getBuildResources());

            this.withInsecureSourceRepository(instance.isInsecureSourceRepository());

            this.withConfig(instance.getConfig());

            this.withClientRackInitImage(instance.getClientRackInitImage());

            this.withRack(instance.getRack());

            this.withBootstrapServers(instance.getBootstrapServers());

            this.withTls(instance.getTls());

            this.withAuthentication(instance.getAuthentication());

            this.withBuild(instance.getBuild());

            this.withLogging(instance.getLogging());

            this.withReplicas(instance.getReplicas());

            this.withVersion(instance.getVersion());

            this.withImage(instance.getImage());

            this.withResources(instance.getResources());

            this.withLivenessProbe(instance.getLivenessProbe());

            this.withReadinessProbe(instance.getReadinessProbe());

            this.withJvmOptions(instance.getJvmOptions());

            this.withMetricsConfig(instance.getMetricsConfig());

            this.withMetrics(instance.getMetrics());

            this.withTracing(instance.getTracing());

            this.withAffinity(instance.getAffinity());

            this.withTolerations(instance.getTolerations());

            this.withTemplate(instance.getTemplate());

            this.withExternalConfiguration(instance.getExternalConfiguration());

    }

    public ResourceRequirements getBuildResources(){
            return this.buildResources;
    }

    public A withBuildResources(ResourceRequirements buildResources){
            this.buildResources=buildResources; return (A) this;
    }

    public Boolean hasBuildResources(){
            return this.buildResources != null;
    }

    public boolean isInsecureSourceRepository(){
            return this.insecureSourceRepository;
    }

    public A withInsecureSourceRepository(boolean insecureSourceRepository){
            this.insecureSourceRepository=insecureSourceRepository; return (A) this;
    }

    public Boolean hasInsecureSourceRepository(){
            return true;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaConnectS2ISpecFluentImpl that = (KafkaConnectS2ISpecFluentImpl) o;
            if (buildResources != null ? !buildResources.equals(that.buildResources) :that.buildResources != null) return false;
            if (insecureSourceRepository != that.insecureSourceRepository) return false;
            return true;
    }




}
