package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.connect.build.Build;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent;
import io.strimzi.api.kafka.model.connect.build.BuildFluent;
import io.strimzi.api.kafka.model.connect.build.BuildBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import java.lang.StringBuffer;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent;
import java.lang.Object;
import java.util.Map;

public interface KafkaConnectSpecFluent<A extends KafkaConnectSpecFluent<A>> extends AbstractKafkaConnectSpecFluent<A>{


    public A addToConfig(String key,Object value);
    public A addToConfig(Map<String,Object> map);
    public A removeFromConfig(String key);
    public A removeFromConfig(Map<String,Object> map);
    public Map<String,Object> getConfig();
    public A withConfig(Map<String,Object> config);
    public Boolean hasConfig();
    public String getClientRackInitImage();
    public A withClientRackInitImage(String clientRackInitImage);
    public Boolean hasClientRackInitImage();
    public A withNewClientRackInitImage(String arg1);
    public A withNewClientRackInitImage(StringBuilder arg1);
    public A withNewClientRackInitImage(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildRack instead.
 * @return The buildable object.
 */
@Deprecated public Rack getRack();
    public Rack buildRack();
    public A withRack(Rack rack);
    public Boolean hasRack();
    public A withNewRack(String topologyKey);
    public KafkaConnectSpecFluent.RackNested<A> withNewRack();
    public KafkaConnectSpecFluent.RackNested<A> withNewRackLike(Rack item);
    public KafkaConnectSpecFluent.RackNested<A> editRack();
    public KafkaConnectSpecFluent.RackNested<A> editOrNewRack();
    public KafkaConnectSpecFluent.RackNested<A> editOrNewRackLike(Rack item);
    public String getBootstrapServers();
    public A withBootstrapServers(String bootstrapServers);
    public Boolean hasBootstrapServers();
    public A withNewBootstrapServers(String arg1);
    public A withNewBootstrapServers(StringBuilder arg1);
    public A withNewBootstrapServers(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildTls instead.
 * @return The buildable object.
 */
@Deprecated public KafkaConnectTls getTls();
    public KafkaConnectTls buildTls();
    public A withTls(KafkaConnectTls tls);
    public Boolean hasTls();
    public KafkaConnectSpecFluent.TlsNested<A> withNewTls();
    public KafkaConnectSpecFluent.TlsNested<A> withNewTlsLike(KafkaConnectTls item);
    public KafkaConnectSpecFluent.TlsNested<A> editTls();
    public KafkaConnectSpecFluent.TlsNested<A> editOrNewTls();
    public KafkaConnectSpecFluent.TlsNested<A> editOrNewTlsLike(KafkaConnectTls item);
    
/**
 * This method has been deprecated, please use method buildAuthentication instead.
 * @return The buildable object.
 */
@Deprecated public KafkaClientAuthentication getAuthentication();
    public KafkaClientAuthentication buildAuthentication();
    public A withAuthentication(KafkaClientAuthentication authentication);
    public Boolean hasAuthentication();
    public A withKafkaClientAuthenticationScramSha512(KafkaClientAuthenticationScramSha512 kafkaClientAuthenticationScramSha512);
    public KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512();
    public KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(KafkaClientAuthenticationScramSha512 item);
    public A withKafkaClientAuthenticationPlain(KafkaClientAuthenticationPlain kafkaClientAuthenticationPlain);
    public KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain();
    public KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(KafkaClientAuthenticationPlain item);
    public A withKafkaClientAuthenticationOAuth(KafkaClientAuthenticationOAuth kafkaClientAuthenticationOAuth);
    public KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth();
    public KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(KafkaClientAuthenticationOAuth item);
    public A withKafkaClientAuthenticationTls(KafkaClientAuthenticationTls kafkaClientAuthenticationTls);
    public KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls();
    public KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(KafkaClientAuthenticationTls item);
    
/**
 * This method has been deprecated, please use method buildBuild instead.
 * @return The buildable object.
 */
@Deprecated public Build getBuild();
    public Build buildBuild();
    public A withBuild(Build build);
    public Boolean hasBuild();
    public KafkaConnectSpecFluent.BuildNested<A> withNewBuild();
    public KafkaConnectSpecFluent.BuildNested<A> withNewBuildLike(Build item);
    public KafkaConnectSpecFluent.BuildNested<A> editBuild();
    public KafkaConnectSpecFluent.BuildNested<A> editOrNewBuild();
    public KafkaConnectSpecFluent.BuildNested<A> editOrNewBuildLike(Build item);

    public interface RackNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RackFluent<KafkaConnectSpecFluent.RackNested<N>>{

        
    public N and();    public N endRack();
}
    public interface TlsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaConnectTlsFluent<KafkaConnectSpecFluent.TlsNested<N>>{

        
    public N and();    public N endTls();
}
    public interface KafkaClientAuthenticationScramSha512Nested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaClientAuthenticationScramSha512Fluent<KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>>{

        
    public N and();    public N endKafkaClientAuthenticationScramSha512();
}
    public interface KafkaClientAuthenticationPlainNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaClientAuthenticationPlainFluent<KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<N>>{

        
    public N and();    public N endKafkaClientAuthenticationPlain();
}
    public interface KafkaClientAuthenticationOAuthNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaClientAuthenticationOAuthFluent<KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<N>>{

        
    public N and();    public N endKafkaClientAuthenticationOAuth();
}
    public interface KafkaClientAuthenticationTlsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaClientAuthenticationTlsFluent<KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<N>>{

        
    public N and();    public N endKafkaClientAuthenticationTls();
}
    public interface BuildNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildFluent<KafkaConnectSpecFluent.BuildNested<N>>{

        
    public N and();    public N endBuild();
}


}
