package io.strimzi.api.kafka.model;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class KafkaConnectorSpecFluentImpl<A extends KafkaConnectorSpecFluent<A>> extends AbstractConnectorSpecFluentImpl<A> implements KafkaConnectorSpecFluent<A>{

    private String className;

    public KafkaConnectorSpecFluentImpl(){
    }
    public KafkaConnectorSpecFluentImpl(KafkaConnectorSpec instance){
            this.withClassName(instance.getClassName());

            this.withTasksMax(instance.getTasksMax());

            this.withPause(instance.getPause());

            this.withConfig(instance.getConfig());

    }

    public String getClassName(){
            return this.className;
    }

    public A withClassName(String className){
            this.className=className; return (A) this;
    }

    public Boolean hasClassName(){
            return this.className != null;
    }

    public A withNewClassName(String arg1){
            return (A)withClassName(new String(arg1));
    }

    public A withNewClassName(StringBuilder arg1){
            return (A)withClassName(new String(arg1));
    }

    public A withNewClassName(StringBuffer arg1){
            return (A)withClassName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaConnectorSpecFluentImpl that = (KafkaConnectorSpecFluentImpl) o;
            if (className != null ? !className.equals(that.className) :that.className != null) return false;
            return true;
    }




}
